/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.visitor;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import org.drools.compiler.DrlParser;
import org.drools.lang.descr.PackageDescr;
import org.drools.verifier.components.VerifierComponentType;
import org.drools.verifier.data.VerifierComponent;
import org.drools.verifier.data.VerifierData;
import org.drools.verifier.data.VerifierReportFactory;
import org.drools.verifier.visitor.PackageDescrVisitor;
import org.junit.Assert;
import org.junit.Test;
import org.kie.builder.conf.LanguageLevelOption;

public class NestedPatternsTest {
    @Test
    public void runVisitor() throws Exception {
        VerifierData data = VerifierReportFactory.newVerifierData();
        PackageDescrVisitor visitor = new PackageDescrVisitor(data, Collections.EMPTY_LIST);
        Assert.assertNotNull((Object)data);
        InputStreamReader drlReader = new InputStreamReader(this.getClass().getResourceAsStream("NestedPatterns.drl"));
        PackageDescr packageDescr = new DrlParser(LanguageLevelOption.DRL5).parse((Reader)drlReader);
        Assert.assertNotNull((Object)packageDescr);
        visitor.visitPackageDescr(packageDescr);
        Collection all = data.getAll();
        int patternCount = 0;
        for (VerifierComponent verifierComponent : all) {
            if (!verifierComponent.getVerifierComponentType().equals(VerifierComponentType.PATTERN)) continue;
            ++patternCount;
        }
        Assert.assertEquals((long)4L, (long)patternCount);
        Collection patterns = data.getAll(VerifierComponentType.PATTERN);
        Assert.assertNotNull((Object)patterns);
        Assert.assertEquals((long)4L, (long)patterns.size());
        Collection restrictions = data.getAll(VerifierComponentType.RESTRICTION);
        Assert.assertNotNull((Object)restrictions);
        Assert.assertEquals((long)3L, (long)restrictions.size());
    }
}

