/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.drools.core.StatelessSession;
import org.drools.core.StatelessSessionResult;
import org.drools.core.base.RuleNameMatchesAgendaFilter;
import org.drools.core.spi.AgendaFilter;
import org.drools.verifier.TestBaseOld;
import org.drools.verifier.data.VerifierReport;
import org.drools.verifier.data.VerifierReportFactory;
import org.drools.verifier.report.components.Gap;
import org.junit.Assert;
import org.junit.Test;

public class RangeCheckDoublesTest
extends TestBaseOld {
    @Test
    public void testSmallerOrEqual() throws Exception {
        StatelessSession session = this.getStatelessSession(this.getClass().getResourceAsStream("rangeChecks/Doubles.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Range check for doubles, if smaller than or equal is missing"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("MissingRangesForDoubles.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        StatelessSessionResult sessionResult = session.executeWithResults(testData);
        Iterator iter = sessionResult.iterateObjects();
        HashSet<String> rulesThatHadErrors = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof Gap)) continue;
            rulesThatHadErrors.add(((Gap)o).getRuleName());
        }
        Assert.assertTrue((boolean)rulesThatHadErrors.remove("Double gap rule 4a"));
        Assert.assertTrue((boolean)rulesThatHadErrors.remove("Double gap rule 5a"));
        if (!rulesThatHadErrors.isEmpty()) {
            for (String string : rulesThatHadErrors) {
                Assert.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    @Test
    public void testGreaterOrEqual() throws Exception {
        StatelessSession session = this.getStatelessSession(this.getClass().getResourceAsStream("rangeChecks/Doubles.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Range check for doubles, if greater than or equal is missing"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("MissingRangesForDoubles.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        StatelessSessionResult sessionResult = session.executeWithResults(testData);
        Iterator iter = sessionResult.iterateObjects();
        HashSet<String> rulesThatHadErrors = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof Gap)) continue;
            rulesThatHadErrors.add(((Gap)o).getRuleName());
        }
        Assert.assertTrue((boolean)rulesThatHadErrors.remove("Double gap rule 4b"));
        Assert.assertTrue((boolean)rulesThatHadErrors.remove("Double gap rule 5b"));
        if (!rulesThatHadErrors.isEmpty()) {
            for (String string : rulesThatHadErrors) {
                Assert.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    @Test
    public void testEqualAndGreaterThan() throws Exception {
        StatelessSession session = this.getStatelessSession(this.getClass().getResourceAsStream("rangeChecks/Doubles.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Range check for doubles, equal and greater than"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("MissingRangesForDoubles.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        StatelessSessionResult sessionResult = session.executeWithResults(testData);
        Iterator iter = sessionResult.iterateObjects();
        HashSet<String> rulesThatHadErrors = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof Gap)) continue;
            rulesThatHadErrors.add(((Gap)o).getRuleName());
        }
        Assert.assertTrue((boolean)rulesThatHadErrors.remove("Double gap rule 1"));
        Assert.assertTrue((boolean)rulesThatHadErrors.remove("Double gap rule 7b"));
        Assert.assertTrue((boolean)rulesThatHadErrors.remove("Double gap rule 3"));
        Assert.assertTrue((boolean)rulesThatHadErrors.remove("Double gap rule 9b"));
        if (!rulesThatHadErrors.isEmpty()) {
            for (String string : rulesThatHadErrors) {
                Assert.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    @Test
    public void testEqualAndSmallerThan() throws Exception {
        StatelessSession session = this.getStatelessSession(this.getClass().getResourceAsStream("rangeChecks/Doubles.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Range check for doubles, equal and smaller than"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("MissingRangesForDoubles.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        StatelessSessionResult sessionResult = session.executeWithResults(testData);
        Iterator iter = sessionResult.iterateObjects();
        HashSet<String> rulesThatHadErrors = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof Gap)) continue;
            rulesThatHadErrors.add(((Gap)o).getRuleName());
        }
        Assert.assertTrue((boolean)rulesThatHadErrors.remove("Double gap rule 1"));
        Assert.assertTrue((boolean)rulesThatHadErrors.remove("Double gap rule 6b"));
        Assert.assertTrue((boolean)rulesThatHadErrors.remove("Double gap rule 2"));
        Assert.assertTrue((boolean)rulesThatHadErrors.remove("Double gap rule 9a"));
        if (!rulesThatHadErrors.isEmpty()) {
            for (String string : rulesThatHadErrors) {
                Assert.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }
}

