/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.incoherence;

import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.drools.core.StatelessSession;
import org.drools.core.base.RuleNameMatchesAgendaFilter;
import org.drools.core.spi.AgendaFilter;
import org.drools.verifier.DefaultVerifierConfiguration;
import org.drools.verifier.TestBaseOld;
import org.drools.verifier.Verifier;
import org.drools.verifier.VerifierConfiguration;
import org.drools.verifier.builder.ScopesAgendaFilter;
import org.drools.verifier.builder.VerifierBuilder;
import org.drools.verifier.builder.VerifierBuilderFactory;
import org.drools.verifier.components.Pattern;
import org.drools.verifier.data.VerifierReport;
import org.drools.verifier.data.VerifierReportFactory;
import org.drools.verifier.report.components.Severity;
import org.drools.verifier.report.components.VerifierMessage;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.io.ResourceType;
import org.kie.internal.io.ResourceFactory;

public class IncoherentRestrictionsTest
extends TestBaseOld {
    @Test
    public void testApprovedTrueAndNotTrue() {
        VerifierBuilder vBuilder = VerifierBuilderFactory.newVerifierBuilder();
        Assert.assertFalse((boolean)vBuilder.hasErrors());
        Assert.assertEquals((long)0L, (long)vBuilder.getErrors().size());
        String str = "";
        str = str + "package mortgages\n";
        str = str + "rule \"Bankruptcy history\"\n";
        str = str + "salience 10\n";
        str = str + "dialect \"mvel\"\n";
        str = str + "when\n";
        str = str + "Applicant( approved == \"true\" , approved != \"true\" )\n";
        str = str + "then\n";
        str = str + "end";
        DefaultVerifierConfiguration conf = new DefaultVerifierConfiguration();
        Verifier verifier = VerifierBuilderFactory.newVerifierBuilder().newVerifier((VerifierConfiguration)conf);
        verifier.addResourcesToVerify(ResourceFactory.newReaderResource((Reader)new StringReader(str)), ResourceType.DRL);
        Assert.assertFalse((boolean)verifier.hasErrors());
        Assert.assertEquals((long)0L, (long)verifier.getErrors().size());
        boolean works = verifier.fireAnalysis(new ScopesAgendaFilter(true, "knowledge-package"));
        Assert.assertTrue((boolean)works);
        VerifierReport result = verifier.getResult();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)3L, (long)result.getBySeverity(Severity.ERROR).size());
        Assert.assertEquals((long)1L, (long)result.getBySeverity(Severity.WARNING).size());
        Assert.assertEquals((long)0L, (long)result.getBySeverity(Severity.NOTE).size());
    }

    @Test
    public void testIncoherentLiteralRestrictionsInSubPattern() throws Exception {
        StatelessSession session = this.getStatelessSession(this.getClass().getResourceAsStream("Restrictions.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Incoherent LiteralRestrictions in pattern possibility"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("RestrictionsTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        session.executeWithResults(testData);
        Iterator iter = result.getBySeverity(Severity.ERROR).iterator();
        HashSet<String> rulesThatHadErrors = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            Pattern pattern = (Pattern)((VerifierMessage)o).getFaulty();
            rulesThatHadErrors.add(pattern.getRuleName());
        }
        Assert.assertTrue((boolean)rulesThatHadErrors.remove("Incoherent restrictions 1"));
        Assert.assertTrue((boolean)rulesThatHadErrors.remove("Incoherent restrictions 2"));
        if (!rulesThatHadErrors.isEmpty()) {
            for (String string : rulesThatHadErrors) {
                Assert.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    @Test
    public void testIncoherentLiteralRestrictionsInSubPatternImpossibleRanges() throws Exception {
        StatelessSession session = this.getStatelessSession(this.getClass().getResourceAsStream("Restrictions.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Incoherent LiteralRestrictions with ranges in pattern possibility, impossible ranges"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("RestrictionsTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        session.executeWithResults(testData);
        Iterator iter = result.getBySeverity(Severity.ERROR).iterator();
        HashSet<String> rulesThatHadErrors = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            Pattern pattern = (Pattern)((VerifierMessage)o).getFaulty();
            rulesThatHadErrors.add(pattern.getRuleName());
        }
        Assert.assertTrue((boolean)rulesThatHadErrors.remove("Incoherent restrictions 8"));
        if (!rulesThatHadErrors.isEmpty()) {
            for (String string : rulesThatHadErrors) {
                Assert.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    @Test
    public void testIncoherentLiteralRestrictionsInSubPatternImpossibleEqualityLess() throws Exception {
        StatelessSession session = this.getStatelessSession(this.getClass().getResourceAsStream("Restrictions.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Incoherent LiteralRestrictions with ranges in pattern possibility, impossible equality less or equal"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("RestrictionsTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        session.executeWithResults(testData);
        Iterator iter = result.getBySeverity(Severity.ERROR).iterator();
        HashSet<String> rulesThatHadErrors = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            Pattern pattern = (Pattern)((VerifierMessage)o).getFaulty();
            rulesThatHadErrors.add(pattern.getRuleName());
        }
        Assert.assertTrue((boolean)rulesThatHadErrors.remove("Incoherent restrictions 9"));
        Assert.assertTrue((boolean)rulesThatHadErrors.remove("Incoherent restrictions 11"));
        if (!rulesThatHadErrors.isEmpty()) {
            for (String string : rulesThatHadErrors) {
                Assert.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    @Test
    public void testIncoherentLiteralRestrictionsInSubPatternImpossibleEqualityGreater() throws Exception {
        StatelessSession session = this.getStatelessSession(this.getClass().getResourceAsStream("Restrictions.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Incoherent LiteralRestrictions with ranges in pattern possibility, impossible equality greater"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("RestrictionsTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        session.executeWithResults(testData);
        Iterator iter = result.getBySeverity(Severity.ERROR).iterator();
        HashSet<String> rulesThatHadErrors = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            Pattern pattern = (Pattern)((VerifierMessage)o).getFaulty();
            rulesThatHadErrors.add(pattern.getRuleName());
        }
        Assert.assertTrue((boolean)rulesThatHadErrors.remove("Incoherent restrictions 10"));
        if (!rulesThatHadErrors.isEmpty()) {
            for (String string : rulesThatHadErrors) {
                Assert.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    @Test
    public void testIncoherentLiteralRestrictionsInSubPatternImpossibleRange() throws Exception {
        StatelessSession session = this.getStatelessSession(this.getClass().getResourceAsStream("Restrictions.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Incoherent LiteralRestrictions with ranges in pattern possibility, impossible range"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("RestrictionsTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        session.executeWithResults(testData);
        Iterator iter = result.getBySeverity(Severity.ERROR).iterator();
        HashSet<String> rulesThatHadErrors = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            Pattern pattern = (Pattern)((VerifierMessage)o).getFaulty();
            rulesThatHadErrors.add(pattern.getRuleName());
        }
        Assert.assertTrue((boolean)rulesThatHadErrors.remove("Incoherent restrictions 7"));
        if (!rulesThatHadErrors.isEmpty()) {
            for (String string : rulesThatHadErrors) {
                Assert.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    @Test
    public void testIncoherentVariableRestrictionsInSubPattern() throws Exception {
        StatelessSession session = this.getStatelessSession(this.getClass().getResourceAsStream("Restrictions.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Incoherent VariableRestrictions in pattern possibility"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("RestrictionsTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        session.executeWithResults(testData);
        Iterator iter = result.getBySeverity(Severity.ERROR).iterator();
        HashSet<String> rulesThatHadErrors = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            Pattern pattern = (Pattern)((VerifierMessage)o).getFaulty();
            rulesThatHadErrors.add(pattern.getRuleName());
        }
        Assert.assertTrue((boolean)rulesThatHadErrors.remove("Incoherent restrictions 3"));
        Assert.assertTrue((boolean)rulesThatHadErrors.remove("Incoherent restrictions 4"));
        Assert.assertTrue((boolean)rulesThatHadErrors.remove("Incoherent restrictions 5"));
        if (!rulesThatHadErrors.isEmpty()) {
            for (String string : rulesThatHadErrors) {
                Assert.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    @Test
    public void testIncoherentVariableRestrictionsInSubPatternImpossibleRange() throws Exception {
        StatelessSession session = this.getStatelessSession(this.getClass().getResourceAsStream("Restrictions.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Incoherent VariableRestrictions in pattern possibility, impossible range"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("RestrictionsTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        session.executeWithResults(testData);
        Iterator iter = result.getBySeverity(Severity.ERROR).iterator();
        HashSet<String> rulesThatHadErrors = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            Pattern pattern = (Pattern)((VerifierMessage)o).getFaulty();
            rulesThatHadErrors.add(pattern.getRuleName());
        }
        Assert.assertTrue((boolean)rulesThatHadErrors.remove("Incoherent restrictions 6"));
        if (!rulesThatHadErrors.isEmpty()) {
            for (String string : rulesThatHadErrors) {
                Assert.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }
}

