/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.incoherence;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.drools.core.StatelessSession;
import org.drools.core.base.RuleNameMatchesAgendaFilter;
import org.drools.core.spi.AgendaFilter;
import org.drools.verifier.TestBaseOld;
import org.drools.verifier.components.VerifierRule;
import org.drools.verifier.data.VerifierReport;
import org.drools.verifier.data.VerifierReportFactory;
import org.drools.verifier.report.components.Severity;
import org.drools.verifier.report.components.VerifierMessage;
import org.junit.Assert;
import org.junit.Test;

public class IncoherentPatternsTest
extends TestBaseOld {
    @Test
    public void testIncoherentPatternsInSubRule() throws Exception {
        StatelessSession session = this.getStatelessSession(this.getClass().getResourceAsStream("Patterns.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Incoherent Patterns in rule possibility"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("PatternsTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        session.executeWithResults(testData);
        Iterator iter = result.getBySeverity(Severity.WARNING).iterator();
        HashSet<String> rulesThatHadErrors = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            VerifierRule rule = (VerifierRule)((VerifierMessage)o).getFaulty();
            rulesThatHadErrors.add(rule.getName());
        }
        Assert.assertTrue((boolean)rulesThatHadErrors.remove("Incoherent patterns 1"));
        Assert.assertTrue((boolean)rulesThatHadErrors.remove("Incoherent patterns 2"));
        Assert.assertTrue((boolean)rulesThatHadErrors.remove("Incoherent patterns 7"));
        if (!rulesThatHadErrors.isEmpty()) {
            for (String string : rulesThatHadErrors) {
                Assert.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    @Test
    public void testIncoherentPatternsInSubRuleVariables() throws Exception {
        StatelessSession session = this.getStatelessSession(this.getClass().getResourceAsStream("Patterns.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Incoherent Patterns in rule possibility, variables"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("PatternsTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        session.executeWithResults(testData);
        Iterator iter = result.getBySeverity(Severity.WARNING).iterator();
        HashSet<String> rulesThatHadErrors = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            VerifierRule rule = (VerifierRule)((VerifierMessage)o).getFaulty();
            rulesThatHadErrors.add(rule.getName());
        }
        Assert.assertTrue((boolean)rulesThatHadErrors.remove("Incoherent patterns 3"));
        Assert.assertTrue((boolean)rulesThatHadErrors.remove("Incoherent patterns 4"));
        Assert.assertTrue((boolean)rulesThatHadErrors.remove("Incoherent patterns 5"));
        Assert.assertTrue((boolean)rulesThatHadErrors.remove("Incoherent patterns 6"));
        if (!rulesThatHadErrors.isEmpty()) {
            for (String string : rulesThatHadErrors) {
                Assert.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    @Test
    public void testIncoherentPatternsInSubRuleRangesLess() throws Exception {
        StatelessSession session = this.getStatelessSession(this.getClass().getResourceAsStream("Patterns.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Incoherent Patterns in rule possibility, ranges when not conflicts with lesser value"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("PatternsTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        session.executeWithResults(testData);
        Iterator iter = result.getBySeverity(Severity.WARNING).iterator();
        HashSet<String> rulesThatHadErrors = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            VerifierRule rule = (VerifierRule)((VerifierMessage)o).getFaulty();
            rulesThatHadErrors.add(rule.getName());
        }
        Assert.assertTrue((boolean)rulesThatHadErrors.remove("Incoherent patterns 8"));
        Assert.assertTrue((boolean)rulesThatHadErrors.remove("Incoherent patterns 12"));
        if (!rulesThatHadErrors.isEmpty()) {
            for (String string : rulesThatHadErrors) {
                Assert.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    @Test
    public void testIncoherentPatternsInSubRuleRangesGreater() throws Exception {
        StatelessSession session = this.getStatelessSession(this.getClass().getResourceAsStream("Patterns.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Incoherent Patterns in rule possibility, ranges when not conflicts with greater value"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("PatternsTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        session.executeWithResults(testData);
        Iterator iter = result.getBySeverity(Severity.WARNING).iterator();
        HashSet<String> rulesThatHadErrors = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            VerifierRule rule = (VerifierRule)((VerifierMessage)o).getFaulty();
            rulesThatHadErrors.add(rule.getName());
        }
        Assert.assertTrue((boolean)rulesThatHadErrors.remove("Incoherent patterns 9"));
        Assert.assertTrue((boolean)rulesThatHadErrors.remove("Incoherent patterns 14"));
        if (!rulesThatHadErrors.isEmpty()) {
            for (String string : rulesThatHadErrors) {
                Assert.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    @Test
    public void testIncoherentPatternsInSubRuleRangesEqualOrUnequal() throws Exception {
        StatelessSession session = this.getStatelessSession(this.getClass().getResourceAsStream("Patterns.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Incoherent Patterns in rule possibility, ranges when not conflicts with equal or unequal value"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("PatternsTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        session.executeWithResults(testData);
        Iterator iter = result.getBySeverity(Severity.WARNING).iterator();
        HashSet<String> rulesThatHadErrors = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            VerifierRule rule = (VerifierRule)((VerifierMessage)o).getFaulty();
            rulesThatHadErrors.add(rule.getName());
        }
        Assert.assertTrue((boolean)rulesThatHadErrors.remove("Incoherent patterns 10"));
        Assert.assertTrue((boolean)rulesThatHadErrors.remove("Incoherent patterns 15"));
        if (!rulesThatHadErrors.isEmpty()) {
            for (String string : rulesThatHadErrors) {
                Assert.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    @Test
    public void testIncoherentPatternsInSubRuleRangesEqualOrUnequalVariables() throws Exception {
        StatelessSession session = this.getStatelessSession(this.getClass().getResourceAsStream("Patterns.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Incoherent Patterns in rule possibility, ranges when not conflicts with equal or unequal variables"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("PatternsTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        session.executeWithResults(testData);
        Iterator iter = result.getBySeverity(Severity.WARNING).iterator();
        HashSet<String> rulesThatHadErrors = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            VerifierRule rule = (VerifierRule)((VerifierMessage)o).getFaulty();
            rulesThatHadErrors.add(rule.getName());
        }
        Assert.assertTrue((boolean)rulesThatHadErrors.remove("Incoherent patterns 11"));
        if (!rulesThatHadErrors.isEmpty()) {
            for (String string : rulesThatHadErrors) {
                Assert.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    @Test
    public void testIncoherentPatternsInSubRuleRangesEqualValue() throws Exception {
        StatelessSession session = this.getStatelessSession(this.getClass().getResourceAsStream("Patterns.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Incoherent Patterns in rule possibility, ranges when not conflicts with equal value"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("PatternsTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        session.executeWithResults(testData);
        Iterator iter = result.getBySeverity(Severity.WARNING).iterator();
        HashSet<String> rulesThatHadErrors = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            VerifierRule rule = (VerifierRule)((VerifierMessage)o).getFaulty();
            rulesThatHadErrors.add(rule.getName());
        }
        Assert.assertTrue((boolean)rulesThatHadErrors.remove("Incoherent patterns 16"));
        if (!rulesThatHadErrors.isEmpty()) {
            for (String string : rulesThatHadErrors) {
                Assert.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    @Test
    public void testIncoherentPatternsInSubRuleRangesEqualVariable() throws Exception {
        StatelessSession session = this.getStatelessSession(this.getClass().getResourceAsStream("Patterns.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Incoherent Patterns in rule possibility, ranges when not conflicts with equal variable"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("PatternsTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        session.executeWithResults(testData);
        Iterator iter = result.getBySeverity(Severity.WARNING).iterator();
        HashSet<String> rulesThatHadErrors = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            VerifierRule rule = (VerifierRule)((VerifierMessage)o).getFaulty();
            rulesThatHadErrors.add(rule.getName());
        }
        Assert.assertTrue((boolean)rulesThatHadErrors.remove("Incoherent patterns 13"));
        if (!rulesThatHadErrors.isEmpty()) {
            for (String string : rulesThatHadErrors) {
                Assert.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }
}

