/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import org.drools.compiler.compiler.DrlParser;
import org.drools.compiler.compiler.DroolsParserException;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.verifier.components.Field;
import org.drools.verifier.components.Variable;
import org.drools.verifier.components.VerifierComponentType;
import org.drools.verifier.data.VerifierData;
import org.drools.verifier.data.VerifierReportFactory;
import org.drools.verifier.visitor.PackageDescrVisitor;
import org.junit.Assert;
import org.junit.Before;
import org.kie.internal.builder.conf.LanguageLevelOption;

public class TestBase {
    protected VerifierData verifierData;
    protected PackageDescrVisitor packageDescrVisitor;

    @Before
    public void setUp() throws Exception {
        this.verifierData = VerifierReportFactory.newVerifierData();
        this.packageDescrVisitor = new PackageDescrVisitor(this.verifierData, Collections.emptyList());
    }

    protected PackageDescr getPackageDescr(InputStream resourceAsStream) throws DroolsParserException {
        InputStreamReader drlReader = new InputStreamReader(resourceAsStream);
        return new DrlParser(LanguageLevelOption.DRL5).parse((Reader)drlReader);
    }

    protected void assertContainsVariable(String ruleName, String variableName) {
        Variable variable = this.verifierData.getVariableByRuleAndVariableName(ruleName, variableName);
        Assert.assertNotNull((String)String.format("Could not find Variable : %s ", variableName), (Object)variable);
    }

    protected void assertContainsField(String name) {
        Collection allFields = this.verifierData.getAll(VerifierComponentType.FIELD);
        for (Field field : allFields) {
            if (!name.equals(field.getName())) continue;
            return;
        }
        Assert.fail((String)"Could not find Field");
    }

    protected void assertContainsFields(int amount) {
        Collection allFields = this.verifierData.getAll(VerifierComponentType.FIELD);
        Assert.assertEquals((long)amount, (long)allFields.size());
    }
}

