/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.alwaysTrue;

import java.util.ArrayList;
import java.util.Iterator;
import org.drools.compiler.lang.descr.PatternDescr;
import org.drools.core.StatelessSession;
import org.drools.core.StatelessSessionResult;
import org.drools.core.base.RuleNameMatchesAgendaFilter;
import org.drools.core.spi.AgendaFilter;
import org.drools.verifier.TestBaseOld;
import org.drools.verifier.VerifierComponentMockFactory;
import org.drools.verifier.components.LiteralRestriction;
import org.drools.verifier.components.Pattern;
import org.drools.verifier.components.PatternComponent;
import org.drools.verifier.components.SubPattern;
import org.drools.verifier.components.VariableRestriction;
import org.drools.verifier.components.VerifierRule;
import org.drools.verifier.data.VerifierReport;
import org.drools.verifier.data.VerifierReportFactory;
import org.drools.verifier.report.components.AlwaysTrue;
import org.drools.verifier.report.components.Cause;
import org.drools.verifier.report.components.Opposites;
import org.drools.verifier.report.components.Severity;
import org.drools.verifier.report.components.VerifierMessage;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class AlwaysTruePatternTest
extends TestBaseOld {
    @Test
    public void testPatternPossibilities() throws Exception {
        StatelessSession session = this.getStatelessSession(this.getClass().getResourceAsStream("Patterns.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Pattern possibility that is always true"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        ArrayList<Object> data = new ArrayList<Object>();
        session.setGlobal("result", (Object)result);
        Pattern pattern1 = VerifierComponentMockFactory.createPattern1();
        LiteralRestriction r1 = LiteralRestriction.createRestriction((Pattern)pattern1, (String)"");
        LiteralRestriction r2 = LiteralRestriction.createRestriction((Pattern)pattern1, (String)"");
        Opposites o1 = new Opposites((Cause)r1, (Cause)r2);
        SubPattern pp1 = new SubPattern(pattern1, 0);
        pp1.add((PatternComponent)r1);
        pp1.add((PatternComponent)r2);
        VariableRestriction r3 = new VariableRestriction(pattern1);
        VariableRestriction r4 = new VariableRestriction(pattern1);
        Opposites o2 = new Opposites((Cause)r1, (Cause)r2);
        SubPattern pp2 = new SubPattern(pattern1, 1);
        pp2.add((PatternComponent)r1);
        pp2.add((PatternComponent)r2);
        Pattern pattern2 = VerifierComponentMockFactory.createPattern2();
        LiteralRestriction r5 = LiteralRestriction.createRestriction((Pattern)pattern2, (String)"");
        LiteralRestriction r6 = LiteralRestriction.createRestriction((Pattern)pattern2, (String)"");
        SubPattern pp3 = new SubPattern(pattern2, 0);
        pp3.add((PatternComponent)r5);
        pp3.add((PatternComponent)r6);
        VariableRestriction r7 = new VariableRestriction(pattern2);
        VariableRestriction r8 = new VariableRestriction(pattern2);
        Opposites o4 = new Opposites((Cause)r7, (Cause)r8);
        SubPattern pp4 = new SubPattern(pattern2, 1);
        pp4.add((PatternComponent)r7);
        pp4.add((PatternComponent)r8);
        data.add(pattern1);
        data.add(r1);
        data.add(r2);
        data.add(r3);
        data.add(r4);
        data.add(o1);
        data.add(o2);
        data.add(pp1);
        data.add(pp2);
        data.add(pattern2);
        data.add(r5);
        data.add(r6);
        data.add(r7);
        data.add(r8);
        data.add(o4);
        data.add(pp3);
        data.add(pp4);
        StatelessSessionResult sessionResult = session.executeWithResults(data);
        Iterator iter = sessionResult.iterateObjects();
        boolean pp1true = false;
        boolean pp2true = false;
        boolean pp3true = false;
        boolean pp4true = false;
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof AlwaysTrue)) continue;
            AlwaysTrue alwaysTrue = (AlwaysTrue)o;
            if (!pp1true) {
                pp1true = alwaysTrue.getCause().equals(pp1);
            }
            if (!pp2true) {
                pp2true = alwaysTrue.getCause().equals(pp2);
            }
            if (!pp3true) {
                pp3true = alwaysTrue.getCause().equals(pp3);
            }
            if (pp4true) continue;
            pp4true = alwaysTrue.getCause().equals(pp4);
        }
        Assert.assertTrue((boolean)pp1true);
        Assert.assertTrue((boolean)pp2true);
        Assert.assertFalse((boolean)pp3true);
        Assert.assertTrue((boolean)pp4true);
    }

    @Test
    @Ignore
    public void testPatterns() throws Exception {
        StatelessSession session = this.getStatelessSession(this.getClass().getResourceAsStream("Patterns.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Pattern that is always true"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        ArrayList<Object> data = new ArrayList<Object>();
        session.setGlobal("result", (Object)result);
        VerifierRule rule1 = VerifierComponentMockFactory.createRule1();
        Pattern pattern1 = VerifierComponentMockFactory.createPattern1();
        SubPattern pp1 = new SubPattern(pattern1, 0);
        AlwaysTrue alwaysTrue1 = new AlwaysTrue((Cause)pp1, new Cause[0]);
        SubPattern pp2 = new SubPattern(pattern1, 1);
        AlwaysTrue alwaysTrue2 = new AlwaysTrue((Cause)pp2, new Cause[0]);
        Pattern pattern2 = new Pattern(new PatternDescr("objectType2", "testPattern2"), rule1);
        pattern2.setName("testPattern2");
        SubPattern pp3 = new SubPattern(pattern2, 0);
        SubPattern pp4 = new SubPattern(pattern2, 1);
        AlwaysTrue alwaysTrue4 = new AlwaysTrue((Cause)pp4, new Cause[0]);
        data.add(rule1);
        data.add(pattern1);
        data.add(pp1);
        data.add(pp2);
        data.add(alwaysTrue1);
        data.add(alwaysTrue2);
        data.add(pattern2);
        data.add(pp3);
        data.add(pp4);
        data.add(alwaysTrue4);
        session.executeWithResults(data);
        Iterator iter = result.getBySeverity(Severity.NOTE).iterator();
        boolean works = false;
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            VerifierMessage message = (VerifierMessage)o;
            if (message.getFaulty().equals(pattern1)) {
                works = true;
                continue;
            }
            Assert.fail((String)"There can be only one. (And this is not the one)");
        }
        Assert.assertEquals((long)0L, (long)result.getBySeverity(Severity.ERROR).size());
        Assert.assertEquals((long)0L, (long)result.getBySeverity(Severity.WARNING).size());
        Assert.assertEquals((long)1L, (long)result.getBySeverity(Severity.NOTE).size());
        Assert.assertTrue((boolean)works);
    }
}

