/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.consequence;

import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.drools.core.StatelessSession;
import org.drools.core.base.RuleNameMatchesAgendaFilter;
import org.drools.core.spi.AgendaFilter;
import org.drools.verifier.TestBaseOld;
import org.drools.verifier.data.VerifierReport;
import org.drools.verifier.data.VerifierReportFactory;
import org.drools.verifier.report.components.Severity;
import org.drools.verifier.report.components.VerifierMessage;
import org.junit.Assert;
import org.junit.Test;

public class ConsequenceTest
extends TestBaseOld {
    @Test
    public void testMissingConsequence() throws Exception {
        InputStream in = this.getClass().getResourceAsStream("Consequence.drl");
        StatelessSession session = this.getStatelessSession(in);
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("No action - possibly commented out"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("ConsequenceTest2.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        session.executeWithResults(testData);
        Iterator iterator = result.getBySeverity(Severity.WARNING).iterator();
        HashSet rulesThatHadErrors = new HashSet();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (!(o instanceof VerifierMessage)) continue;
            VerifierMessage message = (VerifierMessage)o;
            rulesThatHadErrors.addAll(message.getImpactedRules().values());
        }
        Assert.assertFalse((boolean)rulesThatHadErrors.contains("Has a consequence 1"));
        Assert.assertTrue((boolean)rulesThatHadErrors.remove("Missing consequence 1"));
        Assert.assertTrue((boolean)rulesThatHadErrors.remove("Missing consequence 2"));
        if (!rulesThatHadErrors.isEmpty()) {
            for (String string : rulesThatHadErrors) {
                Assert.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }
}

