/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.incompatibility;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.drools.core.StatelessSession;
import org.drools.core.StatelessSessionResult;
import org.drools.core.base.RuleNameMatchesAgendaFilter;
import org.drools.core.spi.AgendaFilter;
import org.drools.verifier.TestBaseOld;
import org.drools.verifier.VerifierComponentMockFactory;
import org.drools.verifier.components.LiteralRestriction;
import org.drools.verifier.components.Pattern;
import org.drools.verifier.components.PatternComponent;
import org.drools.verifier.components.SubPattern;
import org.drools.verifier.components.VerifierComponentType;
import org.drools.verifier.incompatibility.IncompatibilityBase;
import org.drools.verifier.report.components.Cause;
import org.drools.verifier.report.components.Incompatibility;
import org.junit.Assert;
import org.junit.Test;

public class IncompatibilityPatternsTest
extends IncompatibilityBase {
    @Test
    public void testPatternsPossibilitiesIncompatibility() throws Exception {
        StatelessSession session = this.getStatelessSession(this.getClass().getResourceAsStream("Patterns.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Incompatible Patterns"));
        ArrayList<Object> data = new ArrayList<Object>();
        Pattern pattern1 = VerifierComponentMockFactory.createPattern1();
        Pattern pattern2 = VerifierComponentMockFactory.createPattern2();
        SubPattern pp1 = new SubPattern(pattern1, 0);
        SubPattern pp2 = new SubPattern(pattern2, 0);
        LiteralRestriction r1 = LiteralRestriction.createRestriction((Pattern)pattern1, (String)"");
        pp1.add((PatternComponent)r1);
        LiteralRestriction r2 = LiteralRestriction.createRestriction((Pattern)pattern2, (String)"");
        pp2.add((PatternComponent)r2);
        LiteralRestriction r3 = LiteralRestriction.createRestriction((Pattern)pattern1, (String)"");
        pp1.add((PatternComponent)r3);
        LiteralRestriction r4 = LiteralRestriction.createRestriction((Pattern)pattern2, (String)"");
        pp2.add((PatternComponent)r4);
        Incompatibility o1 = new Incompatibility((Cause)r1, (Cause)r2);
        Incompatibility o2 = new Incompatibility((Cause)r3, (Cause)r4);
        Pattern pattern3 = VerifierComponentMockFactory.createPattern(3);
        Pattern pattern4 = VerifierComponentMockFactory.createPattern(4);
        SubPattern pp3 = new SubPattern(pattern3, 0);
        SubPattern pp4 = new SubPattern(pattern4, 0);
        LiteralRestriction r5 = LiteralRestriction.createRestriction((Pattern)pattern3, (String)"");
        pp3.add((PatternComponent)r5);
        LiteralRestriction r6 = LiteralRestriction.createRestriction((Pattern)pattern4, (String)"");
        pp4.add((PatternComponent)r6);
        LiteralRestriction r7 = LiteralRestriction.createRestriction((Pattern)pattern3, (String)"");
        pp3.add((PatternComponent)r7);
        LiteralRestriction r8 = LiteralRestriction.createRestriction((Pattern)pattern4, (String)"");
        pp4.add((PatternComponent)r8);
        Incompatibility o3 = new Incompatibility((Cause)r5, (Cause)r6);
        data.add(r1);
        data.add(r2);
        data.add(r3);
        data.add(r4);
        data.add(r5);
        data.add(r6);
        data.add(r7);
        data.add(r8);
        data.add(pp1);
        data.add(pp2);
        data.add(pp3);
        data.add(pp4);
        data.add(o1);
        data.add(o2);
        data.add(o3);
        StatelessSessionResult sessionResult = session.executeWithResults(data);
        Map<Cause, Set<Cause>> map = this.createIncompatibilityMap(VerifierComponentType.SUB_PATTERN, sessionResult.iterateObjects());
        Assert.assertTrue((boolean)(TestBaseOld.causeMapContains(map, (Cause)pp1, (Cause)pp2) ^ TestBaseOld.causeMapContains(map, (Cause)pp2, (Cause)pp1)));
        Assert.assertTrue((boolean)(TestBaseOld.causeMapContains(map, (Cause)pp3, (Cause)pp4) ^ TestBaseOld.causeMapContains(map, (Cause)pp4, (Cause)pp3)));
        if (!map.isEmpty()) {
            Assert.fail((String)"More opposites than was expected.");
        }
    }
}

