/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.missingEquality;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.drools.core.StatelessSession;
import org.drools.core.base.RuleNameMatchesAgendaFilter;
import org.drools.core.spi.AgendaFilter;
import org.drools.verifier.TestBaseOld;
import org.drools.verifier.components.LiteralRestriction;
import org.drools.verifier.components.VariableRestriction;
import org.drools.verifier.data.VerifierReport;
import org.drools.verifier.data.VerifierReportFactory;
import org.drools.verifier.report.components.Cause;
import org.drools.verifier.report.components.Severity;
import org.drools.verifier.report.components.VerifierMessage;
import org.junit.Assert;
import org.junit.Test;

public class MissingEqualityTest
extends TestBaseOld {
    @Test
    public void testMissingEqualityInLiteralRestrictions() throws Exception {
        StatelessSession session = this.getStatelessSession(this.getClass().getResourceAsStream("MissingEquality.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Missing restriction in LiteralRestrictions"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("MissingEqualityTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        session.executeWithResults(testData);
        Iterator iter = result.getBySeverity(Severity.WARNING).iterator();
        ArrayList<String> ruleNames = new ArrayList<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            Cause cause = ((VerifierMessage)o).getFaulty();
            String name = ((LiteralRestriction)cause).getRuleName();
            ruleNames.add(name);
        }
        Assert.assertTrue((boolean)ruleNames.remove("Missing equality 1"));
        Assert.assertTrue((boolean)ruleNames.remove("Missing equality 2"));
        if (!ruleNames.isEmpty()) {
            for (String string : ruleNames) {
                Assert.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    @Test
    public void testMissingEqualityInVariableRestrictions() throws Exception {
        StatelessSession session = this.getStatelessSession(this.getClass().getResourceAsStream("MissingEquality.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Missing restriction in VariableRestrictions, equal operator"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("MissingEqualityTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        session.executeWithResults(testData);
        Iterator iter = result.getBySeverity(Severity.WARNING).iterator();
        HashSet<String> ruleNames = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            Cause cause = ((VerifierMessage)o).getFaulty();
            String name = ((VariableRestriction)cause).getRuleName();
            ruleNames.add(name);
        }
        Assert.assertTrue((boolean)ruleNames.remove("Missing equality 5"));
        if (!ruleNames.isEmpty()) {
            for (String string : ruleNames) {
                Assert.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    @Test
    public void testMissingEqualityInVariableRestrictions2() throws Exception {
        StatelessSession session = this.getStatelessSession(this.getClass().getResourceAsStream("MissingEquality.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Missing restriction in VariableRestrictions, unequal operator"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("MissingEqualityTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        session.executeWithResults(testData);
        Iterator iter = result.getBySeverity(Severity.WARNING).iterator();
        HashSet<String> ruleNames = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            Cause cause = ((VerifierMessage)o).getFaulty();
            String name = ((VariableRestriction)cause).getRuleName();
            ruleNames.add(name);
        }
        Assert.assertTrue((boolean)ruleNames.remove("Missing equality 7"));
        if (!ruleNames.isEmpty()) {
            for (String string : ruleNames) {
                Assert.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    @Test
    public void testMissingEqualityInVariableRestrictions3() throws Exception {
        StatelessSession session = this.getStatelessSession(this.getClass().getResourceAsStream("MissingEquality.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Missing restriction in VariableRestrictions, custom operator"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("MissingEqualityTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        session.executeWithResults(testData);
        Iterator iter = result.getBySeverity(Severity.WARNING).iterator();
        HashSet<String> ruleNames = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            Cause cause = ((VerifierMessage)o).getFaulty();
            String name = ((VariableRestriction)cause).getRuleName();
            ruleNames.add(name);
        }
        Assert.assertTrue((boolean)ruleNames.remove("Missing equality 3"));
        Assert.assertTrue((boolean)ruleNames.remove("Missing equality 4"));
        Assert.assertTrue((boolean)ruleNames.remove("Missing equality 6"));
        if (!ruleNames.isEmpty()) {
            for (String string : ruleNames) {
                Assert.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }
}

