/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.optimisation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.drools.core.StatelessSession;
import org.drools.core.base.RuleNameMatchesAgendaFilter;
import org.drools.core.spi.AgendaFilter;
import org.drools.verifier.TestBaseOld;
import org.drools.verifier.components.Restriction;
import org.drools.verifier.components.RuleComponent;
import org.drools.verifier.data.VerifierReport;
import org.drools.verifier.data.VerifierReportFactory;
import org.drools.verifier.report.components.Severity;
import org.drools.verifier.report.components.VerifierMessage;
import org.junit.Assert;
import org.junit.Test;

public class RestrictionOrderTest
extends TestBaseOld {
    @Test
    public void testRestrictionOrderInsideOperator() throws Exception {
        StatelessSession session = this.getStatelessSession(this.getClass().getResourceAsStream("RestrictionOrder.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Optimise restrictions inside operator"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("OptimisationRestrictionOrderTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        session.executeWithResults(testData);
        Iterator iter = result.getBySeverity(Severity.NOTE).iterator();
        ArrayList<String> ruleNames = new ArrayList<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            String name = ((VerifierMessage)o).getCauses().toArray(new Restriction[2])[0].getRuleName();
            ruleNames.add(name);
        }
        Assert.assertTrue((boolean)ruleNames.remove("Wrong descr order 1"));
        if (!ruleNames.isEmpty()) {
            for (String string : ruleNames) {
                Assert.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    @Test
    public void testPredicateOrderInsideOperator() throws Exception {
        StatelessSession session = this.getStatelessSession(this.getClass().getResourceAsStream("RestrictionOrder.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Optimise predicates inside operator"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("OptimisationRestrictionOrderTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        session.executeWithResults(testData);
        Iterator iter = result.getBySeverity(Severity.NOTE).iterator();
        ArrayList<String> ruleNames = new ArrayList<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            String name = ((VerifierMessage)o).getCauses().toArray(new RuleComponent[2])[0].getRuleName();
            ruleNames.add(name);
        }
        Assert.assertTrue((boolean)ruleNames.remove("Wrong eval order 1"));
        if (!ruleNames.isEmpty()) {
            for (String string : ruleNames) {
                Assert.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }
}

