/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.drools.compiler.compiler.DrlParser;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.verifier.data.VerifierData;
import org.drools.verifier.report.components.Cause;
import org.drools.verifier.visitor.PackageDescrVisitor;
import org.junit.Assert;
import org.junit.Before;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.builder.conf.LanguageLevelOption;
import org.kie.internal.io.ResourceFactory;

public abstract class TestBaseOld {
    @Before
    public void setUp() throws Exception {
        System.setProperty("drools.dateformat", "dd-MMM-yyyy");
    }

    public KieSession getStatelessKieSession(InputStream stream) throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newInputStreamResource((InputStream)stream), ResourceType.DRL);
        Assert.assertFalse((boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        return kbase.newStatefulKnowledgeSession();
    }

    protected static boolean mapContains(Map<String, Set<String>> map, String ruleName1, String ruleName2) {
        if (map.containsKey(ruleName1)) {
            Set<String> set = map.get(ruleName1);
            boolean exists = set.remove(ruleName2);
            if (set.isEmpty()) {
                map.remove(ruleName1);
            }
            return exists;
        }
        return false;
    }

    protected static boolean causeMapContains(Map<Cause, Set<Cause>> map, Cause cause1, Cause cause2) {
        if (map.containsKey(cause1)) {
            Set<Cause> set = map.get(cause1);
            boolean exists = set.remove(cause2);
            if (set.isEmpty()) {
                map.remove(cause1);
            }
            return exists;
        }
        return false;
    }

    public Collection<? extends Object> getTestData(InputStream stream, VerifierData data) throws Exception {
        InputStreamReader drlReader = new InputStreamReader(stream);
        PackageDescr descr = new DrlParser(LanguageLevelOption.DRL5).parse((Reader)drlReader);
        PackageDescrVisitor packageDescrVisitor = new PackageDescrVisitor(data, Collections.EMPTY_LIST);
        packageDescrVisitor.visitPackageDescr(descr);
        return data.getAll();
    }
}

