/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.misc;

import java.util.List;
import org.drools.verifier.misc.DrlRuleParser;
import org.junit.Assert;
import org.junit.Test;

public class DrlRuleDataTest {
    @Test
    public void testHandleDrl() {
        String drl = "rule \"Something\" \n ";
        drl = drl + "dialect \"Java\" \n ";
        drl = drl + "\twhen \n ";
        drl = drl + "\t\tPerson() \n ";
        drl = drl + "\t\tCheesery() \n ";
        drl = drl + "\tthen \n ";
        drl = drl + "\t\tinsert( new Person()) \n ";
        drl = drl + "\t\tinsert( new Car()) \n ";
        drl = drl + "\t\tinsert( new Cheese()) \n ";
        drl = drl + "end ";
        DrlRuleParser s = (DrlRuleParser)DrlRuleParser.findRulesDataFromDrl((String)drl).get(0);
        Assert.assertEquals((long)1L, (long)s.getHeader().size());
        Assert.assertEquals((long)2L, (long)s.getLhs().size());
        Assert.assertEquals((long)3L, (long)s.getRhs().size());
        Assert.assertEquals((Object)"", (Object)s.getDescription());
    }

    @Test
    public void testHandleDrlNoLineBreaks() {
        String drl = "rule \"CreditScoreApproval\" \n";
        drl = drl + "\tdialect \"mvel\" \n";
        drl = drl + "\twhen    then";
        drl = drl + "\t\tapplicant.setApproved(true) \n";
        drl = drl + "\t\tapplicant.setName( \"Toni\" ) \n";
        drl = drl + "\t\tapplicant.setAge( 10 ) \n";
        drl = drl + "end";
        DrlRuleParser s = (DrlRuleParser)DrlRuleParser.findRulesDataFromDrl((String)drl).get(0);
        Assert.assertNotNull((Object)s);
        Assert.assertEquals((long)1L, (long)s.getHeader().size());
        Assert.assertEquals((long)0L, (long)s.getLhs().size());
        Assert.assertEquals((long)3L, (long)s.getRhs().size());
        Assert.assertEquals((Object)"", (Object)s.getDescription());
    }

    @Test
    public void testHandleDrlWithComment() {
        String drl = "# Really important information about this rule \n";
        drl = drl + "# Another line because one was not enough \n";
        drl = drl + "#  \n";
        drl = drl + "# @author: trikkola \n";
        drl = drl + "rule \"First\" \n";
        drl = drl + "\tdialect \"mvel\" \n";
        drl = drl + "\twhen \n ";
        drl = drl + "\t\tPerson() \n ";
        drl = drl + "\t\tCheesery() \n ";
        drl = drl + "\tthen \n ";
        drl = drl + "\t\tapplicant.setApproved(true) \n";
        drl = drl + "\t\tapplicant.setName( \"Toni\" ) \n";
        drl = drl + "\t\tapplicant.setAge( 10 ) \n";
        drl = drl + "end \n";
        drl = drl + "\n";
        drl = drl + "# Really important information about this rule \n";
        drl = drl + "# Another line because one was not enough \n";
        drl = drl + "#  \n";
        drl = drl + "# @author: trikkola \n";
        drl = drl + "# @created: 29.12.2001 \n";
        drl = drl + "# @edited: 5.5.2005 \n";
        drl = drl + "rule \"Second\" \n";
        drl = drl + "\tdialect \"mvel\" \n";
        drl = drl + "\twhen \n ";
        drl = drl + "\t\tPerson() \n ";
        drl = drl + "\t\tCheesery() \n ";
        drl = drl + "\tthen \n ";
        drl = drl + "\t\tapplicant.setApproved(true) \n";
        drl = drl + "\t\tapplicant.setName( \"Toni\" ) \n";
        drl = drl + "\t\tapplicant.setAge( 10 ) \n";
        drl = drl + "end";
        drl = drl + "\n";
        drl = drl + "rule \"Third\" \n";
        drl = drl + "\tdialect \"mvel\" \n";
        drl = drl + "\twhen \n ";
        drl = drl + "\t\tPerson() \n ";
        drl = drl + "\t\tCheesery() \n ";
        drl = drl + "\tthen \n ";
        drl = drl + "\t\tapplicant.setApproved(true) \n";
        drl = drl + "\t\tapplicant.setName( \"Toni\" ) \n";
        drl = drl + "\t\tapplicant.setAge( 10 ) \n";
        drl = drl + "end";
        List list = DrlRuleParser.findRulesDataFromDrl((String)drl);
        Assert.assertEquals((long)3L, (long)list.size());
        DrlRuleParser rd = (DrlRuleParser)list.get(0);
        Assert.assertNotNull((Object)rd);
        Assert.assertEquals((long)1L, (long)rd.getHeader().size());
        Assert.assertEquals((long)2L, (long)rd.getLhs().size());
        Assert.assertEquals((long)3L, (long)rd.getRhs().size());
        Assert.assertEquals((long)1L, (long)rd.getMetadata().size());
        Assert.assertNotNull((Object)rd.getDescription());
        Assert.assertNotSame((Object)"", (Object)rd.getDescription());
        DrlRuleParser rd2 = (DrlRuleParser)list.get(1);
        Assert.assertNotNull((Object)rd2);
        Assert.assertEquals((long)1L, (long)rd2.getHeader().size());
        Assert.assertEquals((long)2L, (long)rd2.getLhs().size());
        Assert.assertEquals((long)3L, (long)rd2.getRhs().size());
        Assert.assertEquals((long)3L, (long)rd2.getMetadata().size());
        Assert.assertNotNull((Object)rd2.getDescription());
        String description = "Really important information about this rule\n";
        description = description + "Another line because one was not enough\n\n";
        Assert.assertEquals((Object)description, (Object)rd2.getDescription());
        Assert.assertNotSame((Object)"", (Object)rd2.getDescription());
        DrlRuleParser rd3 = (DrlRuleParser)list.get(2);
        Assert.assertNotNull((Object)rd3);
        Assert.assertEquals((long)1L, (long)rd3.getHeader().size());
        Assert.assertEquals((long)2L, (long)rd3.getLhs().size());
        Assert.assertEquals((long)3L, (long)rd3.getRhs().size());
        Assert.assertNotNull((Object)rd3.getDescription());
        Assert.assertEquals((Object)"", (Object)rd3.getDescription());
    }
}

