/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.solver;

import java.util.List;
import java.util.Set;
import org.drools.verifier.VerifierComponentMockFactory;
import org.drools.verifier.components.LiteralRestriction;
import org.drools.verifier.components.OperatorDescrType;
import org.drools.verifier.components.Pattern;
import org.drools.verifier.data.VerifierComponent;
import org.drools.verifier.solver.PatternSolver;
import org.junit.Assert;
import org.junit.Test;

public class PatternSolverTest {
    @Test
    public void testAddBasicAnd() {
        Pattern pattern = VerifierComponentMockFactory.createPattern1();
        LiteralRestriction literalRestriction = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        LiteralRestriction literalRestriction2 = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        PatternSolver solver = new PatternSolver(pattern);
        solver.addOperator(OperatorDescrType.AND);
        solver.add((VerifierComponent)literalRestriction);
        solver.add((VerifierComponent)literalRestriction2);
        solver.end();
        List list = solver.getPossibilityLists();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((Set)list.get(0)).size());
    }

    @Test
    public void testAddBasicOr() {
        Pattern pattern = VerifierComponentMockFactory.createPattern1();
        LiteralRestriction literalRestriction = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        LiteralRestriction literalRestriction2 = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        PatternSolver solver = new PatternSolver(pattern);
        solver.addOperator(OperatorDescrType.OR);
        solver.add((VerifierComponent)literalRestriction);
        solver.add((VerifierComponent)literalRestriction2);
        solver.end();
        List list = solver.getPossibilityLists();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Set)list.get(0)).size());
        Assert.assertEquals((long)1L, (long)((Set)list.get(1)).size());
    }

    @Test
    public void testAddOrAnd() {
        Pattern pattern = VerifierComponentMockFactory.createPattern1();
        LiteralRestriction literalRestriction = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        LiteralRestriction literalRestriction2 = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        LiteralRestriction literalRestriction3 = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        PatternSolver solver = new PatternSolver(pattern);
        solver.addOperator(OperatorDescrType.OR);
        solver.add((VerifierComponent)literalRestriction);
        solver.addOperator(OperatorDescrType.AND);
        solver.add((VerifierComponent)literalRestriction2);
        solver.add((VerifierComponent)literalRestriction3);
        solver.end();
        solver.end();
        List list = solver.getPossibilityLists();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Set)list.get(0)).size());
        Assert.assertTrue((boolean)((Set)list.get(0)).contains(literalRestriction));
        Assert.assertEquals((long)2L, (long)((Set)list.get(1)).size());
        Assert.assertTrue((boolean)((Set)list.get(1)).contains(literalRestriction2));
        Assert.assertTrue((boolean)((Set)list.get(1)).contains(literalRestriction3));
    }

    @Test
    public void testAddAndOr() {
        Pattern pattern = VerifierComponentMockFactory.createPattern1();
        LiteralRestriction literalRestriction = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        LiteralRestriction literalRestriction2 = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        LiteralRestriction literalRestriction3 = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        PatternSolver solver = new PatternSolver(pattern);
        solver.addOperator(OperatorDescrType.AND);
        solver.add((VerifierComponent)literalRestriction);
        solver.addOperator(OperatorDescrType.OR);
        solver.add((VerifierComponent)literalRestriction2);
        solver.add((VerifierComponent)literalRestriction3);
        solver.end();
        solver.end();
        List list = solver.getPossibilityLists();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((Set)list.get(0)).size());
        Assert.assertTrue((boolean)((Set)list.get(0)).contains(literalRestriction));
        Assert.assertTrue((boolean)((Set)list.get(0)).contains(literalRestriction2));
        Assert.assertEquals((long)2L, (long)((Set)list.get(1)).size());
        Assert.assertTrue((boolean)((Set)list.get(1)).contains(literalRestriction));
        Assert.assertTrue((boolean)((Set)list.get(1)).contains(literalRestriction3));
    }

    @Test
    public void testAddAndOrOr() {
        Pattern pattern = VerifierComponentMockFactory.createPattern1();
        LiteralRestriction literalRestriction = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        LiteralRestriction literalRestriction2 = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        LiteralRestriction literalRestriction3 = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        LiteralRestriction literalRestriction4 = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        PatternSolver solver = new PatternSolver(pattern);
        solver.addOperator(OperatorDescrType.AND);
        solver.addOperator(OperatorDescrType.OR);
        solver.add((VerifierComponent)literalRestriction);
        solver.add((VerifierComponent)literalRestriction2);
        solver.end();
        solver.addOperator(OperatorDescrType.OR);
        solver.add((VerifierComponent)literalRestriction3);
        solver.add((VerifierComponent)literalRestriction4);
        solver.end();
        solver.end();
        List list = solver.getPossibilityLists();
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((Set)list.get(0)).size());
        Assert.assertTrue((boolean)((Set)list.get(0)).contains(literalRestriction));
        Assert.assertTrue((boolean)((Set)list.get(0)).contains(literalRestriction3));
        Assert.assertEquals((long)2L, (long)((Set)list.get(1)).size());
        Assert.assertTrue((boolean)((Set)list.get(1)).contains(literalRestriction));
        Assert.assertTrue((boolean)((Set)list.get(1)).contains(literalRestriction4));
        Assert.assertEquals((long)2L, (long)((Set)list.get(2)).size());
        Assert.assertTrue((boolean)((Set)list.get(2)).contains(literalRestriction2));
        Assert.assertTrue((boolean)((Set)list.get(2)).contains(literalRestriction3));
        Assert.assertEquals((long)2L, (long)((Set)list.get(3)).size());
        Assert.assertTrue((boolean)((Set)list.get(3)).contains(literalRestriction2));
        Assert.assertTrue((boolean)((Set)list.get(3)).contains(literalRestriction4));
    }

    @Test
    public void testAddOrAndAnd() {
        Pattern pattern = VerifierComponentMockFactory.createPattern1();
        LiteralRestriction literalRestriction = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        LiteralRestriction literalRestriction2 = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        LiteralRestriction literalRestriction3 = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        LiteralRestriction literalRestriction4 = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        PatternSolver solver = new PatternSolver(pattern);
        solver.addOperator(OperatorDescrType.OR);
        solver.addOperator(OperatorDescrType.AND);
        solver.add((VerifierComponent)literalRestriction);
        solver.add((VerifierComponent)literalRestriction2);
        solver.end();
        solver.addOperator(OperatorDescrType.AND);
        solver.add((VerifierComponent)literalRestriction3);
        solver.add((VerifierComponent)literalRestriction4);
        solver.end();
        solver.end();
        List list = solver.getPossibilityLists();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((Set)list.get(0)).size());
        Assert.assertTrue((boolean)((Set)list.get(0)).contains(literalRestriction));
        Assert.assertTrue((boolean)((Set)list.get(0)).contains(literalRestriction2));
        Assert.assertEquals((long)2L, (long)((Set)list.get(1)).size());
        Assert.assertTrue((boolean)((Set)list.get(1)).contains(literalRestriction3));
        Assert.assertTrue((boolean)((Set)list.get(1)).contains(literalRestriction4));
    }

    @Test
    public void testAddOrAndOr() {
        Pattern pattern = VerifierComponentMockFactory.createPattern1();
        LiteralRestriction literalRestriction = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        LiteralRestriction literalRestriction2 = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        LiteralRestriction literalRestriction3 = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        LiteralRestriction literalRestriction4 = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        PatternSolver solver = new PatternSolver(pattern);
        solver.addOperator(OperatorDescrType.OR);
        solver.addOperator(OperatorDescrType.AND);
        solver.add((VerifierComponent)literalRestriction);
        solver.add((VerifierComponent)literalRestriction2);
        solver.end();
        solver.addOperator(OperatorDescrType.OR);
        solver.add((VerifierComponent)literalRestriction3);
        solver.add((VerifierComponent)literalRestriction4);
        solver.end();
        solver.end();
        List list = solver.getPossibilityLists();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((Set)list.get(0)).size());
        Assert.assertTrue((boolean)((Set)list.get(0)).contains(literalRestriction));
        Assert.assertTrue((boolean)((Set)list.get(0)).contains(literalRestriction2));
        Assert.assertEquals((long)1L, (long)((Set)list.get(1)).size());
        Assert.assertTrue((boolean)((Set)list.get(1)).contains(literalRestriction3));
        Assert.assertEquals((long)1L, (long)((Set)list.get(2)).size());
        Assert.assertTrue((boolean)((Set)list.get(2)).contains(literalRestriction4));
    }

    @Test
    public void testAddOrAndOrDescr() {
        Pattern pattern = VerifierComponentMockFactory.createPattern1();
        LiteralRestriction literalRestriction = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        LiteralRestriction literalRestriction2 = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        LiteralRestriction literalRestriction3 = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        LiteralRestriction literalRestriction4 = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        LiteralRestriction literalRestriction5 = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        PatternSolver solver = new PatternSolver(pattern);
        solver.addOperator(OperatorDescrType.AND);
        solver.addOperator(OperatorDescrType.AND);
        solver.add((VerifierComponent)literalRestriction);
        solver.add((VerifierComponent)literalRestriction2);
        solver.end();
        solver.addOperator(OperatorDescrType.OR);
        solver.add((VerifierComponent)literalRestriction3);
        solver.add((VerifierComponent)literalRestriction4);
        solver.end();
        solver.add((VerifierComponent)literalRestriction5);
        solver.end();
        List list = solver.getPossibilityLists();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((long)4L, (long)((Set)list.get(0)).size());
        Assert.assertTrue((boolean)((Set)list.get(0)).contains(literalRestriction));
        Assert.assertTrue((boolean)((Set)list.get(0)).contains(literalRestriction2));
        Assert.assertTrue((boolean)((Set)list.get(0)).contains(literalRestriction3));
        Assert.assertTrue((boolean)((Set)list.get(0)).contains(literalRestriction5));
        Assert.assertEquals((long)4L, (long)((Set)list.get(1)).size());
        Assert.assertTrue((boolean)((Set)list.get(1)).contains(literalRestriction));
        Assert.assertTrue((boolean)((Set)list.get(1)).contains(literalRestriction2));
        Assert.assertTrue((boolean)((Set)list.get(1)).contains(literalRestriction4));
        Assert.assertTrue((boolean)((Set)list.get(1)).contains(literalRestriction4));
    }
}

