/*
 * Decompiled with CFR 0.152.
 */
package org.drools.vsm;

import java.util.Collection;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderErrors;
import org.drools.builder.ResourceConfiguration;
import org.drools.builder.ResourceType;
import org.drools.command.Command;
import org.drools.command.FinishedCommand;
import org.drools.command.KnowledgeContextResolveFromContextCommand;
import org.drools.command.builder.KnowledgeBuilderAddCommand;
import org.drools.command.builder.KnowledgeBuilderGetErrorsCommand;
import org.drools.command.builder.KnowledgeBuilderHasErrorsCommand;
import org.drools.definition.KnowledgePackage;
import org.drools.io.Resource;
import org.drools.runtime.ExecutionResults;
import org.drools.vsm.CollectionClient;
import org.drools.vsm.Message;
import org.drools.vsm.ServiceManagerClient;
import org.drools.vsm.responsehandlers.BlockingMessageResponseHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KnowledgeBuilderClient
implements KnowledgeBuilder {
    private ServiceManagerClient serviceManager;
    private String instanceId;

    public KnowledgeBuilderClient(String instanceId, ServiceManagerClient serviceManager) {
        this.instanceId = instanceId;
        this.serviceManager = serviceManager;
    }

    public void add(Resource resource, ResourceType resourceType) {
        this.add(resource, resourceType, null);
    }

    public void add(Resource resource, ResourceType resourceType, ResourceConfiguration configuration) {
        Message msg = new Message(this.serviceManager.getSessionId(), this.serviceManager.counter.incrementAndGet(), false, null, new KnowledgeContextResolveFromContextCommand((Command)new KnowledgeBuilderAddCommand(resource, resourceType, configuration), this.instanceId, null, null, null));
        BlockingMessageResponseHandler handler = new BlockingMessageResponseHandler();
        try {
            this.serviceManager.client.handler.addResponseHandler(msg.getResponseId(), handler);
            this.serviceManager.client.session.write((Object)msg);
            Object object = handler.getMessage().getPayload();
            if (!(object instanceof FinishedCommand)) {
                throw new RuntimeException("Response was not correctly ended");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to execute message", e);
        }
    }

    public KnowledgeBuilderErrors getErrors() {
        String commandId = "kbuilder.getErrors_" + this.serviceManager.getNextId();
        String kresultsId = "kresults_" + this.serviceManager.getSessionId();
        Message msg = new Message(this.serviceManager.getSessionId(), this.serviceManager.counter.incrementAndGet(), false, null, new KnowledgeContextResolveFromContextCommand((Command)new KnowledgeBuilderGetErrorsCommand(commandId), this.instanceId, null, null, kresultsId));
        BlockingMessageResponseHandler handler = new BlockingMessageResponseHandler();
        try {
            this.serviceManager.client.handler.addResponseHandler(msg.getResponseId(), handler);
            this.serviceManager.client.session.write((Object)msg);
            Object object = handler.getMessage().getPayload();
            if (object == null) {
                throw new RuntimeException("Response was not correctly received");
            }
            return (KnowledgeBuilderErrors)((ExecutionResults)object).getValue(commandId);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to execute message", e);
        }
    }

    public Collection<KnowledgePackage> getKnowledgePackages() {
        return new CollectionClient(this.instanceId);
    }

    public boolean hasErrors() {
        String commandId = "kbuilder.hasErrors_" + this.serviceManager.getNextId();
        String kresultsId = "kresults_" + this.serviceManager.getSessionId();
        Message msg = new Message(this.serviceManager.getSessionId(), this.serviceManager.getNextId(), false, null, new KnowledgeContextResolveFromContextCommand((Command)new KnowledgeBuilderHasErrorsCommand(commandId), this.instanceId, null, null, kresultsId));
        BlockingMessageResponseHandler handler = new BlockingMessageResponseHandler();
        try {
            this.serviceManager.client.handler.addResponseHandler(msg.getResponseId(), handler);
            this.serviceManager.client.session.write((Object)msg);
            Object object = handler.getMessage().getPayload();
            if (object == null) {
                throw new RuntimeException("Response was not correctly received");
            }
            System.out.println("object" + object);
            return (Boolean)((ExecutionResults)object).getValue(commandId);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to execute message", e);
        }
    }
}

