/*
 * Decompiled with CFR 0.152.
 */
package org.drools.vsm;

import org.apache.mina.core.session.IoSession;
import org.drools.SystemEventListener;
import org.drools.vsm.BaseMinaHandler;
import org.drools.vsm.Message;

public class MessageHandler
extends BaseMinaHandler {
    private Object owner;
    private SystemEventListener systemEventListener;

    public MessageHandler(SystemEventListener systemEventListener) {
        this.systemEventListener = systemEventListener;
    }

    public Object getOwner() {
        return this.owner;
    }

    public void setOwner(Object owner) {
        this.owner = owner;
    }

    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        this.systemEventListener.exception("Uncaught exception on client", cause);
    }

    public void messageReceived(IoSession session, Object object) throws Exception {
        Message msg = (Message)object;
        this.systemEventListener.debug("Message receieved on client : " + msg);
        BaseMinaHandler.MessageResponseHandler responseHandler = (BaseMinaHandler.MessageResponseHandler)this.responseHandlers.remove(msg.getResponseId());
        if (responseHandler != null) {
            Object payload = msg.getPayload();
            if (payload != null && payload instanceof RuntimeException) {
                responseHandler.setError((RuntimeException)payload);
            } else {
                responseHandler.receive(msg);
            }
        }
    }
}

