/*
 * Decompiled with CFR 0.152.
 */
package org.drools.vsm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.drools.SystemEventListener;
import org.drools.command.Context;
import org.drools.command.ContextManager;
import org.drools.command.FinishedCommand;
import org.drools.command.impl.ContextImpl;
import org.drools.command.impl.GenericCommand;
import org.drools.command.vsm.ServiceManagerServerContext;
import org.drools.runtime.impl.ExecutionResultImpl;
import org.drools.vsm.Message;
import org.drools.vsm.ServiceManagerServer;

public class ServiceManagerServerResponseHandler
extends IoHandlerAdapter {
    private ServiceManagerServer server;
    private final SystemEventListener systemEventListener;

    public ServiceManagerServerResponseHandler(SystemEventListener systemEventListener) {
        this.systemEventListener = systemEventListener;
    }

    public void setServiceManagerService(ServiceManagerServer server) {
        this.server = server;
    }

    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        this.systemEventListener.exception("Uncaught exception on Server", cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(IoSession session, Object object) throws Exception {
        ArrayList<GenericCommand> commands;
        Message msg = (Message)object;
        this.systemEventListener.debug("Message receieved on server : " + msg);
        try {
            if (msg.getSessionId() == -1) {
                GenericCommand cmd = (GenericCommand)msg.getPayload();
                ServiceManagerServerContext ctx = new ServiceManagerServerContext(null, this.server);
                int sessionId = (Integer)cmd.execute((Context)ctx);
                session.write((Object)new Message(sessionId, msg.getResponseId(), false, null, sessionId));
                return;
            }
        }
        catch (RuntimeException e) {
            this.systemEventListener.exception(e.getMessage(), (Throwable)e);
        }
        if (msg.getPayload() instanceof List) {
            commands = (ArrayList<GenericCommand>)msg.getPayload();
        } else {
            commands = new ArrayList<GenericCommand>();
            commands.add((GenericCommand)msg.getPayload());
        }
        ContextImpl localSessionContext = new ContextImpl("sesseion_" + msg.getSessionId(), this.server.getContextManager(), this.server.getTemp());
        ExecutionResultImpl localKresults = new ExecutionResultImpl();
        localSessionContext.set("kresults_" + msg.getSessionId(), (Object)localKresults);
        for (GenericCommand cmd : commands) {
            cmd.execute((Context)localSessionContext);
        }
        if (!msg.isAsync() && localKresults.getIdentifiers().isEmpty()) {
            session.write((Object)new Message(msg.getSessionId(), msg.getResponseId(), msg.isAsync(), null, new FinishedCommand()));
        } else {
            session.write((Object)new Message(msg.getSessionId(), msg.getResponseId(), msg.isAsync(), null, localKresults));
        }
    }

    public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
        this.systemEventListener.debug("Server IDLE " + session.getIdleCount(status));
    }

    public static class ContextManagerImpl
    implements ContextManager {
        private Map<String, Context> contexts = new HashMap<String, Context>();

        public void addContext(Context context) {
            this.contexts.put(context.getName(), context);
        }

        public Context getContext(String identifier) {
            return this.contexts.get(identifier);
        }
    }
}

