/*
 * Decompiled with CFR 0.152.
 */
package org.drools.vsm;

import java.util.Collection;
import java.util.Map;
import org.drools.KnowledgeBase;
import org.drools.command.Command;
import org.drools.command.ExecuteCommand;
import org.drools.command.KnowledgeContextResolveFromContextCommand;
import org.drools.command.runtime.rule.FireAllRulesCommand;
import org.drools.event.process.ProcessEventListener;
import org.drools.event.rule.AgendaEventListener;
import org.drools.event.rule.WorkingMemoryEventListener;
import org.drools.runtime.Environment;
import org.drools.runtime.ExecutionResults;
import org.drools.runtime.ExitPoint;
import org.drools.runtime.Globals;
import org.drools.runtime.ObjectFilter;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.process.ProcessInstance;
import org.drools.runtime.process.WorkItemManager;
import org.drools.runtime.rule.Agenda;
import org.drools.runtime.rule.AgendaFilter;
import org.drools.runtime.rule.FactHandle;
import org.drools.runtime.rule.QueryResults;
import org.drools.runtime.rule.WorkingMemoryEntryPoint;
import org.drools.time.SessionClock;
import org.drools.vsm.Message;
import org.drools.vsm.ServiceManagerClient;
import org.drools.vsm.responsehandlers.BlockingMessageResponseHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatefulKnowledgeSessionClient
implements StatefulKnowledgeSession {
    private ServiceManagerClient serviceManager;
    private String instanceId;

    public StatefulKnowledgeSessionClient(String instanceId, ServiceManagerClient serviceManager) {
        this.instanceId = instanceId;
        this.serviceManager = serviceManager;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void dispose() {
    }

    public int getId() {
        return 0;
    }

    public int fireAllRules() {
        String commandId = "ksession.fireAllRules" + this.serviceManager.getNextId();
        String kresultsId = "kresults_" + this.serviceManager.getSessionId();
        Message msg = new Message(this.serviceManager.getSessionId(), this.serviceManager.counter.incrementAndGet(), false, null, new KnowledgeContextResolveFromContextCommand((Command)new FireAllRulesCommand(commandId), null, null, this.instanceId, kresultsId));
        BlockingMessageResponseHandler handler = new BlockingMessageResponseHandler();
        try {
            this.serviceManager.client.handler.addResponseHandler(msg.getResponseId(), handler);
            this.serviceManager.client.session.write((Object)msg);
            Object object = handler.getMessage().getPayload();
            if (object == null) {
                throw new RuntimeException("Response was not correctly received");
            }
            return (Integer)((ExecutionResults)object).getValue(commandId);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to execute message", e);
        }
    }

    public int fireAllRules(int max) {
        return 0;
    }

    public int fireAllRules(AgendaFilter agendaFilter) {
        return 0;
    }

    public void fireUntilHalt() {
    }

    public void fireUntilHalt(AgendaFilter agendaFilter) {
    }

    public ExecutionResults execute(Command command) {
        String commandId = "ksession.execute" + this.serviceManager.getNextId();
        String kresultsId = "kresults_" + this.serviceManager.getSessionId();
        Message msg = new Message(this.serviceManager.getSessionId(), this.serviceManager.counter.incrementAndGet(), false, null, new KnowledgeContextResolveFromContextCommand((Command)new ExecuteCommand(commandId, command), null, null, this.instanceId, kresultsId));
        BlockingMessageResponseHandler handler = new BlockingMessageResponseHandler();
        try {
            this.serviceManager.client.handler.addResponseHandler(msg.getResponseId(), handler);
            this.serviceManager.client.session.write((Object)msg);
            Object object = handler.getMessage().getPayload();
            if (object == null) {
                throw new RuntimeException("Response was not correctly received");
            }
            System.out.println("object" + object);
            return (ExecutionResults)((ExecutionResults)object).getValue(commandId);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to execute message", e);
        }
    }

    public Environment getEnvironment() {
        return null;
    }

    public Object getGlobal(String identifier) {
        return null;
    }

    public Globals getGlobals() {
        return null;
    }

    public KnowledgeBase getKnowledgeBase() {
        return null;
    }

    public <T extends SessionClock> T getSessionClock() {
        return null;
    }

    public void registerExitPoint(String name, ExitPoint exitPoint) {
    }

    public void setGlobal(String identifier, Object object) {
    }

    public void unregisterExitPoint(String name) {
    }

    public Agenda getAgenda() {
        return null;
    }

    public QueryResults getQueryResults(String query) {
        return null;
    }

    public QueryResults getQueryResults(String query, Object[] arguments) {
        return null;
    }

    public WorkingMemoryEntryPoint getWorkingMemoryEntryPoint(String name) {
        return null;
    }

    public Collection<? extends WorkingMemoryEntryPoint> getWorkingMemoryEntryPoints() {
        return null;
    }

    public void halt() {
    }

    public FactHandle getFactHandle(Object object) {
        return null;
    }

    public <T extends FactHandle> Collection<T> getFactHandles() {
        return null;
    }

    public <T extends FactHandle> Collection<T> getFactHandles(ObjectFilter filter) {
        return null;
    }

    public Object getObject(FactHandle factHandle) {
        return null;
    }

    public Collection<Object> getObjects() {
        return null;
    }

    public Collection<Object> getObjects(ObjectFilter filter) {
        return null;
    }

    public FactHandle insert(Object object) {
        return null;
    }

    public void retract(FactHandle handle) {
    }

    public void update(FactHandle handle, Object object) {
    }

    public void abortProcessInstance(long id) {
    }

    public ProcessInstance getProcessInstance(long id) {
        return null;
    }

    public Collection<ProcessInstance> getProcessInstances() {
        return null;
    }

    public WorkItemManager getWorkItemManager() {
        return null;
    }

    public void signalEvent(String type, Object event) {
    }

    public ProcessInstance startProcess(String processId) {
        return null;
    }

    public ProcessInstance startProcess(String processId, Map<String, Object> parameters) {
        return null;
    }

    public void addEventListener(WorkingMemoryEventListener listener) {
    }

    public void addEventListener(AgendaEventListener listener) {
    }

    public Collection<AgendaEventListener> getAgendaEventListeners() {
        return null;
    }

    public Collection<WorkingMemoryEventListener> getWorkingMemoryEventListeners() {
        return null;
    }

    public void removeEventListener(WorkingMemoryEventListener listener) {
    }

    public void removeEventListener(AgendaEventListener listener) {
    }

    public void addEventListener(ProcessEventListener listener) {
    }

    public Collection<ProcessEventListener> getProcessEventListeners() {
        return null;
    }

    public void removeEventListener(ProcessEventListener listener) {
    }
}

