/*
 * Decompiled with CFR 0.152.
 */
package net.sf.webdav;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Date;
import net.sf.webdav.ITransaction;
import net.sf.webdav.IWebdavStore;
import net.sf.webdav.StoredObject;
import net.sf.webdav.exceptions.WebdavException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileSystemStore
implements IWebdavStore {
    private static Logger LOG = LoggerFactory.getLogger(LocalFileSystemStore.class);
    private static int BUF_SIZE = 65536;
    private File _root = null;

    public LocalFileSystemStore(File root) {
        this._root = root;
    }

    public ITransaction begin(Principal principal) throws WebdavException {
        LOG.trace("LocalFileSystemStore.begin()");
        if (!this._root.exists() && !this._root.mkdirs()) {
            throw new WebdavException("root path: " + this._root.getAbsolutePath() + " does not exist and could not be created");
        }
        return null;
    }

    public void checkAuthentication(ITransaction transaction) throws SecurityException {
        LOG.trace("LocalFileSystemStore.checkAuthentication()");
    }

    public void commit(ITransaction transaction) throws WebdavException {
        LOG.trace("LocalFileSystemStore.commit()");
    }

    public void rollback(ITransaction transaction) throws WebdavException {
        LOG.trace("LocalFileSystemStore.rollback()");
    }

    public void createFolder(ITransaction transaction, String uri) throws WebdavException {
        LOG.trace("LocalFileSystemStore.createFolder(" + uri + ")");
        File file = new File(this._root, uri);
        if (!file.mkdir()) {
            throw new WebdavException("cannot create folder: " + uri);
        }
    }

    public void createResource(ITransaction transaction, String uri) throws WebdavException {
        LOG.trace("LocalFileSystemStore.createResource(" + uri + ")");
        File file = new File(this._root, uri);
        try {
            if (!file.createNewFile()) {
                throw new WebdavException("cannot create file: " + uri);
            }
        }
        catch (IOException e) {
            LOG.error("LocalFileSystemStore.createResource(" + uri + ") failed");
            throw new WebdavException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long setResourceContent(ITransaction transaction, String uri, InputStream is, String contentType, String characterEncoding) throws WebdavException {
        LOG.trace("LocalFileSystemStore.setResourceContent(" + uri + ")");
        File file = new File(this._root, uri);
        try {
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file), BUF_SIZE);
            try {
                int read;
                byte[] copyBuffer = new byte[BUF_SIZE];
                while ((read = is.read(copyBuffer, 0, copyBuffer.length)) != -1) {
                    ((OutputStream)os).write(copyBuffer, 0, read);
                }
            }
            finally {
                try {
                    is.close();
                }
                finally {
                    ((OutputStream)os).close();
                }
            }
        }
        catch (IOException e) {
            LOG.error("LocalFileSystemStore.setResourceContent(" + uri + ") failed");
            throw new WebdavException(e);
        }
        long length = -1L;
        try {
            length = file.length();
        }
        catch (SecurityException e) {
            LOG.error("LocalFileSystemStore.setResourceContent(" + uri + ") failed" + "\nCan't get file.length");
        }
        return length;
    }

    public String[] getChildrenNames(ITransaction transaction, String uri) throws WebdavException {
        LOG.trace("LocalFileSystemStore.getChildrenNames(" + uri + ")");
        File file = new File(this._root, uri);
        String[] childrenNames = null;
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            ArrayList<String> childList = new ArrayList<String>();
            String name = null;
            for (int i = 0; i < children.length; ++i) {
                name = children[i].getName();
                childList.add(name);
                LOG.trace("Child " + i + ": " + name);
            }
            childrenNames = new String[childList.size()];
            childrenNames = childList.toArray(childrenNames);
        }
        return childrenNames;
    }

    public void removeObject(ITransaction transaction, String uri) throws WebdavException {
        File file = new File(this._root, uri);
        boolean success = file.delete();
        LOG.trace("LocalFileSystemStore.removeObject(" + uri + ")=" + success);
        if (!success) {
            throw new WebdavException("cannot delete object: " + uri);
        }
    }

    public InputStream getResourceContent(ITransaction transaction, String uri) throws WebdavException {
        BufferedInputStream in;
        LOG.trace("LocalFileSystemStore.getResourceContent(" + uri + ")");
        File file = new File(this._root, uri);
        try {
            in = new BufferedInputStream(new FileInputStream(file));
        }
        catch (IOException e) {
            LOG.error("LocalFileSystemStore.getResourceContent(" + uri + ") failed");
            throw new WebdavException(e);
        }
        return in;
    }

    public long getResourceLength(ITransaction transaction, String uri) throws WebdavException {
        LOG.trace("LocalFileSystemStore.getResourceLength(" + uri + ")");
        File file = new File(this._root, uri);
        return file.length();
    }

    public StoredObject getStoredObject(ITransaction transaction, String uri) {
        StoredObject so = null;
        File file = new File(this._root, uri);
        if (file.exists()) {
            so = new StoredObject();
            so.setFolder(file.isDirectory());
            so.setLastModified(new Date(file.lastModified()));
            so.setCreationDate(new Date(file.lastModified()));
            so.setResourceLength(this.getResourceLength(transaction, uri));
        }
        return so;
    }
}

