/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.node;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.core.RuntimeDroolsException;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.rule.Declaration;
import org.drools.core.runtime.rule.impl.InternalAgenda;
import org.drools.core.spi.Activation;
import org.drools.core.time.TimeUtils;
import org.jbpm.process.core.timer.BusinessCalendar;
import org.jbpm.process.core.timer.DateTimeUtils;
import org.jbpm.process.core.timer.Timer;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.ProcessInstance;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.jbpm.process.instance.impl.Action;
import org.jbpm.process.instance.timer.TimerInstance;
import org.jbpm.process.instance.timer.TimerManager;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.node.StateBasedNode;
import org.jbpm.workflow.instance.NodeInstanceContainer;
import org.jbpm.workflow.instance.impl.ExtendedNodeInstanceImpl;
import org.jbpm.workflow.instance.impl.NodeInstanceResolverFactory;
import org.jbpm.workflow.instance.node.EventBasedNodeInstanceInterface;
import org.kie.api.event.rule.MatchCreatedEvent;
import org.kie.api.runtime.process.EventListener;
import org.kie.api.runtime.process.NodeInstance;
import org.mvel2.MVEL;
import org.mvel2.integration.VariableResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StateBasedNodeInstance
extends ExtendedNodeInstanceImpl
implements EventBasedNodeInstanceInterface,
EventListener {
    private static final long serialVersionUID = 510L;
    protected static final Pattern PARAMETER_MATCHER = Pattern.compile("#\\{([\\S&&[^\\}]]+)\\}", 32);
    private static final Logger logger = LoggerFactory.getLogger(StateBasedNodeInstance.class);
    private List<Long> timerInstances;

    public StateBasedNode getEventBasedNode() {
        return (StateBasedNode)this.getNode();
    }

    @Override
    public void internalTrigger(NodeInstance from, String type) {
        super.internalTrigger(from, type);
        Map<Timer, DroolsAction> timers = this.getEventBasedNode().getTimers();
        if (timers != null) {
            this.addTimerListener();
            this.timerInstances = new ArrayList<Long>(timers.size());
            TimerManager timerManager = ((InternalProcessRuntime)this.getProcessInstance().getKnowledgeRuntime().getProcessRuntime()).getTimerManager();
            for (Timer timer : timers.keySet()) {
                TimerInstance timerInstance = this.createTimerInstance(timer);
                timerManager.registerTimer(timerInstance, this.getProcessInstance());
                this.timerInstances.add(timerInstance.getId());
            }
        }
        if (this.getEventBasedNode().getBoundaryEvents() != null) {
            for (String name : this.getEventBasedNode().getBoundaryEvents()) {
                boolean isActive = ((InternalAgenda)this.getProcessInstance().getKnowledgeRuntime().getAgenda()).isRuleActiveInRuleFlowGroup("DROOLS_SYSTEM", name, this.getProcessInstance().getId());
                if (isActive) {
                    this.getProcessInstance().getKnowledgeRuntime().signalEvent(name, null);
                    continue;
                }
                this.addActivationListener();
            }
        }
    }

    protected TimerInstance createTimerInstance(Timer timer) {
        TimerInstance timerInstance = new TimerInstance();
        InternalKnowledgeRuntime kruntime = this.getProcessInstance().getKnowledgeRuntime();
        if (kruntime != null && kruntime.getEnvironment().get("jbpm.business.calendar") != null) {
            BusinessCalendar businessCalendar = (BusinessCalendar)kruntime.getEnvironment().get("jbpm.business.calendar");
            String delay = this.resolveVariable(timer.getDelay());
            timerInstance.setDelay(businessCalendar.calculateBusinessTimeAsDuration(delay));
            if (timer.getPeriod() == null) {
                timerInstance.setPeriod(0L);
            } else {
                String period = this.resolveVariable(timer.getPeriod());
                timerInstance.setPeriod(businessCalendar.calculateBusinessTimeAsDuration(period));
            }
        } else {
            this.configureTimerInstance(timer, timerInstance);
        }
        timerInstance.setTimerId(timer.getId());
        return timerInstance;
    }

    protected void configureTimerInstance(Timer timer, TimerInstance timerInstance) {
        String s = null;
        long duration = -1L;
        switch (timer.getTimeType()) {
            case 2: {
                if (timer.getPeriod() != null) {
                    timerInstance.setDelay(this.resolveValue(timer.getDelay()));
                    if (timer.getPeriod() == null) {
                        timerInstance.setPeriod(0L);
                        break;
                    }
                    timerInstance.setPeriod(this.resolveValue(timer.getPeriod()));
                    break;
                }
                long[] repeatValues = null;
                try {
                    repeatValues = DateTimeUtils.parseRepeatableDateTime(timer.getDelay());
                }
                catch (RuntimeDroolsException e) {
                    s = this.resolveVariable(timer.getDelay());
                    repeatValues = DateTimeUtils.parseRepeatableDateTime(s);
                }
                if (repeatValues.length == 3) {
                    int parsedReapedCount = (int)repeatValues[0];
                    if (parsedReapedCount > -1) {
                        timerInstance.setRepeatLimit(parsedReapedCount + 1);
                    }
                    timerInstance.setDelay(repeatValues[1]);
                    timerInstance.setPeriod(repeatValues[2]);
                    break;
                }
                if (repeatValues.length == 2) {
                    timerInstance.setDelay(repeatValues[0]);
                    timerInstance.setPeriod(repeatValues[1]);
                    break;
                }
                timerInstance.setDelay(repeatValues[0]);
                timerInstance.setPeriod(0L);
                break;
            }
            case 1: {
                try {
                    duration = DateTimeUtils.parseDuration(timer.getDelay());
                }
                catch (RuntimeDroolsException e) {
                    s = this.resolveVariable(timer.getDelay());
                    duration = DateTimeUtils.parseDuration(s);
                }
                timerInstance.setDelay(duration);
                timerInstance.setPeriod(0L);
                break;
            }
            case 3: {
                try {
                    duration = DateTimeUtils.parseDateAsDuration(timer.getDate());
                }
                catch (RuntimeDroolsException e) {
                    s = this.resolveVariable(timer.getDate());
                    duration = DateTimeUtils.parseDateAsDuration(s);
                }
                timerInstance.setDelay(duration);
                timerInstance.setPeriod(0L);
                break;
            }
        }
    }

    private long resolveValue(String s) {
        try {
            return TimeUtils.parseTimeString((String)s);
        }
        catch (RuntimeDroolsException e) {
            s = this.resolveVariable(s);
            return TimeUtils.parseTimeString((String)s);
        }
    }

    private String resolveVariable(String s) {
        HashMap<String, String> replacements = new HashMap<String, String>();
        Matcher matcher = PARAMETER_MATCHER.matcher(s);
        while (matcher.find()) {
            String variableValueString;
            Object variableValue;
            String paramName = matcher.group(1);
            if (replacements.get(paramName) != null) continue;
            VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.resolveContextInstance("VariableScope", paramName);
            if (variableScopeInstance != null) {
                variableValue = variableScopeInstance.getVariable(paramName);
                variableValueString = variableValue == null ? "" : variableValue.toString();
                replacements.put(paramName, variableValueString);
                continue;
            }
            try {
                variableValue = MVEL.eval((String)paramName, (VariableResolverFactory)new NodeInstanceResolverFactory(this));
                variableValueString = variableValue == null ? "" : variableValue.toString();
                replacements.put(paramName, variableValueString);
            }
            catch (Throwable t) {
                logger.error("Could not find variable scope for variable {}", (Object)paramName);
                logger.error("when trying to replace variable in processId for sub process {}", (Object)this.getNodeName());
                logger.error("Continuing without setting process id.");
            }
        }
        for (Map.Entry replacement : replacements.entrySet()) {
            s = s.replace("#{" + (String)replacement.getKey() + "}", (CharSequence)replacement.getValue());
        }
        return s;
    }

    public void signalEvent(String type, Object event) {
        if ("timerTriggered".equals(type)) {
            TimerInstance timerInstance = (TimerInstance)event;
            if (this.timerInstances.contains(timerInstance.getId())) {
                this.triggerTimer(timerInstance);
            }
        } else if (type.equals(this.getActivationType()) && event instanceof MatchCreatedEvent) {
            String name = ((MatchCreatedEvent)event).getMatch().getRule().getName();
            if (this.checkProcessInstance((Activation)((MatchCreatedEvent)event).getMatch())) {
                ((MatchCreatedEvent)event).getKieRuntime().signalEvent(name, null);
            }
        }
    }

    private void triggerTimer(TimerInstance timerInstance) {
        for (Map.Entry<Timer, DroolsAction> entry : this.getEventBasedNode().getTimers().entrySet()) {
            if (entry.getKey().getId() != timerInstance.getTimerId()) continue;
            this.executeAction((Action)entry.getValue().getMetaData("Action"));
            return;
        }
    }

    public String[] getEventTypes() {
        return new String[]{"timerTriggered", this.getActivationType()};
    }

    public void triggerCompleted() {
        this.triggerCompleted("DROOLS_DEFAULT", true);
    }

    @Override
    public void addEventListeners() {
        if (this.timerInstances != null && this.timerInstances.size() > 0) {
            this.addTimerListener();
        }
    }

    protected void addTimerListener() {
        this.getProcessInstance().addEventListener("timerTriggered", this, false);
    }

    @Override
    public void removeEventListeners() {
        this.getProcessInstance().removeEventListener("timerTriggered", this, false);
    }

    @Override
    protected void triggerCompleted(String type, boolean remove) {
        ((NodeInstanceContainer)this.getNodeInstanceContainer()).setCurrentLevel(this.getLevel());
        this.cancelTimers();
        this.removeActivationListener();
        super.triggerCompleted(type, remove);
    }

    public List<Long> getTimerInstances() {
        return this.timerInstances;
    }

    public void internalSetTimerInstances(List<Long> timerInstances) {
        this.timerInstances = timerInstances;
    }

    @Override
    public void cancel() {
        this.cancelTimers();
        this.removeEventListeners();
        this.removeActivationListener();
        super.cancel();
    }

    private void cancelTimers() {
        if (this.timerInstances != null) {
            TimerManager timerManager = ((InternalProcessRuntime)this.getProcessInstance().getKnowledgeRuntime().getProcessRuntime()).getTimerManager();
            for (Long id : this.timerInstances) {
                timerManager.cancelTimer(id);
            }
        }
    }

    protected String getActivationType() {
        return "RuleFlowStateEvent-" + this.getProcessInstance().getProcessId();
    }

    private void addActivationListener() {
        this.getProcessInstance().addEventListener(this.getActivationType(), this, true);
    }

    private void removeActivationListener() {
        this.getProcessInstance().removeEventListener(this.getActivationType(), this, true);
    }

    protected boolean checkProcessInstance(Activation activation) {
        Map declarations = activation.getSubRule().getOuterDeclarations();
        for (Declaration declaration : declarations.values()) {
            Object value;
            if (!"processInstance".equals(declaration.getIdentifier()) && !"org.kie.api.runtime.process.WorkflowProcessInstance".equals(declaration.getTypeName()) || !((value = declaration.getValue((InternalWorkingMemory)((StatefulKnowledgeSessionImpl)this.getProcessInstance().getKnowledgeRuntime()).session, activation.getTuple().get(declaration).getObject())) instanceof ProcessInstance)) continue;
            return ((ProcessInstance)value).getId() == this.getProcessInstance().getId();
        }
        return true;
    }
}

