/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.proxy;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javassist.NotFoundException;
import javassist.bytecode.Bytecode;
import javassist.bytecode.ClassFile;
import javassist.util.proxy.MethodHandler;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.bean.proxy.BytecodeMethodResolver;
import org.jboss.weld.bean.proxy.DecoratorProxy;
import org.jboss.weld.bean.proxy.ProxyFactory;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.injection.FieldInjectionPoint;
import org.jboss.weld.injection.ParameterInjectionPoint;
import org.jboss.weld.injection.WeldInjectionPoint;
import org.jboss.weld.interceptor.util.proxy.TargetInstanceProxy;
import org.jboss.weld.util.bytecode.BytecodeUtils;
import org.jboss.weld.util.bytecode.DescriptorUtils;
import org.jboss.weld.util.bytecode.MethodInformation;
import org.jboss.weld.util.bytecode.MethodUtils;
import org.jboss.weld.util.bytecode.RuntimeMethodInformation;
import org.jboss.weld.util.bytecode.StaticMethodInformation;

public class DecoratorProxyFactory<T>
extends ProxyFactory<T> {
    public static final String PROXY_SUFFIX = "DecoratorProxy";
    private final WeldInjectionPoint<?, ?> delegateInjectionPoint;
    private final Field delegateField;

    public DecoratorProxyFactory(Class<T> proxyType, WeldInjectionPoint<?, ?> delegateInjectionPoint, Bean<?> bean) {
        super(proxyType, Collections.emptySet(), bean);
        this.delegateInjectionPoint = delegateInjectionPoint;
        this.delegateField = delegateInjectionPoint instanceof FieldInjectionPoint ? ((FieldInjectionPoint)delegateInjectionPoint).getJavaMember() : null;
    }

    private void addHandlerInitializerMethod(ClassFile proxyClassType) throws Exception {
        StaticMethodInformation methodInfo = new StaticMethodInformation("_initMH", new Class[]{Object.class}, Void.TYPE, proxyClassType.getName(), 2);
        proxyClassType.addMethod(MethodUtils.makeMethod(methodInfo, new Class[0], this.createMethodHandlerInitializerBody(proxyClassType), proxyClassType.getConstPool()));
    }

    @Override
    protected void addAdditionalInterfaces(Set<Class<?>> interfaces) {
        interfaces.add(DecoratorProxy.class);
    }

    private Bytecode createMethodHandlerInitializerBody(ClassFile proxyClassType) {
        Bytecode b = new Bytecode(proxyClassType.getConstPool(), 1, 2);
        b.add(42);
        StaticMethodInformation methodInfo = new StaticMethodInformation("_initMH", new Class[]{Object.class}, Void.TYPE, proxyClassType.getName());
        DecoratorProxyFactory.invokeMethodHandler(proxyClassType, b, methodInfo, false, DEFAULT_METHOD_RESOLVER);
        b.addCheckcast("javassist/util/proxy/MethodHandler");
        b.addPutfield(proxyClassType.getName(), "methodHandler", DescriptorUtils.classToStringRepresentation(MethodHandler.class));
        b.add(177);
        log.trace("Created MH initializer body for decorator proxy:  " + this.getBeanType());
        return b;
    }

    @Override
    protected void addMethodsFromClass(ClassFile proxyClassType) {
        ParameterInjectionPoint parameterIP;
        Method initializerMethod = null;
        int delegateParameterPosition = -1;
        if (this.delegateInjectionPoint instanceof ParameterInjectionPoint && (parameterIP = (ParameterInjectionPoint)this.delegateInjectionPoint).getMember() instanceof Method) {
            initializerMethod = (Method)parameterIP.getMember();
            delegateParameterPosition = parameterIP.getPosition();
        }
        try {
            if (delegateParameterPosition >= 0) {
                this.addHandlerInitializerMethod(proxyClassType);
            }
            Class<?> cls = this.getBeanType();
            LinkedHashSet<Method> methods = new LinkedHashSet<Method>();
            this.decoratorMethods(cls, methods);
            for (Method method : methods) {
                RuntimeMethodInformation methodInfo = new RuntimeMethodInformation(method);
                if (method.getDeclaringClass().getName().equals("java.lang.Object") && !method.getName().equals("toString")) continue;
                Bytecode methodBody = null;
                if (delegateParameterPosition >= 0 && initializerMethod.equals(method)) {
                    methodBody = this.createDelegateInitializerCode(proxyClassType, methodInfo, delegateParameterPosition);
                }
                if (Modifier.isAbstract(method.getModifiers())) {
                    methodBody = this.createAbstractMethodCode(proxyClassType, methodInfo);
                }
                if (methodBody == null) continue;
                log.trace("Adding method " + method);
                proxyClassType.addMethod(MethodUtils.makeMethod(methodInfo, method.getExceptionTypes(), methodBody, proxyClassType.getConstPool()));
            }
        }
        catch (Exception e) {
            throw new WeldException(e);
        }
    }

    private void decoratorMethods(Class<?> cls, Set<Method> all) {
        if (cls == null) {
            return;
        }
        all.addAll(Arrays.asList(cls.getDeclaredMethods()));
        this.decoratorMethods(cls.getSuperclass(), all);
        for (Class<?> ifc : cls.getInterfaces()) {
            Method[] methods;
            for (Method m : methods = ifc.getDeclaredMethods()) {
                boolean isEqual = false;
                for (Method a : all) {
                    if (!DecoratorProxyFactory.isEqual(m, a)) continue;
                    isEqual = true;
                    break;
                }
                if (isEqual) continue;
                all.add(m);
            }
        }
    }

    private static boolean isEqual(Method m, Method a) {
        if (m.getName().equals(a.getName()) && m.getParameterTypes().length == a.getParameterTypes().length && m.getReturnType().isAssignableFrom(a.getReturnType())) {
            for (int i = 0; i < m.getParameterTypes().length; ++i) {
                if (m.getParameterTypes()[i].isAssignableFrom(a.getParameterTypes()[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    protected String getProxyNameSuffix() {
        return PROXY_SUFFIX;
    }

    private Bytecode createAbstractMethodCode(ClassFile file, MethodInformation method) throws NotFoundException {
        if (this.delegateField != null && !Modifier.isPrivate(this.delegateField.getModifiers())) {
            Bytecode b = new Bytecode(file.getConstPool());
            int localVariables = MethodUtils.calculateMaxLocals(method.getMethod());
            b.setMaxLocals(localVariables);
            b.addAload(0);
            b.addGetfield(file.getName(), this.delegateField.getName(), DescriptorUtils.classToStringRepresentation(this.delegateField.getType()));
            BytecodeUtils.loadParameters(b, method.getDescriptor());
            b.addInvokeinterface(this.delegateField.getType().getName(), method.getName(), method.getDescriptor(), localVariables);
            BytecodeUtils.addReturnInstruction(b, method.getReturnType());
            return b;
        }
        if (!Modifier.isPrivate(method.getMethod().getModifiers())) {
            return this.createAbstractMethodHandler(file, method);
        }
        return this.createInterceptorBody(file, method);
    }

    private Bytecode createAbstractMethodHandler(ClassFile file, MethodInformation methodInfo) {
        Bytecode b = new Bytecode(file.getConstPool());
        DecoratorProxyFactory.invokeMethodHandler(file, b, methodInfo, true, TargetInstanceBytecodeMethodResolver.INSTANCE);
        return b;
    }

    private Bytecode createDelegateInitializerCode(ClassFile file, MethodInformation intializerMethodInfo, int delegateParameterPosition) {
        Bytecode b = new Bytecode(file.getConstPool());
        b.addAload(0);
        int localVariables = 1;
        int actualDelegateParamterPosition = 0;
        for (int i = 0; i < intializerMethodInfo.getMethod().getParameterTypes().length; ++i) {
            if (i == delegateParameterPosition) {
                actualDelegateParamterPosition = localVariables;
            }
            Class<?> type = intializerMethodInfo.getMethod().getParameterTypes()[i];
            BytecodeUtils.addLoadInstruction(b, DescriptorUtils.classToStringRepresentation(type), localVariables);
            if (type == Long.TYPE || type == Double.TYPE) {
                localVariables += 2;
                continue;
            }
            ++localVariables;
        }
        b.addInvokespecial(file.getSuperclass(), intializerMethodInfo.getName(), intializerMethodInfo.getDescriptor());
        b.addAload(0);
        b.addAload(actualDelegateParamterPosition);
        b.addInvokevirtual(file.getName(), "_initMH", "(Ljava/lang/Object;)V");
        BytecodeUtils.addReturnInstruction(b, intializerMethodInfo.getReturnType());
        b.setMaxLocals(localVariables);
        return b;
    }

    protected static class TargetInstanceBytecodeMethodResolver
    implements BytecodeMethodResolver {
        static final TargetInstanceBytecodeMethodResolver INSTANCE = new TargetInstanceBytecodeMethodResolver();

        protected TargetInstanceBytecodeMethodResolver() {
        }

        @Override
        public void getDeclaredMethod(ClassFile file, Bytecode code, String declaringClass, String methodName, String[] parameterTypes) {
            StaticMethodInformation methodInfo = new StaticMethodInformation("getTargetClass", new String[0], "Ljava/lang/Class;", TargetInstanceProxy.class.getName());
            ProxyFactory.invokeMethodHandler(file, code, methodInfo, false, ProxyFactory.DEFAULT_METHOD_RESOLVER);
            code.addCheckcast("java/lang/Class");
            code.addLdc(methodName);
            code.addIconst(parameterTypes.length);
            code.addAnewarray("java.lang.Class");
            for (int i = 0; i < parameterTypes.length; ++i) {
                code.add(89);
                code.addIconst(i);
                String type = parameterTypes[i];
                BytecodeUtils.pushClassType(code, type);
                code.add(83);
            }
            code.addInvokevirtual("java.lang.Class", "getDeclaredMethod", "(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;");
        }
    }
}

