/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.backend.server;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.workbench.models.commons.backend.rule.BRDRLPersistence;
import org.drools.workbench.models.commons.shared.oracle.PackageDataModelOracle;
import org.drools.workbench.models.commons.shared.rule.RuleModel;
import org.drools.workbench.screens.guided.rule.model.GuidedEditorContent;
import org.drools.workbench.screens.guided.rule.service.GuidedRuleEditorService;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.backend.file.FileDiscoveryService;
import org.guvnor.common.services.backend.file.JavaFileFilter;
import org.guvnor.common.services.backend.validation.GenericValidator;
import org.guvnor.common.services.project.builder.events.InvalidateDMOProjectCacheEvent;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.service.ProjectService;
import org.guvnor.common.services.shared.file.CopyService;
import org.guvnor.common.services.shared.file.DeleteService;
import org.guvnor.common.services.shared.file.RenameService;
import org.guvnor.common.services.shared.metadata.MetadataService;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.commons.io.IOService;
import org.kie.commons.java.nio.base.options.CommentedOption;
import org.kie.commons.java.nio.file.DirectoryStream;
import org.kie.commons.java.nio.file.OpenOption;
import org.kie.commons.java.nio.file.Path;
import org.kie.commons.java.nio.file.attribute.FileAttribute;
import org.kie.workbench.common.services.backend.file.DslFileFilter;
import org.kie.workbench.common.services.backend.file.GlobalsFileFilter;
import org.kie.workbench.common.services.backend.source.SourceServices;
import org.kie.workbench.common.services.datamodel.service.DataModelService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.security.Identity;
import org.uberfire.workbench.events.ResourceAddedEvent;
import org.uberfire.workbench.events.ResourceOpenedEvent;
import org.uberfire.workbench.events.ResourceUpdatedEvent;

@Service
@ApplicationScoped
public class GuidedRuleEditorServiceImpl
implements GuidedRuleEditorService {
    private static final JavaFileFilter FILTER_JAVA = new JavaFileFilter();
    private static final DslFileFilter FILTER_DSLS = new DslFileFilter();
    private static final GlobalsFileFilter FILTER_GLOBALS = new GlobalsFileFilter();
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private MetadataService metadataService;
    @Inject
    private CopyService copyService;
    @Inject
    private DeleteService deleteService;
    @Inject
    private RenameService renameService;
    @Inject
    private Event<InvalidateDMOProjectCacheEvent> invalidateDMOProjectCache;
    @Inject
    private Event<ResourceOpenedEvent> resourceOpenedEvent;
    @Inject
    private Event<ResourceAddedEvent> resourceAddedEvent;
    @Inject
    private Event<ResourceUpdatedEvent> resourceUpdatedEvent;
    @Inject
    private Paths paths;
    @Inject
    private Identity identity;
    @Inject
    private SessionInfo sessionInfo;
    @Inject
    private DataModelService dataModelService;
    @Inject
    private FileDiscoveryService fileDiscoveryService;
    @Inject
    private ProjectService projectService;
    @Inject
    private SourceServices sourceServices;
    @Inject
    private GenericValidator genericValidator;

    public org.uberfire.backend.vfs.Path create(org.uberfire.backend.vfs.Path context, String fileName, RuleModel content, String comment) {
        try {
            Package pkg = this.projectService.resolvePackage(context);
            String packageName = pkg == null ? null : pkg.getPackageName();
            content.setPackageName(packageName);
            Path nioPath = this.paths.convert(context).resolve(fileName);
            org.uberfire.backend.vfs.Path newPath = this.paths.convert(nioPath, false);
            this.ioService.createFile(nioPath, new FileAttribute[0]);
            this.ioService.write(nioPath, this.toSource(newPath, content), new OpenOption[]{this.makeCommentedOption(comment)});
            this.resourceAddedEvent.fire((Object)new ResourceAddedEvent(newPath));
            return newPath;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public RuleModel load(org.uberfire.backend.vfs.Path path) {
        try {
            String drl = this.ioService.readAllString(this.paths.convert(path));
            String[] dsls = this.loadDslsForPackage(path);
            List<String> globals = this.loadGlobalsForPackage(path);
            this.resourceOpenedEvent.fire((Object)new ResourceOpenedEvent(path, this.sessionInfo));
            return BRDRLPersistence.getInstance().unmarshalUsingDSL(drl, globals, this.dataModelService.getDataModel(path), dsls);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public GuidedEditorContent loadContent(org.uberfire.backend.vfs.Path path) {
        try {
            RuleModel model = this.load(path);
            PackageDataModelOracle oracle = this.dataModelService.getDataModel(path);
            return new GuidedEditorContent(oracle, model);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    private String[] loadDslsForPackage(org.uberfire.backend.vfs.Path path) {
        ArrayList<String> dsls = new ArrayList<String>();
        org.uberfire.backend.vfs.Path packagePath = this.projectService.resolvePackage(path).getPackageMainResourcesPath();
        Path nioPackagePath = this.paths.convert(packagePath);
        Collection dslPaths = this.fileDiscoveryService.discoverFiles(nioPackagePath, (DirectoryStream.Filter)FILTER_DSLS);
        for (Path dslPath : dslPaths) {
            String dslDefinition = this.ioService.readAllString(dslPath);
            dsls.add(dslDefinition);
        }
        String[] result = new String[dsls.size()];
        return dsls.toArray(result);
    }

    private List<String> loadGlobalsForPackage(org.uberfire.backend.vfs.Path path) {
        ArrayList<String> globals = new ArrayList<String>();
        org.uberfire.backend.vfs.Path packagePath = this.projectService.resolvePackage(path).getPackageMainResourcesPath();
        Path nioPackagePath = this.paths.convert(packagePath);
        Collection globalPaths = this.fileDiscoveryService.discoverFiles(nioPackagePath, (DirectoryStream.Filter)FILTER_GLOBALS);
        for (Path globalPath : globalPaths) {
            String globalDefinition = this.ioService.readAllString(globalPath);
            globals.add(globalDefinition);
        }
        return globals;
    }

    public org.uberfire.backend.vfs.Path save(org.uberfire.backend.vfs.Path resource, RuleModel model, Metadata metadata, String comment) {
        try {
            Package pkg = this.projectService.resolvePackage(resource);
            String packageName = pkg == null ? null : pkg.getPackageName();
            model.setPackageName(packageName);
            this.ioService.write(this.paths.convert(resource), this.toSource(resource, model), this.metadataService.setUpAttributes(resource, metadata), new OpenOption[]{this.makeCommentedOption(comment)});
            this.resourceUpdatedEvent.fire((Object)new ResourceUpdatedEvent(resource, this.sessionInfo));
            return resource;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public void delete(org.uberfire.backend.vfs.Path path, String comment) {
        try {
            this.deleteService.delete(path, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path rename(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        try {
            return this.renameService.rename(path, newName, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path copy(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        try {
            return this.copyService.copy(path, newName, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public String toSource(org.uberfire.backend.vfs.Path path, RuleModel model) {
        try {
            return this.sourceServices.getServiceFor(this.paths.convert(path)).getSource(this.paths.convert(path), (Object)model);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public List<ValidationMessage> validate(org.uberfire.backend.vfs.Path path, RuleModel content) {
        try {
            String source = this.toSource(path, content);
            return this.genericValidator.validate(path, (InputStream)new ByteArrayInputStream(source.getBytes()), new DirectoryStream.Filter[]{FILTER_JAVA, FILTER_GLOBALS, FILTER_DSLS});
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    private CommentedOption makeCommentedOption(String commitMessage) {
        String name = this.identity.getName();
        Date when = new Date();
        CommentedOption co = new CommentedOption(name, null, commitMessage, when);
        return co;
    }
}

