/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.m2repo.backend.server;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.project.backend.server.POMContentHandler;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.m2repo.backend.server.ExtendedM2RepoService;
import org.guvnor.m2repo.backend.server.GuvnorM2Repository;
import org.guvnor.m2repo.model.JarListPageRow;
import org.guvnor.m2repo.service.M2RepoService;
import org.jboss.errai.bus.server.annotations.Service;
import org.uberfire.paging.PageRequest;
import org.uberfire.paging.PageResponse;

@Service
@ApplicationScoped
public class M2RepoServiceImpl
implements M2RepoService,
ExtendedM2RepoService {
    @Inject
    private GuvnorM2Repository repository;
    @Inject
    private POMContentHandler pomContentHandler;

    @Override
    public void deployJar(InputStream is, GAV gav) {
        this.repository.deployArtifact(is, gav);
    }

    @Override
    public InputStream loadJar(String path) {
        return this.repository.loadFile(path);
    }

    public String getJarName(String path) {
        return this.repository.getFileName(path);
    }

    public void deleteJar(String[] path) {
        this.repository.deleteFile(path);
    }

    public String loadPOMStringFromJar(String path) {
        return GuvnorM2Repository.loadPOMFromJar(path);
    }

    public GAV loadGAVFromJar(String path) {
        try {
            return this.pomContentHandler.toModel(GuvnorM2Repository.loadPOMFromJar(path)).getGav();
        }
        catch (IOException e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
        catch (XmlPullParserException e) {
            throw ExceptionUtilities.handleException((Exception)((Object)e));
        }
    }

    public PageResponse<JarListPageRow> listJars(PageRequest pageRequest, String filters) {
        Collection<File> files = this.repository.listFiles(filters);
        PageResponse response = new PageResponse();
        ArrayList<JarListPageRow> tradeRatePageRowList = new ArrayList<JarListPageRow>();
        int i = 0;
        for (File file : files) {
            if (i >= pageRequest.getStartRowIndex() + pageRequest.getPageSize()) break;
            if (i >= pageRequest.getStartRowIndex()) {
                JarListPageRow jarListPageRow = new JarListPageRow();
                jarListPageRow.setName(file.getName());
                String jarPath = file.getPath().substring(GuvnorM2Repository.M2_REPO_DIR.length() + 1);
                jarListPageRow.setPath(jarPath);
                jarListPageRow.setLastModified(new Date(file.lastModified()));
                tradeRatePageRowList.add(jarListPageRow);
            }
            ++i;
        }
        response.setPageRowList(tradeRatePageRowList);
        response.setStartRowIndex(pageRequest.getStartRowIndex());
        response.setTotalRowSize(files.size());
        response.setTotalRowSizeExact(true);
        return response;
    }

    public String getRepositoryURL(String baseURL) {
        if (baseURL == null || baseURL.isEmpty()) {
            return this.repository.getRepositoryURL();
        }
        if (baseURL.endsWith("/")) {
            return baseURL + "maven2/";
        }
        return baseURL + "/maven2/";
    }
}

