/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodel.backend.server.builder.packages;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.compiler.lang.dsl.DSLMappingEntry;
import org.drools.compiler.lang.dsl.DSLTokenizedMappingFile;
import org.drools.workbench.models.commons.shared.oracle.PackageDataModelOracle;
import org.drools.workbench.models.commons.shared.oracle.ProjectDataModelOracle;
import org.drools.workbench.models.commons.shared.rule.DSLSentence;
import org.drools.workbench.models.datamodel.oracle.PackageDataModelOracleImpl;
import org.drools.workbench.models.datamodel.oracle.ProjectDataModelOracleImpl;
import org.kie.commons.data.Pair;
import org.kie.workbench.common.services.datamodel.backend.server.builder.util.DataEnumLoader;
import org.kie.workbench.common.services.datamodel.backend.server.builder.util.GlobalsParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PackageDataModelOracleBuilder {
    private static final Logger log = LoggerFactory.getLogger(PackageDataModelOracleBuilder.class);
    private final String packageName;
    private PackageDataModelOracleImpl packageOracle = new PackageDataModelOracleImpl();
    private ProjectDataModelOracle projectOracle = new ProjectDataModelOracleImpl();
    private Map<String, String[]> factFieldEnums = new HashMap<String, String[]>();
    private List<DSLSentence> dslConditionSentences = new ArrayList<DSLSentence>();
    private List<DSLSentence> dslActionSentences = new ArrayList<DSLSentence>();
    private List<DSLSentence> dslKeywordItems = new ArrayList<DSLSentence>();
    private List<DSLSentence> dslAnyScopeItems = new ArrayList<DSLSentence>();
    private Map<String, String> packageGlobalTypes = new HashMap<String, String>();

    public static PackageDataModelOracleBuilder newPackageOracleBuilder() {
        return new PackageDataModelOracleBuilder("");
    }

    public static PackageDataModelOracleBuilder newPackageOracleBuilder(String packageName) {
        return new PackageDataModelOracleBuilder(packageName);
    }

    private PackageDataModelOracleBuilder(String packageName) {
        this.packageName = packageName;
    }

    public PackageDataModelOracleBuilder setProjectOracle(ProjectDataModelOracle projectOracle) {
        this.projectOracle = projectOracle;
        return this;
    }

    public PackageDataModelOracleBuilder addEnum(String factType, String fieldName, String[] values) {
        String qualifiedFactField = factType + "#" + fieldName;
        this.factFieldEnums.put(qualifiedFactField, values);
        return this;
    }

    public PackageDataModelOracleBuilder addEnum(String enumDefinition) {
        this.parseEnumDefinition(enumDefinition);
        return this;
    }

    private void parseEnumDefinition(String enumDefinition) {
        DataEnumLoader enumLoader = new DataEnumLoader(enumDefinition);
        if (!enumLoader.hasErrors()) {
            this.factFieldEnums.putAll(enumLoader.getData());
        }
    }

    public PackageDataModelOracleBuilder addDsl(String dslDefinition) {
        this.parseDslDefinition(dslDefinition);
        return this;
    }

    private void parseDslDefinition(String dslDefinition) {
        DSLTokenizedMappingFile dslLoader = new DSLTokenizedMappingFile();
        try {
            if (dslLoader.parseAndLoad((Reader)new StringReader(dslDefinition))) {
                this.populateDSLSentences(dslLoader);
            }
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
    }

    private void populateDSLSentences(DSLTokenizedMappingFile dslLoader) {
        for (DSLMappingEntry entry : dslLoader.getMapping().getEntries()) {
            if (entry.getSection() == DSLMappingEntry.CONDITION) {
                this.addDSLConditionSentence(entry.getMappingKey());
                continue;
            }
            if (entry.getSection() == DSLMappingEntry.CONSEQUENCE) {
                this.addDSLActionSentence(entry.getMappingKey());
                continue;
            }
            if (entry.getSection() == DSLMappingEntry.KEYWORD) {
                this.addDSLKeywordMapping(entry.getMappingKey());
                continue;
            }
            if (entry.getSection() != DSLMappingEntry.ANY) continue;
            this.addDSLAnyScopeMapping(entry.getMappingKey());
        }
    }

    private void addDSLConditionSentence(String definition) {
        DSLSentence sentence = new DSLSentence();
        sentence.setDefinition(definition);
        this.dslConditionSentences.add(sentence);
    }

    private void addDSLActionSentence(String definition) {
        DSLSentence sentence = new DSLSentence();
        sentence.setDefinition(definition);
        this.dslActionSentences.add(sentence);
    }

    private void addDSLKeywordMapping(String definition) {
        DSLSentence sentence = new DSLSentence();
        sentence.setDefinition(definition);
        this.dslKeywordItems.add(sentence);
    }

    private void addDSLAnyScopeMapping(String definition) {
        DSLSentence sentence = new DSLSentence();
        sentence.setDefinition(definition);
        this.dslAnyScopeItems.add(sentence);
    }

    public PackageDataModelOracleBuilder addGlobals(String definition) {
        List<Pair<String, String>> globals = GlobalsParser.parseGlobals(definition);
        for (Pair<String, String> g : globals) {
            this.packageGlobalTypes.put((String)g.getK1(), (String)g.getK2());
        }
        return this;
    }

    public PackageDataModelOracle build() {
        ProjectDataModelOracleImpl pd = (ProjectDataModelOracleImpl)this.projectOracle;
        this.packageOracle.addFactsAndFields(pd.getModelFields());
        this.packageOracle.addFieldParametersType(pd.getProjectFieldParametersType());
        this.packageOracle.addEnumDefinitions(pd.getProjectJavaEnumLists());
        this.packageOracle.addMethodInformation(pd.getProjectMethodInformation());
        this.packageOracle.addCollectionTypes(pd.getProjectCollectionTypes());
        this.packageOracle.addEventTypes(pd.getProjectEventTypes());
        this.packageOracle.addTypeSources(pd.getProjectTypeSources());
        this.packageOracle.addSuperTypes(pd.getProjectSuperTypes());
        this.packageOracle.addTypeAnnotations(pd.getTypeAnnotations());
        this.packageOracle.addTypeFieldsAnnotations(pd.getTypeFieldsAnnotations());
        this.packageOracle.getRuleNamesMap().putAll(pd.getRuleNamesMap());
        this.packageOracle.addPackageNames(pd.getPackageNames());
        this.loadEnums();
        this.loadDsls();
        this.loadGlobals();
        this.loadProjectOracle();
        return this.packageOracle;
    }

    private void loadProjectOracle() {
        this.packageOracle.setPackageName(this.packageName);
        this.packageOracle.filter();
    }

    private void loadEnums() {
        HashMap<String, String[]> loadableEnums = new HashMap<String, String[]>();
        for (Map.Entry<String, String[]> e : this.factFieldEnums.entrySet()) {
            String qualifiedFactField = e.getKey();
            loadableEnums.put(qualifiedFactField, e.getValue());
        }
        this.packageOracle.addPackageGuvnorEnums(loadableEnums);
    }

    private void loadDsls() {
        this.packageOracle.addPackageDslConditionSentences(this.dslConditionSentences);
        this.packageOracle.addPackageDslActionSentences(this.dslActionSentences);
    }

    private void loadGlobals() {
        this.packageOracle.addPackageGlobals(this.packageGlobalTypes);
    }
}

