/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodel.backend.server.builder.projects;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.workbench.models.commons.shared.oracle.model.FieldAccessorsAndMutators;
import org.drools.workbench.models.commons.shared.oracle.model.ModelField;
import org.drools.workbench.models.commons.shared.oracle.model.TypeSource;
import org.drools.workbench.models.datamodel.oracle.ProjectDataModelOracleImpl;
import org.kie.workbench.common.services.datamodel.backend.server.builder.projects.FactBuilder;
import org.kie.workbench.common.services.datamodel.backend.server.builder.projects.ProjectDataModelOracleBuilder;

public abstract class BaseFactBuilder
implements FactBuilder {
    private final ProjectDataModelOracleBuilder builder;
    private final String type;
    private final List<ModelField> fields = new ArrayList<ModelField>();
    private final boolean isCollection;
    private final boolean isEvent;
    private final TypeSource typeSource;

    public BaseFactBuilder(ProjectDataModelOracleBuilder builder, Class<?> clazz, boolean isEvent, TypeSource typeSource) {
        this.builder = builder;
        this.type = clazz.getName();
        this.isCollection = this.isCollection(clazz);
        this.isEvent = isEvent;
        this.typeSource = typeSource;
        this.addField(new ModelField("this", this.type, ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, ModelField.FIELD_ORIGIN.SELF, FieldAccessorsAndMutators.ACCESSOR, "this"));
    }

    public BaseFactBuilder(ProjectDataModelOracleBuilder builder, String type, boolean isCollection, boolean isEvent, TypeSource typeSource) {
        this.builder = builder;
        this.type = type;
        this.isCollection = isCollection;
        this.isEvent = isEvent;
        this.typeSource = typeSource;
        this.addField(new ModelField("this", type, ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, ModelField.FIELD_ORIGIN.SELF, FieldAccessorsAndMutators.ACCESSOR, "this"));
    }

    private boolean isCollection(Class<?> clazz) {
        return clazz != null && Collection.class.isAssignableFrom(clazz);
    }

    public String getType() {
        return this.type;
    }

    protected String getType(Class<?> clazz) {
        return clazz.getName();
    }

    protected FactBuilder addField(ModelField field) {
        this.fields.add(field);
        return this;
    }

    @Override
    public ProjectDataModelOracleBuilder end() {
        return this.builder;
    }

    @Override
    public void build(ProjectDataModelOracleImpl oracle) {
        oracle.addFactsAndFields(this.buildFactsAndFields());
        oracle.addCollectionTypes(this.buildCollectionTypes());
        oracle.addEventTypes(this.buildEventTypes());
        oracle.addTypeSources(this.buildTypeSources());
    }

    public ProjectDataModelOracleBuilder getDataModelBuilder() {
        return this.builder;
    }

    private Map<String, ModelField[]> buildFactsAndFields() {
        HashMap<String, ModelField[]> loadableFactsAndFields = new HashMap<String, ModelField[]>();
        ModelField[] loadableFields = new ModelField[this.fields.size()];
        this.fields.toArray(loadableFields);
        loadableFactsAndFields.put(this.type, loadableFields);
        return loadableFactsAndFields;
    }

    private Map<String, Boolean> buildCollectionTypes() {
        HashMap<String, Boolean> loadableCollectionTypes = new HashMap<String, Boolean>();
        loadableCollectionTypes.put(this.type, this.isCollection);
        return loadableCollectionTypes;
    }

    private Map<String, Boolean> buildEventTypes() {
        HashMap<String, Boolean> loadableEventTypes = new HashMap<String, Boolean>();
        loadableEventTypes.put(this.type, this.isEvent);
        return loadableEventTypes;
    }

    private Map<String, TypeSource> buildTypeSources() {
        HashMap<String, TypeSource> loadableTypeSources = new HashMap<String, TypeSource>();
        loadableTypeSources.put(this.type, this.typeSource);
        return loadableTypeSources;
    }
}

