/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodel.backend.server.cache;

import java.io.IOException;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.core.rule.TypeMetaInfo;
import org.drools.workbench.models.commons.shared.imports.Import;
import org.drools.workbench.models.commons.shared.imports.Imports;
import org.drools.workbench.models.commons.shared.oracle.ProjectDataModelOracle;
import org.drools.workbench.models.commons.shared.oracle.model.TypeSource;
import org.guvnor.common.services.backend.cache.LRUCache;
import org.guvnor.common.services.builder.Builder;
import org.guvnor.common.services.builder.LRUBuilderCache;
import org.guvnor.common.services.project.builder.events.InvalidateDMOProjectCacheEvent;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.model.ProjectImports;
import org.guvnor.common.services.project.service.POMService;
import org.guvnor.common.services.project.service.ProjectService;
import org.kie.api.builder.KieModule;
import org.kie.commons.io.IOService;
import org.kie.commons.java.nio.file.Files;
import org.kie.commons.java.nio.file.LinkOption;
import org.kie.commons.java.nio.file.Path;
import org.kie.commons.validation.PortablePreconditions;
import org.kie.scanner.KieModuleMetaData;
import org.kie.workbench.common.services.datamodel.backend.server.builder.projects.ProjectDataModelOracleBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;

@ApplicationScoped
@Named(value="ProjectDataModelOracleCache")
public class LRUProjectDataModelOracleCache
extends LRUCache<Project, ProjectDataModelOracle> {
    private static final Logger log = LoggerFactory.getLogger(LRUProjectDataModelOracleCache.class);
    private static final String DEFAULTPKG = "defaultpkg";
    @Inject
    private Paths paths;
    @Inject
    private POMService pomService;
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private ProjectService projectService;
    @Inject
    private LRUBuilderCache cache;

    public synchronized void invalidateProjectCache(@Observes InvalidateDMOProjectCacheEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        org.uberfire.backend.vfs.Path resourcePath = event.getResourcePath();
        Project project = this.projectService.resolveProject(resourcePath);
        if (project != null) {
            this.invalidateCache(project);
        }
    }

    public synchronized ProjectDataModelOracle assertProjectDataModelOracle(Project project) {
        ProjectDataModelOracle projectOracle = (ProjectDataModelOracle)this.getEntry(project);
        if (projectOracle == null) {
            projectOracle = this.makeProjectOracle(project);
            this.setEntry(project, projectOracle);
        }
        return projectOracle;
    }

    private ProjectDataModelOracle makeProjectOracle(Project project) {
        Builder builder = this.cache.assertBuilder(project);
        KieModuleMetaData kieModuleMetaData = KieModuleMetaData.Factory.newKieModuleMetaData((KieModule)builder.getKieModuleIgnoringErrors());
        ProjectDataModelOracleBuilder pdBuilder = ProjectDataModelOracleBuilder.newProjectOracleBuilder();
        pdBuilder.addPackages(kieModuleMetaData.getPackages());
        for (String packageName : kieModuleMetaData.getPackages()) {
            for (String className : kieModuleMetaData.getClasses(packageName)) {
                Class clazz = kieModuleMetaData.getClass(packageName, className);
                TypeMetaInfo typeMetaInfo = kieModuleMetaData.getTypeMetaInfo(clazz);
                TypeSource typeSource = builder.getClassSource(kieModuleMetaData, clazz);
                try {
                    pdBuilder.addClass(clazz, typeMetaInfo.isEvent(), typeSource);
                }
                catch (IOException ioe) {
                    log.error(ioe.getMessage());
                }
            }
        }
        Path nioExternalImportsPath = this.paths.convert(project.getImportsPath());
        if (Files.exists((Path)nioExternalImportsPath, (LinkOption[])new LinkOption[0])) {
            org.uberfire.backend.vfs.Path externalImportsPath = this.paths.convert(nioExternalImportsPath);
            ProjectImports projectImports = (ProjectImports)this.projectService.load(externalImportsPath);
            Imports imports = projectImports.getImports();
            for (Import item : imports.getImports()) {
                try {
                    Class<?> clazz = ((Object)((Object)this)).getClass().getClassLoader().loadClass(item.getType());
                    pdBuilder.addClass(clazz);
                }
                catch (ClassNotFoundException cnfe) {
                    log.error(cnfe.getMessage());
                }
                catch (IOException ioe) {
                    log.error(ioe.getMessage());
                }
            }
        }
        this.addAllRuleNames(builder, pdBuilder, project);
        return pdBuilder.build();
    }

    private void addAllRuleNames(Builder builder, ProjectDataModelOracleBuilder pdBuilder, Project project) {
        KieModuleMetaData kieModuleMetaData = KieModuleMetaData.Factory.newKieModuleMetaData((KieModule)builder.getKieModuleIgnoringErrors());
        for (Package pkg : this.projectService.resolvePackages(project)) {
            String packageName = pkg.getPackageName();
            if (packageName.isEmpty()) {
                packageName = DEFAULTPKG;
            }
            pdBuilder.addRuleNames(pkg.getPackageName(), kieModuleMetaData.getRuleNamesInPackage(packageName));
        }
    }
}

