/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.backend.file;

import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.shared.file.RenameService;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.commons.io.IOService;
import org.kie.commons.java.nio.base.options.CommentedOption;
import org.kie.commons.java.nio.file.CopyOption;
import org.kie.commons.java.nio.file.Path;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.security.Identity;
import org.uberfire.workbench.events.ResourceRenamedEvent;

@Service
public class RenameServiceImpl
implements RenameService {
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private Paths paths;
    @Inject
    private Identity identity;
    @Inject
    private SessionInfo sessionInfo;
    @Inject
    private Event<ResourceRenamedEvent> resourceRenamedEvent;

    public org.uberfire.backend.vfs.Path rename(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        try {
            System.out.println("USER:" + this.identity.getName() + " RENAMING asset [" + path.getFileName() + "] to [" + newName + "]");
            Path _path = this.paths.convert(path);
            String originalFileName = _path.getFileName().toString();
            String extension = originalFileName.substring(originalFileName.indexOf("."));
            Path _target = _path.resolveSibling(newName + extension);
            this.ioService.move(_path, _target, new CopyOption[]{new CommentedOption(this.identity.getName(), comment)});
            org.uberfire.backend.vfs.Path target = this.paths.convert(_target);
            this.resourceRenamedEvent.fire((Object)new ResourceRenamedEvent(path, target, this.sessionInfo));
            return target;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }
}

