/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client;

import com.google.gwt.animation.client.Animation;
import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.SimpleEventBus;
import com.google.gwt.place.shared.Place;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.RootLayoutPanel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.AppController;
import org.drools.guvnor.client.AppControllerImpl;
import org.drools.guvnor.client.LoginWidget;
import org.drools.guvnor.client.asseteditor.drools.standalone.StandaloneEditorManager;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.configurations.Capability;
import org.drools.guvnor.client.configurations.ConfigurationsLoader;
import org.drools.guvnor.client.configurations.UserCapabilities;
import org.drools.guvnor.client.examples.SampleRepositoryInstaller;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.explorer.FindPlace;
import org.drools.guvnor.client.explorer.drools.ClientFactoryImpl;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.moduleeditor.drools.SuggestionCompletionCache;
import org.drools.guvnor.client.resources.DroolsGuvnorResources;
import org.drools.guvnor.client.resources.GuvnorResources;
import org.drools.guvnor.client.resources.OperatorsResource;
import org.drools.guvnor.client.resources.RoundedCornersResource;
import org.drools.guvnor.client.resources.WizardCellListResources;
import org.drools.guvnor.client.resources.WizardResources;
import org.drools.guvnor.client.resources.decisiontable.DecisionTableResources;
import org.drools.guvnor.client.rpc.SecurityServiceAsync;
import org.drools.guvnor.client.rpc.UserSecurityContext;
import org.drools.guvnor.client.simulation.resources.SimulationResources;

public class GuvnorDroolsEntryPoint
implements EntryPoint {
    private AppController appController;

    public void onModuleLoad() {
        this.loadStyles();
        this.hideLoadingPopup();
        this.checkLogIn();
    }

    private void loadStyles() {
        GuvnorResources.INSTANCE.headerCss().ensureInjected();
        GuvnorResources.INSTANCE.guvnorCss().ensureInjected();
        DroolsGuvnorResources.INSTANCE.titledTextCellCss().ensureInjected();
        GuvnorResources.INSTANCE.guvnorCss().ensureInjected();
        DroolsGuvnorResources.INSTANCE.droolsGuvnorCss().ensureInjected();
        RoundedCornersResource.INSTANCE.roundCornersCss().ensureInjected();
        OperatorsResource.INSTANCE.operatorsCss().ensureInjected();
        WizardCellListResources.INSTANCE.cellListStyle().ensureInjected();
        WizardResources.INSTANCE.style().ensureInjected();
        DecisionTableResources.INSTANCE.style().ensureInjected();
        SimulationResources.INSTANCE.style().ensureInjected();
    }

    private void checkLogIn() {
        SecurityServiceAsync.INSTANCE.getCurrentUser((AsyncCallback)new GenericCallback<UserSecurityContext>(){

            public void onSuccess(UserSecurityContext userSecurityContext) {
                String userName = userSecurityContext.getUserName();
                if (userName != null) {
                    GuvnorDroolsEntryPoint.this.showMain(userName);
                } else {
                    GuvnorDroolsEntryPoint.this.logIn();
                }
            }
        });
    }

    private void logIn() {
        final LoginWidget loginWidget = new LoginWidget();
        loginWidget.setLoggedInEvent(new Command(){

            public void execute() {
                GuvnorDroolsEntryPoint.this.showMain(loginWidget.getUserName());
            }
        });
        loginWidget.show();
    }

    private void showMain(String userName) {
        Window.setStatus((String)Constants.INSTANCE.LoadingUserPermissions());
        this.loadConfigurations(userName);
    }

    private void loadConfigurations(final String userName) {
        ConfigurationsLoader.loadPreferences((Command)new Command(){

            public void execute() {
                GuvnorDroolsEntryPoint.this.loadUserCapabilities(userName);
            }
        });
    }

    private void loadUserCapabilities(final String userName) {
        ConfigurationsLoader.loadUserCapabilities((Command)new Command(){

            public void execute() {
                GuvnorDroolsEntryPoint.this.setUpMain(userName);
            }
        });
    }

    private void setUpMain(String userName) {
        Window.setStatus((String)" ");
        this.createMain();
        this.appController.setUserName(userName);
    }

    private void createMain() {
        SimpleEventBus eventBus = new SimpleEventBus();
        SuggestionCompletionCache.getInstance().setEventBus((EventBus)eventBus);
        ClientFactoryImpl clientFactory = new ClientFactoryImpl((EventBus)eventBus);
        this.appController = new AppControllerImpl((ClientFactory)clientFactory, (EventBus)eventBus);
        if (Window.Location.getPath().contains("StandaloneEditor.html")) {
            RootLayoutPanel.get().add((Widget)new StandaloneEditorManager((ClientFactory)clientFactory, (EventBus)eventBus).getBaseLayout());
        } else {
            RootLayoutPanel.get().add(this.appController.getMainPanel());
        }
        this.askToInstallSampleRepository();
        clientFactory.getPlaceController().goTo((Place)new FindPlace());
    }

    private void askToInstallSampleRepository() {
        if (UserCapabilities.INSTANCE.hasCapability(new Capability[]{Capability.SHOW_ADMIN})) {
            SampleRepositoryInstaller.askToInstall();
        }
    }

    private void hideLoadingPopup() {
        com.google.gwt.user.client.Element e = RootPanel.get((String)"loading").getElement();
        Animation r = new Animation((Element)e){
            final /* synthetic */ Element val$e;
            {
                this.val$e = element;
            }

            protected void onUpdate(double progress) {
                this.val$e.getStyle().setOpacity(1.0 - progress);
            }

            protected void onComplete() {
                this.val$e.getStyle().setVisibility(Style.Visibility.HIDDEN);
            }
        };
        r.run(500);
    }
}

