/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.modeldriven.ui;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.EnumDropDown;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.RuleModeller;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.TemplateKeyTextBox;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.events.TemplateVariablesChangedEvent;
import org.drools.guvnor.client.common.DirtyableComposite;
import org.drools.guvnor.client.common.DropDownValueChanged;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.InfoPopup;
import org.drools.guvnor.client.common.PopupDatePicker;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.common.TextBoxFactory;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.DroolsGuvnorImages;
import org.drools.guvnor.client.resources.GuvnorImages;
import org.drools.ide.common.client.modeldriven.DropDownData;
import org.drools.ide.common.client.modeldriven.brl.ActionFieldValue;
import org.drools.ide.common.client.modeldriven.brl.ActionInsertFact;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.FieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.RuleModel;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraint;

public class ActionValueEditor
extends DirtyableComposite {
    private ActionFieldValue value;
    private DropDownData enums;
    private SimplePanel root;
    private RuleModeller modeller;
    private RuleModel model;
    private EventBus eventBus;
    private String variableType = null;
    private boolean readOnly;
    private Command onChangeCommand;

    public ActionValueEditor(ActionFieldValue val, DropDownData enums, RuleModeller modeller, EventBus eventBus, String variableType, boolean readOnly) {
        this.readOnly = readOnly;
        this.enums = val.type.equals("Boolean") ? DropDownData.create((String[])new String[]{"true", "false"}) : enums;
        this.root = new SimplePanel();
        this.value = val;
        this.modeller = modeller;
        this.model = modeller.getModel();
        this.eventBus = eventBus;
        this.variableType = variableType;
        this.refresh();
        this.initWidget((Widget)this.root);
    }

    private void refresh() {
        this.root.clear();
        if (this.value.nature == 0L) {
            if (this.value.value != null && this.value.value.length() > 0) {
                this.value.nature = this.value.value.charAt(0) == '=' ? 2L : 1L;
            } else {
                this.root.add(this.choice());
                return;
            }
        }
        if (this.value.nature == 7L) {
            Widget box = this.wrap(this.templateKeyEditor());
            this.root.add(box);
            return;
        }
        if (this.value.nature == 2L) {
            Widget list = this.wrap(this.boundVariable());
            this.root.add(list);
            return;
        }
        if (this.enums != null && (this.enums.fixedList != null || this.enums.queryExpression != null)) {
            Widget list = this.wrap(this.enumEditor());
            this.root.add(list);
            return;
        }
        if (this.value.nature == 3L) {
            Widget box = this.wrap(this.formulaEditor());
            this.root.add(box);
            return;
        }
        Widget box = this.wrap(this.literalEditor());
        this.root.add(box);
    }

    private Widget wrap(Widget w) {
        HorizontalPanel wrapper = new HorizontalPanel();
        Image clear = DroolsGuvnorImages.INSTANCE.DeleteItemSmall();
        clear.setAltText(Constants.INSTANCE.RemoveActionValueDefinition());
        clear.setTitle(Constants.INSTANCE.RemoveActionValueDefinition());
        clear.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (Window.confirm((String)Constants.INSTANCE.RemoveActionValueDefinitionQuestion())) {
                    ActionValueEditor.this.value.setNature(0L);
                    ActionValueEditor.this.value.setValue(null);
                    ActionValueEditor.this.doTypeChosen();
                }
            }
        });
        wrapper.add(w);
        if (!this.readOnly) {
            wrapper.add((Widget)clear);
            wrapper.setCellVerticalAlignment((Widget)clear, HasVerticalAlignment.ALIGN_MIDDLE);
        }
        return wrapper;
    }

    private void doTypeChosen() {
        this.makeDirty();
        this.executeOnChangeCommand();
        this.executeOnTemplateVariablesChange();
        this.refresh();
    }

    private void doTypeChosen(FormStylePopup form) {
        this.doTypeChosen();
        form.hide();
    }

    private Widget boundVariable() {
        ListBox listVariable = new ListBox();
        listVariable.addItem(Constants.INSTANCE.Choose());
        List<String> bindings = this.getApplicableBindings();
        for (String v : bindings) {
            listVariable.addItem(v);
        }
        if (this.value.value.equals("=")) {
            listVariable.setSelectedIndex(0);
        } else {
            for (int i = 0; i < listVariable.getItemCount(); ++i) {
                if (!listVariable.getItemText(i).equals(this.value.value.substring(1))) continue;
                listVariable.setSelectedIndex(i);
            }
        }
        if (listVariable.getItemCount() > 0) {
            listVariable.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    ListBox w = (ListBox)event.getSource();
                    ((ActionValueEditor)ActionValueEditor.this).value.value = "=" + w.getValue(w.getSelectedIndex());
                    ActionValueEditor.this.executeOnChangeCommand();
                    ActionValueEditor.this.makeDirty();
                    ActionValueEditor.this.refresh();
                }
            });
        }
        if (this.readOnly) {
            return new SmallLabel(listVariable.getItemText(listVariable.getSelectedIndex()));
        }
        return listVariable;
    }

    private String assertValue() {
        if (this.value.getValue() == null) {
            return "";
        }
        return this.value.getValue();
    }

    private Widget enumEditor() {
        if (this.readOnly) {
            return new SmallLabel(this.assertValue());
        }
        EnumDropDown enumDropDown = new EnumDropDown(this.value.getValue(), new DropDownValueChanged(){

            public void valueChanged(String newText, String newValue) {
                ((ActionValueEditor)ActionValueEditor.this).value.value = newValue;
                ActionValueEditor.this.executeOnChangeCommand();
                ActionValueEditor.this.makeDirty();
            }
        }, this.enums);
        return enumDropDown;
    }

    private Widget literalEditor() {
        if (this.readOnly) {
            return new SmallLabel(this.assertValue());
        }
        if ("Date".equals(this.value.getType())) {
            PopupDatePicker dp = new PopupDatePicker(false);
            dp.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Date>(){

                public void onValueChange(ValueChangeEvent<Date> event) {
                    ActionValueEditor.this.value.setValue(PopupDatePicker.convertToString(event));
                }
            });
            dp.setValue(this.assertValue());
            return dp;
        }
        final TextBox box = TextBoxFactory.getTextBox(this.value.getType());
        box.setStyleName("constraint-value-Editor");
        box.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                ActionValueEditor.this.value.setValue(box.getText());
                ActionValueEditor.this.executeOnChangeCommand();
                ActionValueEditor.this.makeDirty();
            }
        });
        box.setText(this.assertValue());
        this.attachDisplayLengthHandler(box);
        return box;
    }

    private Widget templateKeyEditor() {
        if (this.readOnly) {
            return new SmallLabel(this.assertValue());
        }
        TemplateKeyTextBox box = new TemplateKeyTextBox();
        box.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                ActionValueEditor.this.value.setValue((String)event.getValue());
                ActionValueEditor.this.executeOnChangeCommand();
            }
        });
        box.setValue(this.assertValue(), true);
        this.attachDisplayLengthHandler((TextBox)box);
        return box;
    }

    private Widget formulaEditor() {
        if (this.readOnly) {
            return new SmallLabel(this.assertValue());
        }
        TextBox box = new TextBox();
        box.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                ActionValueEditor.this.value.setValue((String)event.getValue());
                ActionValueEditor.this.executeOnChangeCommand();
            }
        });
        box.setValue((Object)this.assertValue(), true);
        this.attachDisplayLengthHandler(box);
        return box;
    }

    private void attachDisplayLengthHandler(final TextBox box) {
        int length = box.getText().length();
        box.setVisibleLength(length > 0 ? length : 1);
        box.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                int length = box.getText().length();
                box.setVisibleLength(length > 0 ? length : 1);
            }
        });
    }

    private Widget choice() {
        if (this.readOnly) {
            return new HTML();
        }
        Image clickme = GuvnorImages.INSTANCE.Edit();
        clickme.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ActionValueEditor.this.showTypeChoice((Widget)event.getSource());
            }
        });
        return clickme;
    }

    protected void showTypeChoice(Widget w) {
        final FormStylePopup form = new FormStylePopup(DroolsGuvnorImages.INSTANCE.Wizard(), Constants.INSTANCE.FieldValue());
        Button lit = new Button(Constants.INSTANCE.LiteralValue());
        lit.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ((ActionValueEditor)ActionValueEditor.this).value.nature = 1L;
                ((ActionValueEditor)ActionValueEditor.this).value.value = "";
                ActionValueEditor.this.doTypeChosen(form);
            }
        });
        form.addAttribute(Constants.INSTANCE.LiteralValue() + ":", this.widgets(lit, new InfoPopup(Constants.INSTANCE.Literal(), Constants.INSTANCE.ALiteralValueMeansTheValueAsTypedInIeItsNotACalculation())));
        if (this.modeller.isTemplate()) {
            Button templateButton = new Button(Constants.INSTANCE.TemplateKey());
            templateButton.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    ((ActionValueEditor)ActionValueEditor.this).value.nature = 7L;
                    ((ActionValueEditor)ActionValueEditor.this).value.value = "";
                    ActionValueEditor.this.doTypeChosen(form);
                }
            });
            form.addAttribute(Constants.INSTANCE.TemplateKey() + ":", this.widgets(templateButton, new InfoPopup(Constants.INSTANCE.Literal(), Constants.INSTANCE.ALiteralValueMeansTheValueAsTypedInIeItsNotACalculation())));
        }
        form.addRow((Widget)new HTML("<hr/>"));
        form.addRow((Widget)new SmallLabel(Constants.INSTANCE.AdvancedSection()));
        Button formula = new Button(Constants.INSTANCE.Formula());
        formula.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ((ActionValueEditor)ActionValueEditor.this).value.nature = 3L;
                ((ActionValueEditor)ActionValueEditor.this).value.value = "=";
                ActionValueEditor.this.doTypeChosen(form);
            }
        });
        List<String> bindings = this.getApplicableBindings();
        if (bindings.size() > 0) {
            Button variable = new Button(Constants.INSTANCE.BoundVariable());
            form.addAttribute(Constants.INSTANCE.BoundVariable() + ":", (Widget)variable);
            variable.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    ((ActionValueEditor)ActionValueEditor.this).value.nature = 2L;
                    ((ActionValueEditor)ActionValueEditor.this).value.value = "=";
                    ActionValueEditor.this.doTypeChosen(form);
                }
            });
        }
        form.addAttribute(Constants.INSTANCE.Formula() + ":", this.widgets(formula, new InfoPopup(Constants.INSTANCE.Formula(), Constants.INSTANCE.FormulaTip())));
        form.show();
    }

    private List<String> getApplicableBindings() {
        ArrayList<String> bindings = new ArrayList<String>();
        for (String v : this.modeller.getModel().getAllVariables()) {
            ActionInsertFact aif;
            FieldConstraint fc;
            FactPattern fp = this.modeller.getModel().getLHSBoundFact(v);
            if (fp != null && this.isLHSFactTypeEquivalent(v)) {
                bindings.add(v);
            }
            if ((fc = this.modeller.getModel().getLHSBoundField(v)) != null && this.isLHSFieldTypeEquivalent(v)) {
                bindings.add(v);
            }
            if ((aif = this.modeller.getModel().getRHSBoundFact(v)) == null || !this.isRHSFieldTypeEquivalent(v)) continue;
            bindings.add(v);
        }
        return bindings;
    }

    private boolean isLHSFactTypeEquivalent(String boundVariable) {
        String boundFactType = this.modeller.getModel().getLHSBoundFact(boundVariable).getFactType();
        if (boundFactType.equals("Comparable")) {
            if (!this.variableType.equals("Comparable")) {
                return false;
            }
            String[] dd = this.modeller.getSuggestionCompletions().getEnumValues(boundFactType, this.value.field);
            return this.isEnumEquivalent(dd);
        }
        return boundFactType.equals(this.variableType);
    }

    private boolean isLHSFieldTypeEquivalent(String boundVariable) {
        String boundFieldType = this.modeller.getModel().getLHSBindingType(boundVariable);
        if (boundFieldType.equals("Comparable")) {
            if (!this.variableType.equals("Comparable")) {
                return false;
            }
            FieldConstraint fc = this.modeller.getModel().getLHSBoundField(boundVariable);
            if (fc instanceof SingleFieldConstraint) {
                String fieldName = ((SingleFieldConstraint)fc).getFieldName();
                String parentFactTypeForBinding = this.modeller.getModel().getLHSParentFactPatternForBinding(boundVariable).getFactType();
                String[] dd = this.modeller.getSuggestionCompletions().getEnumValues(parentFactTypeForBinding, fieldName);
                return this.isEnumEquivalent(dd);
            }
            return false;
        }
        return boundFieldType.equals(this.variableType);
    }

    private boolean isRHSFieldTypeEquivalent(String boundVariable) {
        String boundFactType = this.modeller.getModel().getRHSBoundFact((String)boundVariable).factType;
        if (boundFactType == null) {
            return false;
        }
        if (this.variableType == null) {
            return false;
        }
        if (boundFactType.equals("Comparable")) {
            if (!this.variableType.equals("Comparable")) {
                return false;
            }
            String[] dd = this.modeller.getSuggestionCompletions().getEnumValues(boundFactType, this.value.field);
            return this.isEnumEquivalent(dd);
        }
        return boundFactType.equals(this.variableType);
    }

    private boolean isEnumEquivalent(String[] values) {
        if (values == null && this.enums.fixedList != null) {
            return false;
        }
        if (values != null && this.enums.fixedList == null) {
            return false;
        }
        if (values.length != this.enums.fixedList.length) {
            return false;
        }
        for (int i = 0; i < values.length; ++i) {
            if (values[i].equals(this.enums.fixedList[i])) continue;
            return false;
        }
        return true;
    }

    private Widget widgets(Button lit, InfoPopup popup) {
        HorizontalPanel h = new HorizontalPanel();
        h.add((Widget)lit);
        h.add((Widget)popup);
        return h;
    }

    private void executeOnChangeCommand() {
        if (this.onChangeCommand != null) {
            this.onChangeCommand.execute();
        }
    }

    public Command getOnChangeCommand() {
        return this.onChangeCommand;
    }

    public void setOnChangeCommand(Command onChangeCommand) {
        this.onChangeCommand = onChangeCommand;
    }

    private void executeOnTemplateVariablesChange() {
        TemplateVariablesChangedEvent tvce = new TemplateVariablesChangedEvent(this.model);
        this.eventBus.fireEventFromSource((GwtEvent)tvce, (Object)this.model);
    }
}

