/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer.navigation.deployment;

import com.google.gwt.place.shared.Place;
import com.google.gwt.place.shared.PlaceTokenizer;
import java.util.Arrays;

public class SnapshotAssetListPlace
extends Place {
    private final String snapshotName;
    private final String moduleUuid;
    private final String[] assetTypes;

    public SnapshotAssetListPlace(String snapshotName, String moduleUuid, String[] assetTypes) {
        this.snapshotName = snapshotName;
        this.moduleUuid = moduleUuid;
        this.assetTypes = assetTypes;
    }

    public String getSnapshotName() {
        return this.snapshotName;
    }

    public String getModuleUuid() {
        return this.moduleUuid;
    }

    public String[] getAssetTypes() {
        return this.assetTypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        SnapshotAssetListPlace that = (SnapshotAssetListPlace)((Object)o);
        if (!Arrays.equals(this.assetTypes, that.assetTypes)) {
            return false;
        }
        if (this.moduleUuid != null ? !this.moduleUuid.equals(that.moduleUuid) : that.moduleUuid != null) {
            return false;
        }
        return !(this.snapshotName != null ? !this.snapshotName.equals(that.snapshotName) : that.snapshotName != null);
    }

    public int hashCode() {
        int result = this.snapshotName != null ? this.snapshotName.hashCode() : 0;
        result = 31 * result + (this.moduleUuid != null ? this.moduleUuid.hashCode() : 0);
        result = 31 * result + (this.assetTypes != null ? Arrays.hashCode(this.assetTypes) : 0);
        return result;
    }

    public static class Tokenizer
    implements PlaceTokenizer<SnapshotAssetListPlace> {
        private final String PLACE_ID = "SNAPSHOT_ASSET_LIST=";
        private final String MODULE_PARAMETER = "?MODULE_UUID=";
        private final String FORMATS = "&FORMATS=";

        public String getToken(SnapshotAssetListPlace place) {
            return "SNAPSHOT_ASSET_LIST=" + place.getSnapshotName() + "?MODULE_UUID=" + place.getModuleUuid() + "&FORMATS=" + this.formatsToString(place.getAssetTypes());
        }

        public SnapshotAssetListPlace getPlace(String token) {
            return new SnapshotAssetListPlace(this.subStringSnapshotName(token), this.subStringModuleUuid(token), this.subStringFormats(token));
        }

        private String subStringSnapshotName(String token) {
            return token.substring("SNAPSHOT_ASSET_LIST=".length(), token.indexOf("?MODULE_UUID="));
        }

        private String subStringModuleUuid(String token) {
            return token.substring(token.indexOf("?MODULE_UUID=") + "?MODULE_UUID=".length(), token.indexOf("&FORMATS="));
        }

        private String[] subStringFormats(String token) {
            return token.substring(token.indexOf("&FORMATS=") + "&FORMATS=".length()).split(",");
        }

        private String formatsToString(String[] assetTypes) {
            String result = assetTypes[0];
            for (int i = 1; i < assetTypes.length; ++i) {
                result = result + ",";
                result = result + assetTypes[i];
            }
            return result;
        }
    }
}

