/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.contenthandler.drools;

import com.google.gwt.user.client.rpc.SerializationException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.client.rpc.RuleContentText;
import org.drools.guvnor.server.contenthandler.IHasCustomValidator;
import org.drools.guvnor.server.contenthandler.PlainTextContentHandler;
import org.drools.guvnor.server.contenthandler.drools.WorkItemValidator;
import org.drools.guvnor.shared.api.PortableObject;
import org.drools.repository.AssetItem;
import org.drools.repository.ModuleItem;

public class WorkItemContentHandler
extends PlainTextContentHandler
implements IHasCustomValidator {
    public void retrieveAssetContent(Asset asset, ModuleItem pkg, AssetItem item) throws SerializationException {
        if (item.getContent() != null) {
            RuleContentText text = new RuleContentText();
            text.content = item.getContent();
            asset.setContent((PortableObject)text);
        }
    }

    public void storeAssetContent(Asset asset, AssetItem repoAsset) throws SerializationException {
        RuleContentText text = (RuleContentText)asset.getContent();
        try {
            ByteArrayInputStream input = new ByteArrayInputStream(text.content.getBytes("UTF-8"));
            repoAsset.updateBinaryContentAttachment((InputStream)input);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public String validate(String content) {
        WorkItemValidator widValidator = new WorkItemValidator();
        widValidator.setContent(content);
        return widValidator.validate();
    }

    public boolean validate(AssetItem assetItem) {
        return !super.validateAsset(assetItem).hasLines();
    }

    public String getFormat() {
        return "wid";
    }
}

