/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.jcr2vfsmigration;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.drools.guvnor.server.repository.GuvnorBootstrapConfiguration;
import org.drools.workbench.jcr2vfsmigration.Jcr2VfsMigrationApp;
import org.drools.workbench.jcr2vfsmigration.config.MigrationConfig;
import org.drools.workbench.jcr2vfsmigration.migrater.AssetMigrater;
import org.drools.workbench.jcr2vfsmigration.migrater.CategoryMigrater;
import org.drools.workbench.jcr2vfsmigration.migrater.ModuleMigrater;
import org.jboss.weld.context.bound.BoundRequestContext;
import org.jboss.weld.context.bound.BoundSessionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class Jcr2VfsMigrater {
    protected static final Logger logger = LoggerFactory.getLogger(Jcr2VfsMigrater.class);
    @Inject
    protected MigrationConfig migrationConfig;
    @Inject
    protected GuvnorBootstrapConfiguration guvnorBootstrapConfiguration;
    @Inject
    protected ModuleMigrater moduleMigrater;
    @Inject
    protected AssetMigrater assetMigrater;
    @Inject
    protected CategoryMigrater categoryMigrater;
    @Inject
    protected BoundSessionContext sessionContext;
    protected Map<String, Object> sessionDataStore;
    @Inject
    protected BoundRequestContext requestContext;
    protected Map<String, Object> requestDataStore;

    public boolean parseArgs(String[] args) {
        return this.migrationConfig.parseArgs(args);
    }

    public void migrateAll() {
        System.out.format("Migration started. Reading from inputJcrRepository ({%s}).\n", this.migrationConfig.getInputJcrRepository().getAbsolutePath());
        try {
            this.setupDirectories();
            this.startContexts();
            this.moduleMigrater.migrateAll();
            this.categoryMigrater.migrateAll();
            this.assetMigrater.migrateAll();
            this.endContexts();
        }
        catch (Throwable t) {
            Jcr2VfsMigrationApp.hasErrors = true;
            t.printStackTrace();
        }
        if (Jcr2VfsMigrationApp.hasWarnings) {
            System.out.format("Migration ended with warnings. Written into outputVfsRepository ({%s}).\n", this.migrationConfig.getOutputVfsRepository().getAbsolutePath());
        } else if (Jcr2VfsMigrationApp.hasErrors) {
            System.out.format("Migration ended with errors. Written into outputVfsRepository ({%s}).\n", this.migrationConfig.getOutputVfsRepository().getAbsolutePath());
        } else {
            System.out.format("Migration ended. Written into outputVfsRepository ({%s}).\n", this.migrationConfig.getOutputVfsRepository().getAbsolutePath());
        }
    }

    protected void setupDirectories() {
        this.guvnorBootstrapConfiguration.getProperties().put("repository.root.directory", this.determineJcrRepositoryRootDirectory());
        System.setProperty("org.kie.nio.git.dir", this.migrationConfig.getOutputVfsRepository().getAbsolutePath());
    }

    protected String determineJcrRepositoryRootDirectory() {
        File inputJcrRepository = this.migrationConfig.getInputJcrRepository();
        File repositoryXmlFile = new File(inputJcrRepository, "repository.xml");
        if (!repositoryXmlFile.exists()) {
            throw new IllegalStateException("The repositoryXmlFile (" + repositoryXmlFile.getAbsolutePath() + ") does not exist.\n" + "Check your inputJcrRepository (" + inputJcrRepository + ").");
        }
        File repositoryDir = new File(inputJcrRepository, "repository");
        if (!repositoryDir.exists()) {
            return inputJcrRepository.getAbsolutePath();
        }
        File unnestedVersionDir = new File(inputJcrRepository, "version");
        File nestedVersionDir = new File(repositoryDir, "version");
        if (unnestedVersionDir.exists()) {
            return inputJcrRepository.getAbsolutePath();
        }
        if (nestedVersionDir.exists()) {
            try {
                FileUtils.copyFile((File)repositoryXmlFile, (File)new File(repositoryDir, "repository.xml"));
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot copy repositoryXmlFile (" + repositoryXmlFile + ").", e);
            }
            return inputJcrRepository.getAbsolutePath() + "/repository";
        }
        return inputJcrRepository.getAbsolutePath();
    }

    protected void startContexts() {
        this.sessionDataStore = new HashMap<String, Object>();
        this.sessionContext.associate(this.sessionDataStore);
        this.sessionContext.activate();
        this.requestDataStore = new HashMap<String, Object>();
        this.requestContext.associate(this.requestDataStore);
        this.requestContext.activate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endContexts() {
        try {
            this.requestContext.invalidate();
            this.requestContext.deactivate();
        }
        finally {
            this.requestContext.dissociate(this.requestDataStore);
        }
        try {
            this.sessionContext.invalidate();
            this.sessionContext.deactivate();
        }
        finally {
            this.sessionContext.dissociate(this.sessionDataStore);
        }
    }
}

