/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.jcr2vfsmigration.migrater;

import com.google.gwt.user.client.rpc.SerializationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.drools.guvnor.client.rpc.AssetPageRequest;
import org.drools.guvnor.client.rpc.AssetPageRow;
import org.drools.guvnor.client.rpc.Module;
import org.drools.guvnor.client.rpc.PageResponse;
import org.drools.guvnor.client.rpc.TableDataResult;
import org.drools.guvnor.client.rpc.TableDataRow;
import org.drools.guvnor.server.RepositoryAssetService;
import org.drools.guvnor.server.RepositoryModuleService;
import org.drools.guvnor.server.repository.Preferred;
import org.drools.repository.AssetItem;
import org.drools.repository.RulesRepository;
import org.drools.workbench.jcr2vfsmigration.Jcr2VfsMigrationApp;
import org.drools.workbench.jcr2vfsmigration.migrater.PackageHeaderInfo;
import org.drools.workbench.jcr2vfsmigration.migrater.asset.AttachementAssetMigrater;
import org.drools.workbench.jcr2vfsmigration.migrater.asset.FactModelsMigrater;
import org.drools.workbench.jcr2vfsmigration.migrater.asset.GuidedDecisionTableMigrater;
import org.drools.workbench.jcr2vfsmigration.migrater.asset.GuidedEditorMigrater;
import org.drools.workbench.jcr2vfsmigration.migrater.asset.GuidedScoreCardMigrater;
import org.drools.workbench.jcr2vfsmigration.migrater.asset.PlainTextAssetMigrater;
import org.drools.workbench.jcr2vfsmigration.migrater.asset.PlainTextAssetWithPackagePropertyMigrater;
import org.drools.workbench.jcr2vfsmigration.migrater.asset.TestScenarioMigrater;
import org.drools.workbench.jcr2vfsmigration.migrater.util.MigrationPathManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;

@ApplicationScoped
public class AssetMigrater {
    protected static final Logger logger = LoggerFactory.getLogger(AssetMigrater.class);
    @Inject
    protected RepositoryModuleService jcrRepositoryModuleService;
    @Inject
    protected RepositoryAssetService jcrRepositoryAssetService;
    @Inject
    @Preferred
    private RulesRepository rulesRepository;
    @Inject
    protected FactModelsMigrater factModelsMigrater;
    @Inject
    protected GuidedEditorMigrater guidedEditorMigrater;
    @Inject
    protected PlainTextAssetMigrater plainTextAssetMigrater;
    @Inject
    protected PlainTextAssetWithPackagePropertyMigrater plainTextAssetWithPackagePropertyMigrater;
    @Inject
    protected GuidedDecisionTableMigrater guidedDecisionTableMigrater;
    @Inject
    protected AttachementAssetMigrater attachementAssetMigrater;
    @Inject
    protected GuidedScoreCardMigrater guidedScoreCardMigrater;
    @Inject
    protected TestScenarioMigrater testScenarioMigrater;
    @Inject
    protected MigrationPathManager migrationPathManager;
    @Inject
    private Paths paths;
    private String header = null;

    @Produces
    public PackageHeaderInfo getPackageHeaderInfo() {
        return new PackageHeaderInfo(this.header);
    }

    public void migrateAll() {
        System.out.println("  Asset migration started");
        Module[] jcrModules = this.jcrRepositoryModuleService.listModules();
        ArrayList<Module> modules = new ArrayList<Module>(Arrays.asList(jcrModules));
        Module globalModule = this.jcrRepositoryModuleService.loadGlobalModule();
        modules.add(globalModule);
        for (Module jcrModule : modules) {
            try {
                ArrayList<String> formats = new ArrayList<String>();
                formats.add("package");
                AssetPageRequest request = new AssetPageRequest(jcrModule.getUuid(), formats, null, 0, Integer.valueOf(10));
                PageResponse response = this.jcrRepositoryAssetService.findAssetPage(request);
                if (response.getTotalRowSize() > 0) {
                    AssetPageRow row = (AssetPageRow)response.getPageRowList().get(0);
                    AssetItem assetItemJCR = this.rulesRepository.loadAssetByUUID(row.getUuid());
                    this.header = assetItemJCR.getContent();
                }
            }
            catch (SerializationException e) {
                Jcr2VfsMigrationApp.hasErrors = true;
                throw new IllegalStateException(e);
            }
            boolean hasMorePages = true;
            int startRowIndex = 0;
            int pageSize = 100;
            while (hasMorePages) {
                PageResponse response;
                AssetPageRequest request = new AssetPageRequest(jcrModule.getUuid(), null, null, startRowIndex, Integer.valueOf(100));
                try {
                    response = this.jcrRepositoryAssetService.findAssetPage(request);
                    for (AssetPageRow row : response.getPageRowList()) {
                        AssetItem assetItemJCR = this.rulesRepository.loadAssetByUUID(row.getUuid());
                        System.out.format("    Asset [%s] with format [%s] is being migrated... \n", assetItemJCR.getName(), assetItemJCR.getFormat());
                        this.migrateAssetHistory(jcrModule, row.getUuid());
                        this.migrate(jcrModule, assetItemJCR);
                        System.out.format("    Done.\n", assetItemJCR.getName(), assetItemJCR.getFormat());
                    }
                }
                catch (SerializationException e) {
                    Jcr2VfsMigrationApp.hasErrors = true;
                    throw new IllegalStateException(e);
                }
                if (response.isLastPage()) {
                    hasMorePages = false;
                    continue;
                }
                startRowIndex += 100;
            }
        }
        System.out.println("  Asset migration ended");
    }

    private void migrate(Module jcrModule, AssetItem jcrAssetItem) throws SerializationException {
        if ("model.drl".equals(jcrAssetItem.getFormat())) {
            this.factModelsMigrater.migrate(jcrModule, jcrAssetItem);
        } else if ("brl".equals(jcrAssetItem.getFormat())) {
            this.guidedEditorMigrater.migrate(jcrModule, jcrAssetItem);
        } else if ("gdst".equals(jcrAssetItem.getFormat())) {
            this.guidedDecisionTableMigrater.migrate(jcrModule, jcrAssetItem);
        } else if ("enumeration".equals(jcrAssetItem.getFormat()) || "dsl".equals(jcrAssetItem.getFormat()) || "dslr".equals(jcrAssetItem.getFormat()) || "template".equals(jcrAssetItem.getFormat()) || "function".equals(jcrAssetItem.getFormat()) || "formdef".equals(jcrAssetItem.getFormat()) || "springContext".equals(jcrAssetItem.getFormat()) || "serviceConfig".equals(jcrAssetItem.getFormat()) || "wid".equals(jcrAssetItem.getFormat()) || "changeset".equals(jcrAssetItem.getFormat()) || "rf".equals(jcrAssetItem.getFormat()) || "bpmn".equals(jcrAssetItem.getFormat()) || "bpmn2".equals(jcrAssetItem.getFormat()) || "ftl".equals(jcrAssetItem.getFormat()) || "json".equals(jcrAssetItem.getFormat()) || "fw".equals(jcrAssetItem.getFormat())) {
            this.plainTextAssetMigrater.migrate(jcrModule, jcrAssetItem);
        } else if ("drl".equals(jcrAssetItem.getFormat())) {
            this.plainTextAssetWithPackagePropertyMigrater.migrate(jcrModule, jcrAssetItem);
        } else if ("xls".equals(jcrAssetItem.getFormat()) || "scxls".equals(jcrAssetItem.getFormat()) || "png".equals(jcrAssetItem.getFormat()) || "gif".equals(jcrAssetItem.getFormat()) || "jpg".equals(jcrAssetItem.getFormat()) || "pdf".equals(jcrAssetItem.getFormat()) || "doc".equals(jcrAssetItem.getFormat()) || "odt".equals(jcrAssetItem.getFormat())) {
            this.attachementAssetMigrater.migrate(jcrModule, jcrAssetItem);
        } else if ("jar".equals(jcrAssetItem.getFormat())) {
            Jcr2VfsMigrationApp.hasWarnings = true;
            System.out.println("    WARNING: POJO Model jar [" + jcrAssetItem.getName() + "] is not supported by migration tool. Please add your POJO model jar to Guvnor manually.");
        } else if ("scgd".equals(jcrAssetItem.getFormat())) {
            this.guidedScoreCardMigrater.migrate(jcrModule, jcrAssetItem);
        } else if ("scenario".equals(jcrAssetItem.getFormat())) {
            this.testScenarioMigrater.migrate(jcrModule, jcrAssetItem);
        } else if (!"package".equals(jcrAssetItem.getFormat())) {
            Jcr2VfsMigrationApp.hasWarnings = true;
            System.out.format("    WARNING: asset [%s] with format[%s] is not supported by migration tool. \n", jcrAssetItem.getName(), jcrAssetItem.getFormat());
        }
    }

    public void migrateAssetHistory(Module jcrModule, String assetUUID) throws SerializationException {
        TableDataResult history = this.jcrRepositoryAssetService.loadItemHistory(assetUUID);
        TableDataRow[] rows = history.data;
        Arrays.sort(rows, new Comparator<TableDataRow>(){

            @Override
            public int compare(TableDataRow r1, TableDataRow r2) {
                Integer v2 = Integer.valueOf(r2.values[0]);
                Integer v1 = Integer.valueOf(r1.values[0]);
                return v1.compareTo(v2);
            }
        });
        for (TableDataRow row : rows) {
            String versionSnapshotUUID = row.id;
            AssetItem historicalAssetJCR = this.rulesRepository.loadAssetByUUID(versionSnapshotUUID);
            this.migrate(jcrModule, historicalAssetJCR);
            logger.debug("    Asset ({}) with format ({}) migrated: version [{}], comment[{}], lastModified[{}]", new Object[]{historicalAssetJCR.getName(), historicalAssetJCR.getFormat(), historicalAssetJCR.getVersionNumber(), historicalAssetJCR.getCheckinComment(), historicalAssetJCR.getLastModified().getTime()});
        }
    }
}

