/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.jcr2vfsmigration.migrater;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.drools.guvnor.client.rpc.Module;
import org.drools.guvnor.server.RepositoryModuleService;
import org.drools.workbench.jcr2vfsmigration.migrater.util.MigrationPathManager;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.service.ProjectService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.repositories.Repository;
import org.uberfire.backend.repositories.impl.git.GitRepository;
import org.uberfire.backend.vfs.Path;

@ApplicationScoped
public class ModuleMigrater {
    protected static final Logger logger = LoggerFactory.getLogger(ModuleMigrater.class);
    @Inject
    protected RepositoryModuleService jcrRepositoryModuleService;
    @Inject
    protected MigrationPathManager migrationPathManager;
    @Inject
    protected ProjectService projectService;

    public void migrateAll() {
        Module[] jcrModules;
        System.out.println("  Module migration started");
        for (Module jcrModule : jcrModules = this.jcrRepositoryModuleService.listModules()) {
            this.migrate(jcrModule);
            System.out.format("    Module [%s] migrated. \n", jcrModule.getName());
        }
        Module globalModule = this.jcrRepositoryModuleService.loadGlobalModule();
        this.migrate(globalModule);
        System.out.println("    Global migrated.");
        System.out.println("  Module migration ended");
    }

    private void migrate(Module jcrModule) {
        GAV gav = new GAV(jcrModule.getName(), jcrModule.getName(), "0.0.1");
        POM pom = new POM(gav);
        Path modulePath = this.migrationPathManager.generateRootPath();
        this.projectService.newProject(this.makeRepository(modulePath), jcrModule.getName(), pom, "http://localhost");
    }

    private Repository makeRepository(final Path repositoryRoot) {
        return new GitRepository(){

            public Path getRoot() {
                return repositoryRoot;
            }
        };
    }
}

