/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.jcr2vfsmigration.migrater.asset;

import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.drools.guvnor.client.rpc.Module;
import org.drools.guvnor.server.RepositoryAssetService;
import org.drools.guvnor.server.util.Discussion;
import org.drools.repository.AssetItem;
import org.drools.repository.CategoryItem;
import org.drools.workbench.jcr2vfsmigration.migrater.util.MigrationPathManager;
import org.guvnor.common.services.shared.metadata.MetadataService;
import org.guvnor.common.services.shared.metadata.model.DiscussionRecord;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.Path;

@ApplicationScoped
public class BaseAssetMigrater {
    protected static final Logger logger = LoggerFactory.getLogger(BaseAssetMigrater.class);
    @Inject
    protected RepositoryAssetService jcrRepositoryAssetService;
    @Inject
    private Paths paths;
    @Inject
    protected MigrationPathManager migrationPathManager;
    @Inject
    protected MetadataService metadataService;

    public Map<String, Object> migrateMetaData(Module jcrModule, AssetItem jcrAssetItem) {
        Metadata metadata = new Metadata();
        List discussions = new Discussion().fromString(jcrAssetItem.getStringProperty("discussion"));
        if (discussions.size() != 0) {
            for (org.drools.guvnor.client.rpc.DiscussionRecord discussion : discussions) {
                metadata.addDiscussion(new DiscussionRecord(discussion.timestamp, discussion.author, discussion.note));
            }
        }
        metadata.setDescription(jcrAssetItem.getDescription());
        metadata.setSubject(jcrAssetItem.getSubject());
        metadata.setExternalRelation(jcrAssetItem.getExternalRelation());
        metadata.setExternalSource(jcrAssetItem.getExternalSource());
        List jcrCategories = jcrAssetItem.getCategories();
        for (CategoryItem c : jcrCategories) {
            metadata.addCategory(c.getFullPath());
        }
        Path path = this.migrationPathManager.generatePathForAsset(jcrModule, jcrAssetItem);
        return this.metadataService.setUpAttributes(path, metadata);
    }
}

