/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.jcr2vfsmigration.migrater.asset;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.guvnor.client.rpc.Module;
import org.drools.guvnor.server.RepositoryAssetService;
import org.drools.repository.AssetItem;
import org.drools.workbench.jcr2vfsmigration.migrater.PackageHeaderInfo;
import org.drools.workbench.jcr2vfsmigration.migrater.PackageImportHelper;
import org.drools.workbench.jcr2vfsmigration.migrater.asset.BaseAssetMigrater;
import org.drools.workbench.jcr2vfsmigration.migrater.util.MigrationPathManager;
import org.drools.workbench.models.commons.backend.imports.ImportsParser;
import org.drools.workbench.models.commons.shared.imports.Imports;
import org.drools.workbench.models.guided.dtable.backend.GuidedDTXMLPersistence;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.rule.service.GuidedRuleEditorService;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.service.ProjectService;
import org.kie.commons.io.IOService;
import org.kie.commons.java.nio.base.options.CommentedOption;
import org.kie.commons.java.nio.file.Files;
import org.kie.commons.java.nio.file.LinkOption;
import org.kie.commons.java.nio.file.OpenOption;
import org.kie.commons.java.nio.file.Path;
import org.kie.commons.java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;

@ApplicationScoped
public class GuidedDecisionTableMigrater
extends BaseAssetMigrater {
    protected static final Logger logger = LoggerFactory.getLogger(GuidedDecisionTableMigrater.class);
    @Inject
    protected RepositoryAssetService jcrRepositoryAssetService;
    @Inject
    protected GuidedRuleEditorService guidedRuleEditorService;
    @Inject
    protected MigrationPathManager migrationPathManager;
    @Inject
    private Paths paths;
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    protected PackageImportHelper packageImportHelper;
    @Inject
    private ProjectService projectService;
    @Inject
    private PackageHeaderInfo packageHeaderInfo;

    public void migrate(Module jcrModule, AssetItem jcrAssetItem) {
        Imports imports;
        String requiredPackageName;
        if (!"gdst".equals(jcrAssetItem.getFormat())) {
            throw new IllegalArgumentException("The jcrAsset (" + jcrAssetItem.getName() + ") has the wrong format (" + jcrAssetItem.getFormat() + ").");
        }
        org.uberfire.backend.vfs.Path path = this.migrationPathManager.generatePathForAsset(jcrModule, jcrAssetItem);
        Path nioPath = this.paths.convert(path);
        if (!Files.exists((Path)nioPath, (LinkOption[])new LinkOption[0])) {
            this.ioService.createFile(nioPath, new FileAttribute[0]);
        }
        String content = jcrAssetItem.getContent();
        content = content.replaceAll("org.drools.guvnor.client.modeldriven.dt52.Pattern52", "Pattern52");
        GuidedDecisionTable52 model = GuidedDTXMLPersistence.getInstance().unmarshal(content);
        Package pkg = this.projectService.resolvePackage(path);
        String string = requiredPackageName = pkg == null ? null : pkg.getPackageName();
        if (requiredPackageName != null || !"".equals(requiredPackageName)) {
            model.setPackageName(requiredPackageName);
        }
        if (this.packageHeaderInfo.getHeader() != null && (imports = ImportsParser.parseImports((String)this.packageHeaderInfo.getHeader())) != null) {
            model.setImports(imports);
        }
        String sourceContent = GuidedDTXMLPersistence.getInstance().marshal(model);
        this.ioService.write(nioPath, sourceContent, this.migrateMetaData(jcrModule, jcrAssetItem), new OpenOption[]{new CommentedOption(jcrAssetItem.getLastContributor(), null, jcrAssetItem.getCheckinComment(), jcrAssetItem.getLastModified().getTime())});
    }
}

