/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.jcr2vfsmigration.migrater.asset;

import com.google.gwt.user.client.rpc.SerializationException;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.client.rpc.Module;
import org.drools.guvnor.server.RepositoryAssetService;
import org.drools.guvnor.server.builder.BRMSPackageBuilder;
import org.drools.guvnor.server.contenthandler.drools.BRLContentHandler;
import org.drools.guvnor.server.repository.Preferred;
import org.drools.ide.common.client.modeldriven.brl.RuleModel;
import org.drools.ide.common.server.util.BRLPersistence;
import org.drools.ide.common.server.util.BRXMLPersistence;
import org.drools.repository.AssetItem;
import org.drools.repository.RulesRepository;
import org.drools.workbench.jcr2vfsmigration.migrater.PackageImportHelper;
import org.drools.workbench.jcr2vfsmigration.migrater.asset.BaseAssetMigrater;
import org.drools.workbench.jcr2vfsmigration.migrater.util.MigrationPathManager;
import org.drools.workbench.screens.drltext.service.DRLTextEditorService;
import org.drools.workbench.screens.guided.rule.service.GuidedRuleEditorService;
import org.kie.commons.io.IOService;
import org.kie.commons.java.nio.base.options.CommentedOption;
import org.kie.commons.java.nio.file.Files;
import org.kie.commons.java.nio.file.LinkOption;
import org.kie.commons.java.nio.file.OpenOption;
import org.kie.commons.java.nio.file.Path;
import org.kie.commons.java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;

@ApplicationScoped
public class GuidedEditorMigrater
extends BaseAssetMigrater {
    protected static final Logger logger = LoggerFactory.getLogger(GuidedEditorMigrater.class);
    @Inject
    protected RepositoryAssetService jcrRepositoryAssetService;
    @Inject
    @Preferred
    private RulesRepository rulesRepository;
    @Inject
    protected GuidedRuleEditorService guidedRuleEditorService;
    @Inject
    protected MigrationPathManager migrationPathManager;
    @Inject
    private Paths paths;
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    DRLTextEditorService drlTextEditorServiceImpl;
    @Inject
    PackageImportHelper packageImportHelper;

    public void migrate(Module jcrModule, AssetItem jcrAssetItem) {
        if (!"brl".equals(jcrAssetItem.getFormat())) {
            throw new IllegalArgumentException("The jcrAsset (" + jcrAssetItem.getName() + ") has the wrong format (" + jcrAssetItem.getFormat() + ").");
        }
        try {
            Asset jcrAsset = this.jcrRepositoryAssetService.loadRuleAsset(jcrAssetItem.getUUID());
            RuleModel ruleModel = this.getBrlXmlPersistence().unmarshal(jcrAssetItem.getContent());
            org.uberfire.backend.vfs.Path path = null;
            path = ruleModel.hasDSLSentences() ? this.migrationPathManager.generatePathForAsset(jcrModule, jcrAssetItem, true) : this.migrationPathManager.generatePathForAsset(jcrModule, jcrAssetItem, false);
            Path nioPath = this.paths.convert(path);
            if (!Files.exists((Path)nioPath, (LinkOption[])new LinkOption[0])) {
                this.ioService.createFile(nioPath, new FileAttribute[0]);
            }
            StringBuilder sb = new StringBuilder();
            BRMSPackageBuilder builder = new BRMSPackageBuilder(this.rulesRepository.loadModuleByUUID(jcrModule.getUuid()));
            BRLContentHandler handler = new BRLContentHandler();
            handler.assembleDRL(builder, jcrAsset, sb);
            String content = sb.toString().replaceAll("#", "//");
            String sourceDRLWithImport = this.drlTextEditorServiceImpl.assertPackageName(content, path);
            sourceDRLWithImport = this.packageImportHelper.assertPackageImportDRL(sourceDRLWithImport, path);
            this.ioService.write(nioPath, sourceDRLWithImport, this.migrateMetaData(jcrModule, jcrAssetItem), new OpenOption[]{new CommentedOption(jcrAssetItem.getLastContributor(), null, jcrAssetItem.getCheckinComment(), jcrAssetItem.getLastModified().getTime())});
        }
        catch (SerializationException e) {
            e.printStackTrace();
        }
    }

    protected BRLPersistence getBrlXmlPersistence() {
        return BRXMLPersistence.getInstance();
    }
}

