/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.jcr2vfsmigration.migrater.asset;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.guvnor.client.rpc.Module;
import org.drools.guvnor.server.RepositoryAssetService;
import org.drools.repository.AssetItem;
import org.drools.workbench.jcr2vfsmigration.migrater.asset.BaseAssetMigrater;
import org.drools.workbench.jcr2vfsmigration.migrater.util.DRLMigrationUtils;
import org.drools.workbench.jcr2vfsmigration.migrater.util.MigrationPathManager;
import org.kie.commons.io.IOService;
import org.kie.commons.java.nio.base.options.CommentedOption;
import org.kie.commons.java.nio.file.Files;
import org.kie.commons.java.nio.file.LinkOption;
import org.kie.commons.java.nio.file.OpenOption;
import org.kie.commons.java.nio.file.Path;
import org.kie.commons.java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;

@ApplicationScoped
public class PlainTextAssetMigrater
extends BaseAssetMigrater {
    protected static final Logger logger = LoggerFactory.getLogger(PlainTextAssetMigrater.class);
    @Inject
    protected RepositoryAssetService jcrRepositoryAssetService;
    @Inject
    private Paths paths;
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    protected MigrationPathManager migrationPathManager;

    public void migrate(Module jcrModule, AssetItem jcrAssetItem) {
        org.uberfire.backend.vfs.Path path = this.migrationPathManager.generatePathForAsset(jcrModule, jcrAssetItem);
        Path nioPath = this.paths.convert(path);
        if (!Files.exists((Path)nioPath, (LinkOption[])new LinkOption[0])) {
            this.ioService.createFile(nioPath, new FileAttribute[0]);
        }
        String content = jcrAssetItem.getContent();
        if ("dsl".equals(jcrAssetItem.getFormat()) || "dslr".equals(jcrAssetItem.getFormat()) || "template".equals(jcrAssetItem.getFormat()) || "drl".equals(jcrAssetItem.getFormat()) || "function".equals(jcrAssetItem.getFormat())) {
            content = DRLMigrationUtils.migrateStartOfCommentChar(content);
        }
        this.ioService.write(nioPath, content, this.migrateMetaData(jcrModule, jcrAssetItem), new OpenOption[]{new CommentedOption(jcrAssetItem.getLastContributor(), null, jcrAssetItem.getCheckinComment(), jcrAssetItem.getLastModified().getTime())});
    }
}

