/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.jcr2vfsmigration.vfs;

import java.net.URI;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import javax.enterprise.inject.Produces;
import javax.inject.Named;
import javax.inject.Singleton;
import org.kie.commons.io.FileSystemType;
import org.kie.commons.io.IOService;
import org.kie.commons.io.impl.IOServiceDotFileImpl;
import org.kie.commons.java.nio.file.FileSystem;
import org.uberfire.backend.repositories.Repository;
import org.uberfire.backend.server.repositories.SystemRepository;

@Singleton
public class IOServiceFactory {
    private final IOService ioService = new IOServiceDotFileImpl();
    private FileSystem fs;
    public static String DEFAULT_MIGRATION_FILE_SYSTEM = "guvnor-jcr2vfs-migration";

    @PostConstruct
    public void onStartup() {
        URI uri = URI.create("git://" + DEFAULT_MIGRATION_FILE_SYSTEM);
        this.fs = this.ioService.newFileSystem(uri, new HashMap(), (FileSystemType)Migration.MIGRATION_INSTANCE);
    }

    @Produces
    @Named(value="ioStrategy")
    public IOService ioService() {
        return this.ioService;
    }

    @Produces
    @Named(value="migrationFS")
    public FileSystem migrationFS() {
        return this.fs;
    }

    @Produces
    @Named(value="system")
    public Repository systemRepository() {
        return SystemRepository.SYSTEM_REPO;
    }

    public static enum Migration implements FileSystemType
    {
        MIGRATION_INSTANCE;


        public String toString() {
            return "MIGRATION";
        }
    }
}

