/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodeller.codegen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kie.api.definition.type.Key;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.AnnotationDefinition;
import org.kie.workbench.common.services.datamodeller.core.AnnotationMemberDefinition;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.kie.workbench.common.services.datamodeller.driver.impl.annotations.KeyAnnotationDefinition;
import org.kie.workbench.common.services.datamodeller.driver.impl.annotations.PositionAnnotationDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerationTools {
    private static final Logger logger = LoggerFactory.getLogger(GenerationTools.class);
    private static final String TAB = "    ";
    private static final String EOL = System.getProperty("line.separator");

    public String fitToSize(int size, String name, char padChar) {
        int n = size - name.length();
        StringBuffer buf = new StringBuffer();
        buf.append(name);
        for (int i = 0; i < n; ++i) {
            buf.append(padChar);
        }
        return buf.toString();
    }

    public String toJavaGetter(String name) {
        return "get" + StringUtils.capitalize((String)name);
    }

    public String toJavaSetter(String name) {
        return "set" + StringUtils.capitalize((String)name);
    }

    private String toJavaName(String name, boolean firstLetterIsUpperCase) {
        name = name.toLowerCase();
        StringBuffer res = new StringBuffer();
        boolean nextIsUpperCase = firstLetterIsUpperCase;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (nextIsUpperCase) {
                c = Character.toUpperCase(c);
            }
            if (Character.isLetter(c)) {
                res.append(c);
                nextIsUpperCase = false;
                continue;
            }
            nextIsUpperCase = true;
        }
        return res.toString();
    }

    public String toJavaVar(String name) {
        return name;
    }

    public String getFilePath(String packageName, String simpleClassName, String extension) {
        packageName = packageName != null ? "/" + packageName.replace(".", "/") : "";
        return packageName + "/" + this.toFileName(simpleClassName) + "." + extension;
    }

    public String toFileName(String name) {
        return name.replaceAll("\\s", "");
    }

    public String resolveAttributeType(ObjectProperty attribute) {
        StringBuffer type = new StringBuffer("");
        if (attribute.isMultiple()) {
            if (attribute.getBag() != null && !"".equals(attribute.getBag())) {
                type.append(attribute.getBag());
            } else {
                type.append("java.util.List");
            }
            type.append("<");
        }
        type.append(attribute.getClassName());
        if (attribute.isMultiple()) {
            type.append(">");
        }
        return type.toString();
    }

    public String resolveAnnotationType(Annotation annotation) {
        StringBuffer type = new StringBuffer();
        AnnotationDefinition annotationDefinition = annotation.getAnnotationDefinition();
        if (annotationDefinition == null) {
            logger.warn("Annotation definition for annotation: " + annotation + " is not defined.");
            return type.toString();
        }
        if (annotationDefinition.isMarker()) {
            return type.toString();
        }
        int memberCount = 0;
        for (AnnotationMemberDefinition memberDefinition : annotationDefinition.getAnnotationMembers()) {
            Object memberValue = annotation.getValue(memberDefinition.getName());
            if (memberValue == null) continue;
            if (memberCount == 0) {
                type.append("(");
            }
            if (memberCount > 0) {
                type.append(", ");
            }
            type.append(this.resolveMemberType(memberDefinition, memberValue));
            ++memberCount;
        }
        if (memberCount > 0) {
            type.append(")");
        }
        return type.toString();
    }

    public String resolveMemberType(AnnotationMemberDefinition memberDefinition, Object value) {
        StringBuffer type = new StringBuffer();
        type.append(memberDefinition.getName());
        type.append(" = ");
        if (memberDefinition.isEnum()) {
            type.append(memberDefinition.getClassName());
            type.append(".");
            type.append(value);
        } else if (memberDefinition.isString()) {
            type.append("\"");
            type.append(value);
            type.append("\"");
        } else if (memberDefinition.isPrimitiveType()) {
            if (Character.class.getName().equals(memberDefinition.getClassName())) {
                type.append("'");
                type.append(value.toString());
                type.append("'");
            } else if (Long.class.getName().equals(memberDefinition.getClassName())) {
                type.append(value.toString());
                type.append("L");
            } else if (Float.class.getName().equals(memberDefinition.getClassName())) {
                type.append(value.toString());
                type.append("f");
            } else if (Double.class.getName().equals(memberDefinition.getClassName())) {
                type.append(value.toString());
                type.append("d");
            } else {
                type.append(value.toString());
            }
        }
        return type.toString();
    }

    public String resolveSuperClassType(DataObject dataObject) {
        StringBuffer type = new StringBuffer("");
        if (dataObject.getSuperClassName() != null && !"".equals(dataObject.getSuperClassName())) {
            type.append("extends ");
            type.append(dataObject.getSuperClassName());
        }
        return type.toString();
    }

    public String resolveImplementedInterfacesType(DataObject dataObject) {
        StringBuffer type = new StringBuffer("");
        type.append("implements java.io.Serializable");
        return type.toString();
    }

    public String resolveEquals(DataObject dataObject, String indent) {
        StringBuilder head = new StringBuilder();
        head.append(indent + "@Override" + EOL);
        head.append(indent + "public boolean equals(Object o) {" + EOL);
        head.append(indent + TAB + "if (this == o) return true;" + EOL);
        head.append(indent + TAB + "if (o == null || getClass() != o.getClass()) return false;" + EOL);
        head.append(indent + TAB + dataObject.getClassName() + " that = (" + dataObject.getClassName() + ")o;" + EOL);
        StringBuilder end = new StringBuilder();
        end.append(indent + "}");
        StringBuilder sb = new StringBuilder();
        Map<String, ObjectProperty> props = dataObject.getProperties();
        boolean hasTerms = false;
        if (props != null && props.size() > 0) {
            for (String propName : props.keySet()) {
                ObjectProperty prop = props.get(propName);
                String _propName = this.toJavaVar(propName);
                if (prop.getAnnotation(Key.class.getName()) == null) continue;
                sb.append(indent + TAB + "if (");
                sb.append(_propName).append(" != null ? !").append(_propName).append(".equals(that.").append(_propName).append(")");
                sb.append(" : that.").append(_propName).append(" != null").append(") return false;");
                sb.append(EOL);
                hasTerms = true;
            }
        }
        if (hasTerms) {
            sb.append(indent + TAB + "return true;" + EOL);
            head.append((CharSequence)sb);
            head.append((CharSequence)end);
            return head.toString();
        }
        return "";
    }

    public String resolveHashCode(DataObject dataObject, String indent) {
        StringBuilder head = new StringBuilder();
        head.append(indent + "@Override" + EOL);
        head.append(indent + "public int hashCode() {" + EOL);
        head.append(indent + TAB + "int result = 17;" + EOL);
        StringBuilder end = new StringBuilder();
        end.append(indent + "}");
        StringBuilder sb = new StringBuilder();
        Map<String, ObjectProperty> props = dataObject.getProperties();
        boolean hasTerms = false;
        if (props != null && props.size() > 0) {
            for (String propName : props.keySet()) {
                ObjectProperty prop = props.get(propName);
                String _propName = this.toJavaVar(propName);
                if (prop.getAnnotation(Key.class.getName()) == null) continue;
                sb.append(indent + TAB + "result = 13 * result + (").append(_propName).append(" != null ? ").append(_propName).append(".hashCode() : 0);");
                sb.append(EOL);
                hasTerms = true;
            }
        }
        if (hasTerms) {
            sb.append(indent + TAB + "return result;" + EOL);
            head.append((CharSequence)sb);
            head.append((CharSequence)end);
            return head.toString();
        }
        return "";
    }

    public String resolveAllFieldsConstructor(DataObject dataObject, String indent) {
        if (!dataObject.getProperties().isEmpty()) {
            ArrayList<ObjectProperty> sortedProperties = new ArrayList<ObjectProperty>();
            sortedProperties.addAll(dataObject.getProperties().values());
            return this.resolveConstructor(dataObject, this.sortByPosition(sortedProperties), indent);
        }
        return "";
    }

    public String resolveKeyFieldsConstructor(DataObject dataObject, String indent) {
        if (!dataObject.getProperties().isEmpty()) {
            ArrayList<ObjectProperty> sortedProperties = new ArrayList<ObjectProperty>();
            for (ObjectProperty property : dataObject.getProperties().values()) {
                if (property.getAnnotation(KeyAnnotationDefinition.getInstance().getClassName()) == null) continue;
                sortedProperties.add(property);
            }
            if (sortedProperties.size() > 0 && sortedProperties.size() < dataObject.getProperties().size()) {
                return this.resolveConstructor(dataObject, this.sortByPosition(sortedProperties), indent);
            }
        }
        return "";
    }

    private List<ObjectProperty> sortByPosition(List<ObjectProperty> properties) {
        Collections.sort(properties, new Comparator<ObjectProperty>(){

            @Override
            public int compare(ObjectProperty o1, ObjectProperty o2) {
                Annotation position2;
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null && o2 != null) {
                    return -1;
                }
                if (o1 != null && o2 == null) {
                    return 1;
                }
                Integer key1 = null;
                Integer key2 = null;
                Annotation position1 = o1.getAnnotation(PositionAnnotationDefinition.getInstance().getClassName());
                if (position1 != null) {
                    try {
                        key1 = new Integer((String)position1.getValue("value"));
                    }
                    catch (NumberFormatException e) {
                        key1 = null;
                    }
                }
                if ((position2 = o2.getAnnotation(PositionAnnotationDefinition.getInstance().getClassName())) != null) {
                    try {
                        key2 = new Integer((String)position2.getValue("value"));
                    }
                    catch (NumberFormatException e) {
                        key2 = null;
                    }
                }
                if (key1 == null && key2 == null) {
                    return 0;
                }
                if (key1 != null && key2 != null) {
                    return key1.compareTo(key2);
                }
                if (key1 == null && key2 != null) {
                    return -1;
                }
                return 1;
            }
        });
        return properties;
    }

    public String resolveConstructor(DataObject dataObject, List<ObjectProperty> properties, String indent) {
        StringBuilder head = new StringBuilder();
        StringBuilder body = new StringBuilder();
        head.append(indent + "public " + dataObject.getName() + "(");
        if (properties != null && properties.size() > 0) {
            boolean isFirst = true;
            for (ObjectProperty property : properties) {
                if (!isFirst) {
                    head.append(", ");
                    body.append(EOL);
                }
                String propertyName = this.toJavaVar(property.getName());
                head.append(this.resolveAttributeType(property));
                head.append(" ");
                head.append(propertyName);
                body.append(indent);
                body.append(indent);
                body.append("this.");
                body.append(propertyName);
                body.append(" = ");
                body.append(propertyName);
                body.append(";");
                isFirst = false;
            }
            body.append(EOL);
        }
        head.append(") {" + EOL);
        head.append((CharSequence)body);
        head.append(indent + "}");
        return head.toString();
    }
}

