/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server.converters;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.drools.core.util.AbstractXStreamConverter;
import org.guvnor.common.services.project.model.ClockTypeOption;
import org.guvnor.common.services.project.model.KSessionModel;
import org.guvnor.common.services.project.model.ListenerModel;
import org.guvnor.common.services.project.model.WorkItemHandlerModel;

public class KSessionConverter
extends AbstractXStreamConverter {
    public KSessionConverter() {
        super(KSessionModel.class);
    }

    public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
        KSessionModel kSession = (KSessionModel)value;
        writer.addAttribute("name", kSession.getName());
        writer.addAttribute("type", kSession.getType());
        writer.addAttribute("default", Boolean.toString(kSession.isDefault()));
        if (kSession.getClockType() != null) {
            writer.addAttribute("clockType", kSession.getClockType().getClockTypeAsString());
        }
        if (kSession.getScope() != null) {
            writer.addAttribute("scope", kSession.getScope().toString());
        }
        this.writeObjectList(writer, context, "workItemHandlers", "workItemHandler", kSession.getWorkItemHandelerModels());
        if (!kSession.getListeners().isEmpty()) {
            writer.startNode("listeners");
            for (ListenerModel listener : kSession.getListeners()) {
                this.writeObject(writer, context, listener.getKind().toString(), listener);
            }
            writer.endNode();
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, final UnmarshallingContext context) {
        String scope;
        final KSessionModel kSession = new KSessionModel();
        kSession.setName(reader.getAttribute("name"));
        kSession.setDefault("true".equals(reader.getAttribute("default")));
        String kSessionType = reader.getAttribute("type");
        kSession.setType(kSessionType != null ? kSessionType : "stateful");
        String clockType = reader.getAttribute("clockType");
        if (clockType != null) {
            kSession.setClockType(ClockTypeOption.get((String)clockType));
        }
        if ((scope = reader.getAttribute("scope")) != null) {
            kSession.setScope(scope);
        }
        this.readNodes(reader, new AbstractXStreamConverter.NodeReader(){

            public void onNode(HierarchicalStreamReader reader, String name, String value) {
                if ("listeners".equals(name)) {
                    while (reader.hasMoreChildren()) {
                        reader.moveDown();
                        kSession.getListeners().add(KSessionConverter.this.readObject(reader, context, ListenerModel.class));
                        reader.moveUp();
                    }
                } else if ("workItemHandlers".equals(name)) {
                    kSession.getWorkItemHandelerModels().addAll(KSessionConverter.this.readObjectList(reader, context, WorkItemHandlerModel.class));
                }
            }
        });
        return kSession;
    }
}

