/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer.navigation.modules;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.IsTreeItem;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.explorer.navigation.modules.ChangeModuleHierarchyEvent;
import org.drools.guvnor.client.explorer.navigation.modules.ChangeModuleHierarchyEventHandler;
import org.drools.guvnor.client.explorer.navigation.modules.CollapseAllEvent;
import org.drools.guvnor.client.explorer.navigation.modules.CollapseAllEventHandler;
import org.drools.guvnor.client.explorer.navigation.modules.ExpandAllEvent;
import org.drools.guvnor.client.explorer.navigation.modules.ExpandAllEventHandler;
import org.drools.guvnor.client.explorer.navigation.modules.ModulesTreeItemBase;
import org.drools.guvnor.client.explorer.navigation.modules.ModulesTreeItemView;
import org.drools.guvnor.client.moduleeditor.RefreshModuleListEvent;
import org.drools.guvnor.client.moduleeditor.RefreshModuleListEventHandler;
import org.drools.guvnor.client.rpc.Module;

public class ModulesTreeItem
extends ModulesTreeItemBase {
    private final EventBus eventBus;

    public ModulesTreeItem(ClientFactory clientFactory, EventBus eventBus, String perspectiveTypes) {
        super(clientFactory, clientFactory.getNavigationViewFactory().getModulesTreeItemView(), perspectiveTypes);
        this.eventBus = eventBus;
        this.setRefreshHandler();
        this.setModuleHierarchyChangeHandler();
        this.setCollapseAllChangeHandler();
        this.setExpandAllChangeHandler();
    }

    private void setRefreshHandler() {
        this.eventBus.addHandler(RefreshModuleListEvent.TYPE, (EventHandler)new RefreshModuleListEventHandler(){

            @Override
            public void onRefreshList(RefreshModuleListEvent refreshModuleListEvent) {
                ModulesTreeItem.this.getView().clearModulesTreeItem();
                ModulesTreeItem.this.packageHierarchy.clear();
                ModulesTreeItem.this.setUpRootItem();
            }
        });
    }

    private void setModuleHierarchyChangeHandler() {
        this.eventBus.addHandler(ChangeModuleHierarchyEvent.TYPE, (EventHandler)new ChangeModuleHierarchyEventHandler(){

            @Override
            public void onChangeModuleHierarchy(ChangeModuleHierarchyEvent event) {
                ModulesTreeItem.this.getView().clearModulesTreeItem();
                ModulesTreeItem.this.packageHierarchy = event.getPackageHierarchy();
                ModulesTreeItem.this.setUpRootItem();
            }
        });
    }

    private void setCollapseAllChangeHandler() {
        this.eventBus.addHandler(CollapseAllEvent.TYPE, (EventHandler)new CollapseAllEventHandler(){

            @Override
            public void onCollapseAll(CollapseAllEvent event) {
                ModulesTreeItem.this.getView().collapseAll();
            }
        });
    }

    private void setExpandAllChangeHandler() {
        this.eventBus.addHandler(ExpandAllEvent.TYPE, (EventHandler)new ExpandAllEventHandler(){

            @Override
            public void onExpandAll(ExpandAllEvent event) {
                ModulesTreeItem.this.getView().expandAll();
            }
        });
    }

    @Override
    protected void fillModulesTree(final IsTreeItem treeItem) {
        this.clientFactory.getModuleService().listModules((AsyncCallback<Module[]>)new GenericCallback<Module[]>(){

            public void onSuccess(Module[] packageConfigDatas) {
                ModulesTreeItem.this.addModules(packageConfigDatas, treeItem);
            }
        });
    }

    private ModulesTreeItemView getView() {
        return (ModulesTreeItemView)this.view;
    }
}

