/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server;

import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletResponse;
import org.drools.guvnor.client.rpc.DetailedSerializationException;
import org.drools.guvnor.client.rpc.InboxPageRequest;
import org.drools.guvnor.client.rpc.LogEntry;
import org.drools.guvnor.client.rpc.MetaDataQuery;
import org.drools.guvnor.client.rpc.Module;
import org.drools.guvnor.client.rpc.ModuleService;
import org.drools.guvnor.client.rpc.NewAssetConfiguration;
import org.drools.guvnor.client.rpc.NewAssetWithContentConfiguration;
import org.drools.guvnor.client.rpc.PageRequest;
import org.drools.guvnor.client.rpc.PageResponse;
import org.drools.guvnor.client.rpc.QueryMetadataPageRequest;
import org.drools.guvnor.client.rpc.QueryPageRequest;
import org.drools.guvnor.client.rpc.RepositoryService;
import org.drools.guvnor.client.rpc.StatePageRequest;
import org.drools.guvnor.client.rpc.TableConfig;
import org.drools.guvnor.client.rpc.TableDataResult;
import org.drools.guvnor.server.ServiceImplementation;
import org.drools.guvnor.server.util.LoggingHelper;
import org.drools.repository.RulesRepositoryException;
import org.jboss.seam.security.AuthorizationException;
import org.jboss.seam.security.NotLoggedInException;
import org.jboss.solder.core.Veto;

@Veto
public class RepositoryServiceServlet
extends RemoteServiceServlet
implements RepositoryService {
    private static final long serialVersionUID = 495822L;
    private static final LoggingHelper log = LoggingHelper.getLogger(RepositoryServiceServlet.class);
    @Inject
    private ServiceImplementation serviceImplementation;
    @Inject
    private ModuleService moduleService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doUnexpectedFailure(Throwable e) {
        if (e.getCause() instanceof AuthorizationException) {
            HttpServletResponse response = this.getThreadLocalResponse();
            PrintWriter writer = null;
            try {
                writer = response.getWriter();
                log.error(e.getMessage(), e.getCause());
                e.printStackTrace();
                response.setContentType("text/plain");
                response.setStatus(401);
                writer.write("Sorry, insufficient permissions to perform this action.");
            }
            catch (IOException ex) {
                this.getServletContext().log("respondWithUnexpectedFailure failed while sending the previous failure to the client", (Throwable)ex);
            }
            finally {
                this.close(writer);
            }
        } else if (e.getCause() instanceof RulesRepositoryException) {
            log.error(e.getMessage(), e.getCause());
            this.sendErrorMessage(e.getCause().getMessage());
        } else if (e.getCause() instanceof NotLoggedInException) {
            log.error(e.getMessage(), e.getCause());
            this.sendErrorMessage("You are not logged in. Please refresh your browser and try again.");
        } else {
            if (e.getCause() != null) {
                log.error(e.getMessage(), e.getCause());
            } else {
                log.error(e.getMessage(), e);
            }
            this.sendErrorMessage("Sorry, a technical error occurred. Please contact a system administrator.");
        }
    }

    private void close(PrintWriter writer) {
        if (writer != null) {
            writer.flush();
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendErrorMessage(String msg) {
        HttpServletResponse response = this.getThreadLocalResponse();
        response.setContentType("text/plain");
        response.setStatus(400);
        PrintWriter writer = null;
        try {
            writer = response.getWriter();
            writer.write(msg);
        }
        catch (IOException ex) {
            this.getServletContext().log("respondWithUnexpectedFailure failed while sending the previous failure to the client", (Throwable)ex);
        }
        finally {
            this.close(writer);
        }
    }

    public PageResponse loadRuleListForState(StatePageRequest p0) throws SerializationException {
        return this.serviceImplementation.loadRuleListForState(p0);
    }

    @Override
    public TableDataResult loadRuleListForState(String p0, int p1, int p2, String p3) throws SerializationException {
        return this.serviceImplementation.loadRuleListForState(p0, p1, p2, p3);
    }

    @Override
    public TableConfig loadTableConfig(String p0) {
        return this.serviceImplementation.loadTableConfig(p0);
    }

    @Override
    public String createNewRule(String p0, String p1, String p2, String p3, String p4) throws SerializationException {
        return this.serviceImplementation.createNewRule(p0, p1, p2, p3, p4);
    }

    @Override
    public String createNewRule(NewAssetConfiguration p0) throws SerializationException {
        return this.serviceImplementation.createNewRule(p0);
    }

    public String createNewRule(NewAssetWithContentConfiguration p0) throws SerializationException {
        return this.serviceImplementation.createNewRule(p0);
    }

    @Override
    public String createNewImportedRule(String p0, String p1) throws SerializationException {
        return this.serviceImplementation.createNewImportedRule(p0, p1);
    }

    @Override
    public void deleteUncheckedRule(String p0) {
        this.serviceImplementation.deleteUncheckedRule(p0);
    }

    @Override
    public void clearRulesRepository() {
        this.serviceImplementation.clearRulesRepository();
    }

    @Override
    public String[] listWorkspaces() {
        return this.serviceImplementation.listWorkspaces();
    }

    @Override
    public void createWorkspace(String p0) {
        this.serviceImplementation.createWorkspace(p0);
    }

    @Override
    public void removeWorkspace(String p0) {
        this.serviceImplementation.removeWorkspace(p0);
    }

    @Override
    public void updateWorkspace(String p0, String[] p1, String[] p2) {
        this.serviceImplementation.updateWorkspace(p0, p1, p2);
    }

    @Override
    public String[] listStates() throws SerializationException {
        return this.serviceImplementation.listStates();
    }

    @Override
    public String createState(String p0) throws SerializationException {
        return this.serviceImplementation.createState(p0);
    }

    @Override
    public void renameState(String p0, String p1) throws SerializationException {
        this.serviceImplementation.renameState(p0, p1);
    }

    @Override
    public void removeState(String p0) throws SerializationException {
        this.serviceImplementation.removeState(p0);
    }

    @Override
    public String[] getCustomSelectors() throws SerializationException {
        return this.serviceImplementation.getCustomSelectors();
    }

    public PageResponse showLog(PageRequest p0) {
        return this.serviceImplementation.showLog(p0);
    }

    @Override
    public LogEntry[] showLog() {
        return this.serviceImplementation.showLog();
    }

    @Override
    public void cleanLog() {
        this.serviceImplementation.cleanLog();
    }

    @Override
    public String[] loadDropDownExpression(String[] p0, String p1) {
        return this.serviceImplementation.loadDropDownExpression(p0, p1);
    }

    public PageResponse queryFullText(QueryPageRequest p0) throws SerializationException {
        return this.serviceImplementation.queryFullText(p0);
    }

    public PageResponse queryMetaData(QueryMetadataPageRequest p0) throws SerializationException {
        return this.serviceImplementation.queryMetaData(p0);
    }

    @Override
    public TableDataResult queryMetaData(MetaDataQuery[] p0, Date p1, Date p2, Date p3, Date p4, boolean p5, int p6, int p7) throws SerializationException {
        return this.serviceImplementation.queryMetaData(p0, p1, p2, p3, p4, p5, p6, p7);
    }

    public PageResponse listUserPermissions(PageRequest p0) throws DetailedSerializationException {
        return this.serviceImplementation.listUserPermissions(p0);
    }

    public Map listUserPermissions() throws DetailedSerializationException {
        return this.serviceImplementation.listUserPermissions();
    }

    public Map retrieveUserPermissions(String p0) {
        return this.serviceImplementation.retrieveUserPermissions(p0);
    }

    public void updateUserPermissions(String p0, Map p1) {
        this.serviceImplementation.updateUserPermissions(p0, p1);
    }

    @Override
    public String[] listAvailablePermissionTypes() {
        return this.serviceImplementation.listAvailablePermissionTypes();
    }

    @Override
    public List<String> listAvailablePermissionRoleTypes() {
        return this.serviceImplementation.listAvailablePermissionRoleTypes();
    }

    @Override
    public boolean isDoNotInstallSample() {
        Module[] modules = this.moduleService.listModules();
        return modules.length != 1 || this.serviceImplementation.isDoNotInstallSample();
    }

    @Override
    public void setDoNotInstallSample() {
        this.serviceImplementation.setDoNotInstallSample();
    }

    @Override
    public void deleteUser(String p0) {
        this.serviceImplementation.deleteUser(p0);
    }

    @Override
    public void createUser(String p0) {
        this.serviceImplementation.createUser(p0);
    }

    public List subscribe() {
        return this.serviceImplementation.subscribe();
    }

    @Override
    public TableDataResult loadInbox(String p0) throws DetailedSerializationException {
        return this.serviceImplementation.loadInbox(p0);
    }

    public PageResponse loadInbox(InboxPageRequest p0) throws DetailedSerializationException {
        return this.serviceImplementation.loadInbox(p0);
    }

    public String processTemplate(String p0, Map p1) {
        return this.serviceImplementation.processTemplate(p0, p1);
    }

    public Map loadSpringContextElementData() throws DetailedSerializationException {
        return this.serviceImplementation.loadSpringContextElementData();
    }

    @Override
    public boolean doesAssetExistInModule(String p0, String p1) throws SerializationException {
        return this.serviceImplementation.doesAssetExistInModule(p0, p1);
    }
}

