/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.util;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.drools.guvnor.server.util.AssetEditorConfigurationParser;
import org.drools.guvnor.server.util.ModuleEditorConfiguration;
import org.drools.guvnor.server.util.PerspectiveConfigurationElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerspectiveConfigurationParser {
    private static final Logger log = LoggerFactory.getLogger(AssetEditorConfigurationParser.class);
    private static final String PERSPECTIVE_CONFIG = "/perspective.xml";
    static final String MODULE_EDITOR = "moduleeditor";
    static final String MODULE_EDITORS = "moduleeditors";
    static final String TITLE = "title";
    static final String CLASS = "class";
    static final String ICON = "icon";
    static final String FORMAT = "format";
    private final InputStream in;
    private List<ModuleEditorConfiguration> moduleEditors;

    public PerspectiveConfigurationParser() {
        this.in = this.getClass().getResourceAsStream(PERSPECTIVE_CONFIG);
    }

    public PerspectiveConfigurationParser(InputStream in) {
        this.in = in;
    }

    public List<ModuleEditorConfiguration> getModuleEditors() {
        if (this.moduleEditors == null) {
            this.moduleEditors = this.readConfig(this.in);
        }
        return this.moduleEditors;
    }

    private List<ModuleEditorConfiguration> readConfig(InputStream in) {
        ArrayList<ModuleEditorConfiguration> moduleEditors = new ArrayList<ModuleEditorConfiguration>();
        try {
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            XMLEventReader eventReader = inputFactory.createXMLEventReader(in);
            ModuleEditorConfiguration configuration = null;
            while (eventReader.hasNext()) {
                PerspectiveConfigurationElement element;
                XMLEvent event = eventReader.nextEvent();
                if (event.isStartElement()) {
                    element = PerspectiveConfigurationElement.forName(event.asStartElement().getName().getLocalPart());
                    switch (element) {
                        case MODULE_EDITOR: {
                            configuration = new ModuleEditorConfiguration();
                            break;
                        }
                        case FORMAT: {
                            event = eventReader.nextEvent();
                            if (event.isCharacters()) {
                                configuration.setFormat(event.asCharacters().getData());
                                break;
                            }
                            if (!event.isEndElement()) break;
                            configuration.setFormat("");
                            break;
                        }
                        case CLASS: {
                            event = eventReader.nextEvent();
                            if (event.isCharacters()) {
                                configuration.setEditorClass(event.asCharacters().getData());
                                break;
                            }
                            if (!event.isEndElement()) break;
                            configuration.setEditorClass("");
                            break;
                        }
                        case ASSETEDITORFORMATS: {
                            event = eventReader.nextEvent();
                            if (event.isCharacters()) {
                                configuration.setAssetEditorFormats(event.asCharacters().getData());
                                break;
                            }
                            if (!event.isEndElement()) break;
                            configuration.setAssetEditorFormats("");
                        }
                    }
                }
                if (!event.isEndElement() || (element = PerspectiveConfigurationElement.forName(event.asEndElement().getName().getLocalPart())) != PerspectiveConfigurationElement.MODULE_EDITOR) continue;
                moduleEditors.add(configuration);
            }
        }
        catch (XMLStreamException e) {
            log.error("Failed to parse Asset editor configuration file", (Throwable)e);
            e.printStackTrace();
        }
        return moduleEditors;
    }

    public static void main(String[] agrs) {
        PerspectiveConfigurationParser a = new PerspectiveConfigurationParser();
    }
}

