/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.wagon;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;

public class UrlUtils {
    private static final Map<String, String> protocolMap = new HashMap<String, String>();

    public static String getProtocol(String url) {
        int idx = url.indexOf(":/");
        if (idx < 0) {
            return "";
        }
        return url.substring(0, idx);
    }

    public static String normalizeProtocol(String protocol) {
        if (protocolMap.containsKey(protocol)) {
            return protocolMap.get(protocol);
        }
        return protocol;
    }

    public static String buildUrl(String repositoryUrl, String resourceUrl) throws URISyntaxException {
        String path;
        String authority;
        int idx = repositoryUrl.indexOf("://");
        if (idx < 0) {
            return repositoryUrl + resourceUrl;
        }
        String protocol = repositoryUrl.substring(0, idx);
        protocol = UrlUtils.normalizeProtocol(protocol);
        int authorityIdx = idx + 3;
        if ((idx = repositoryUrl.indexOf(47, authorityIdx)) < 0) {
            authority = repositoryUrl.substring(authorityIdx);
            path = "/";
        } else {
            authority = repositoryUrl.substring(authorityIdx, idx);
            path = repositoryUrl.substring(idx);
        }
        if (!path.endsWith("/")) {
            path = path + '/';
        }
        path = resourceUrl.startsWith("/") ? path + resourceUrl.substring(1) : path + resourceUrl;
        return new URI(protocol, authority, path, null, null).toASCIIString();
    }

    static {
        protocolMap.put("http", "http");
        protocolMap.put("https", "https");
        protocolMap.put("dav", "http");
        protocolMap.put("davs", "https");
        protocolMap.put("dav:http", "http");
        protocolMap.put("dav:https", "https");
        protocolMap.put("dav+http", "http");
        protocolMap.put("dav+https", "https");
    }
}

