/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import org.drools.FactException;
import org.drools.FactHandle;
import org.drools.WorkingMemory;
import org.drools.common.AbstractRuleBase;
import org.drools.common.AgendaItem;
import org.drools.common.DefaultAgenda;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalRuleFlowGroup;
import org.drools.common.InternalWorkingMemoryActions;
import org.drools.common.InternalWorkingMemoryEntryPoint;
import org.drools.common.LogicalDependency;
import org.drools.common.ObjectTypeConfigurationRegistry;
import org.drools.common.SimpleLogicalDependency;
import org.drools.common.TraitFactHandle;
import org.drools.core.util.LinkedList;
import org.drools.core.util.LinkedListEntry;
import org.drools.factmodel.traits.CoreWrapper;
import org.drools.factmodel.traits.LogicalTypeInconsistencyException;
import org.drools.factmodel.traits.Thing;
import org.drools.factmodel.traits.TraitFactory;
import org.drools.factmodel.traits.TraitProxy;
import org.drools.factmodel.traits.TraitType;
import org.drools.factmodel.traits.TraitableBean;
import org.drools.impl.KnowledgeBaseImpl;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.ObjectTypeConf;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.rule.Declaration;
import org.drools.rule.Rule;
import org.drools.runtime.Channel;
import org.drools.runtime.ExitPoint;
import org.drools.runtime.KnowledgeRuntime;
import org.drools.runtime.process.NodeInstance;
import org.drools.runtime.process.NodeInstanceContainer;
import org.drools.runtime.process.ProcessInstance;
import org.drools.runtime.process.WorkflowProcessInstance;
import org.drools.runtime.rule.Activation;
import org.drools.runtime.rule.WorkingMemoryEntryPoint;
import org.drools.spi.KnowledgeHelper;
import org.drools.spi.ProcessContext;
import org.drools.spi.PropagationContext;
import org.drools.spi.Tuple;
import org.drools.util.HierarchyEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultKnowledgeHelper
implements KnowledgeHelper,
Externalizable {
    private static final long serialVersionUID = 510L;
    private org.drools.spi.Activation activation;
    private Tuple tuple;
    private InternalWorkingMemoryActions workingMemory;
    private IdentityHashMap<Object, FactHandle> identityMap;
    private LinkedList<LogicalDependency> previousJustified;
    private LinkedList<LogicalDependency> previousBlocked;

    public DefaultKnowledgeHelper() {
    }

    public DefaultKnowledgeHelper(WorkingMemory workingMemory) {
        this.workingMemory = (InternalWorkingMemoryActions)workingMemory;
        this.identityMap = null;
    }

    public DefaultKnowledgeHelper(org.drools.spi.Activation activation, WorkingMemory workingMemory) {
        this.workingMemory = (InternalWorkingMemoryActions)workingMemory;
        this.activation = activation;
        this.identityMap = null;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.activation = (org.drools.spi.Activation)in.readObject();
        this.tuple = (Tuple)in.readObject();
        this.workingMemory = (InternalWorkingMemoryActions)in.readObject();
        this.identityMap = (IdentityHashMap)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.activation);
        out.writeObject(this.tuple);
        out.writeObject(this.workingMemory);
        out.writeObject(this.identityMap);
    }

    @Override
    public void setActivation(org.drools.spi.Activation agendaItem) {
        this.activation = agendaItem;
        this.previousJustified = agendaItem.getLogicalDependencies();
        this.previousBlocked = agendaItem.getBlocked();
        agendaItem.setLogicalDependencies(null);
        agendaItem.setBlocked(null);
        this.tuple = agendaItem.getTuple();
    }

    @Override
    public void reset() {
        this.activation = null;
        this.tuple = null;
        this.identityMap = null;
        this.previousJustified = null;
        this.previousBlocked = null;
    }

    @Override
    public void blockActivation(Activation act) {
        AgendaItem targetMatch = (AgendaItem)act;
        LogicalDependency dep = null;
        if (this.previousJustified != null) {
            for (dep = this.previousJustified.getFirst(); dep != null; dep = (LogicalDependency)dep.getNext()) {
                if (targetMatch != dep.getJustified()) continue;
                this.previousJustified.remove(dep);
                break;
            }
        }
        if (dep == null) {
            dep = new SimpleLogicalDependency(this.activation, targetMatch);
        }
        this.activation.addBlocked(dep);
        if (targetMatch.getBlockers().size() == 1 && targetMatch.isActive()) {
            targetMatch.remove();
            if (targetMatch.getActivationGroupNode() != null) {
                targetMatch.getActivationGroupNode().getActivationGroup().removeActivation(targetMatch);
            }
            if (targetMatch.getActivationNode() != null) {
                InternalRuleFlowGroup ruleFlowGroup = (InternalRuleFlowGroup)targetMatch.getActivationNode().getParentContainer();
                ruleFlowGroup.removeActivation(targetMatch);
            }
        }
    }

    @Override
    public void unblockAllActivations(Activation act) {
        AgendaItem targetMatch = (AgendaItem)act;
        boolean wasBlocked = targetMatch.getBlockers() != null && !targetMatch.getBlockers().isEmpty();
        LinkedListEntry entry = targetMatch.getBlockers().getFirst();
        while (entry != null) {
            LinkedListEntry tmp = (LinkedListEntry)entry.getNext();
            LogicalDependency dep = entry.getObject();
            ((AgendaItem)dep.getJustifier()).removeBlocked(dep);
            entry = tmp;
        }
        if (wasBlocked) {
            ((DefaultAgenda)this.workingMemory.getAgenda()).getStageActivationsGroup().addActivation(targetMatch);
        }
    }

    @Override
    public void insert(Object object) {
        this.insert(object, false);
    }

    @Override
    public void insert(Object object, boolean dynamic) throws FactException {
        FactHandle handle = this.workingMemory.insert(object, null, dynamic, false, this.activation.getRule(), this.activation);
        if (this.identityMap != null) {
            this.getIdentityMap().put(object, handle);
        }
    }

    @Override
    public void insertLogical(Object object) {
        this.insertLogical(object, false);
    }

    @Override
    public void insertLogical(Object object, boolean dynamic) {
        this.insertLogical(object, null, dynamic);
    }

    @Override
    public void insertLogical(Object object, Object value) {
        this.insertLogical(object, value, false);
    }

    public void insertLogical(Object object, Object value, boolean dynamic) {
        if (!this.activation.isMatched()) {
            return;
        }
        LogicalDependency dep = null;
        if (this.previousJustified != null) {
            for (dep = this.previousJustified.getFirst(); dep != null; dep = (LogicalDependency)dep.getNext()) {
                if (!object.equals(((InternalFactHandle)dep.getJustified()).getObject())) continue;
                this.previousJustified.remove(dep);
                break;
            }
        }
        if (dep != null) {
            this.activation.addLogicalDependency(dep);
        } else {
            FactHandle handle = this.workingMemory.insert(object, value, dynamic, true, this.activation.getRule(), this.activation);
            if (this.identityMap != null) {
                this.getIdentityMap().put(object, handle);
            }
        }
    }

    @Override
    public void cancelRemainingPreviousLogicalDependencies() {
        LogicalDependency dep;
        if (this.previousJustified != null) {
            for (dep = this.previousJustified.getFirst(); dep != null; dep = (LogicalDependency)dep.getNext()) {
                this.workingMemory.getTruthMaintenanceSystem().removeLogicalDependency(this.activation, dep, this.activation.getPropagationContext());
            }
        }
        if (this.previousBlocked != null) {
            dep = this.previousBlocked.getFirst();
            while (dep != null) {
                LogicalDependency tmp = (LogicalDependency)dep.getNext();
                this.previousBlocked.remove(dep);
                AgendaItem justified = (AgendaItem)dep.getJustified();
                justified.getBlockers().remove(dep.getJustifierEntry());
                if (justified.getBlockers().isEmpty()) {
                    ((DefaultAgenda)this.workingMemory.getAgenda()).getStageActivationsGroup().addActivation(justified);
                }
                dep = tmp;
            }
        }
    }

    @Override
    public void cancelActivation(Activation act) {
        AgendaItem match = (AgendaItem)act;
        match.cancel();
        if (match.isActive()) {
            LeftTuple leftTuple = match.getTuple();
            leftTuple.getLeftTupleSink().retractLeftTuple(leftTuple, (PropagationContext)act.getPropagationContext(), this.workingMemory);
        }
    }

    @Override
    public FactHandle getFactHandle(Object object) {
        FactHandle handle = null;
        if (this.identityMap != null) {
            handle = this.identityMap.get(object);
        }
        if (handle != null) {
            return handle;
        }
        handle = this.getFactHandleFromWM(object);
        if (handle == null) {
            throw new FactException("Update error: handle not found for object: " + object + ". Is it in the working memory?");
        }
        return handle;
    }

    @Override
    public FactHandle getFactHandle(FactHandle handle) {
        Object object = ((InternalFactHandle)handle).getObject();
        if ((handle = this.getFactHandleFromWM(object)) == null) {
            throw new FactException("Update error: handle not found for object: " + object + ". Is it in the working memory?");
        }
        return handle;
    }

    @Override
    public void update(FactHandle handle, Object newObject) {
        InternalFactHandle h = (InternalFactHandle)handle;
        ((InternalWorkingMemoryEntryPoint)h.getEntryPoint()).update(h, newObject, Long.MAX_VALUE, Object.class, this.activation);
        if (this.getIdentityMap() != null) {
            this.getIdentityMap().put(newObject, handle);
        }
    }

    @Override
    public void update(FactHandle handle) {
        this.update(handle, Long.MAX_VALUE);
    }

    @Override
    public void update(FactHandle handle, long mask, Class<?> modifiedClass) {
        InternalFactHandle h = (InternalFactHandle)handle;
        ((InternalWorkingMemoryEntryPoint)h.getEntryPoint()).update(h, ((InternalFactHandle)handle).getObject(), mask, modifiedClass, this.activation);
        if (h.isTrait()) {
            if (((TraitFactHandle)h).isTraitable()) {
                this.updateTraits(h.getObject(), mask, null, modifiedClass);
            } else {
                Thing x = (Thing)h.getObject();
                if (x != x.getCore()) {
                    Object core = x.getCore();
                    InternalFactHandle coreHandle = (InternalFactHandle)this.getFactHandle(core);
                    ((InternalWorkingMemoryEntryPoint)coreHandle.getEntryPoint()).update(coreHandle, core, mask, modifiedClass, this.activation);
                    this.updateTraits(core, mask, x, modifiedClass);
                }
            }
        }
    }

    private void updateTraits(Object object, long mask, Thing originator, Class<?> modifiedClass) {
        TraitableBean txBean = (TraitableBean)object;
        Collection<Thing> px = txBean.getMostSpecificTraits();
        BitSet veto = null;
        if (originator != null) {
            veto = (BitSet)((TraitProxy)((Object)originator)).getTypeCode().clone();
        }
        for (Thing t : px) {
            if (t == originator) continue;
            TraitProxy proxy = (TraitProxy)((Object)t);
            proxy.setTypeFilter(veto);
            InternalFactHandle h = (InternalFactHandle)this.getFactHandle(t);
            ((InternalWorkingMemoryEntryPoint)h.getEntryPoint()).update(h, t, mask, modifiedClass, this.activation);
            proxy.setTypeFilter(null);
            BitSet tc = proxy.getTypeCode();
            if (veto == null) {
                veto = (BitSet)tc.clone();
                continue;
            }
            veto.and(tc);
        }
    }

    @Override
    public void update(Object object) {
        this.update(object, Long.MAX_VALUE, Object.class);
    }

    @Override
    public void update(Object object, long mask, Class<?> modifiedClass) {
        this.update(this.getFactHandle(object), mask, modifiedClass);
    }

    @Override
    public void retract(Object object) {
        this.retract(this.getFactHandle(object));
    }

    @Override
    public void retract(FactHandle handle) {
        ((InternalWorkingMemoryEntryPoint)((InternalFactHandle)handle).getEntryPoint()).retract(handle, true, true, this.activation.getRule(), this.activation);
        if (this.identityMap != null) {
            this.getIdentityMap().remove(((InternalFactHandle)handle).getObject());
        }
    }

    @Override
    public Rule getRule() {
        return this.activation.getRule();
    }

    @Override
    public Tuple getTuple() {
        return this.tuple;
    }

    @Override
    public WorkingMemory getWorkingMemory() {
        return this.workingMemory;
    }

    @Override
    public KnowledgeRuntime getKnowledgeRuntime() {
        return ((ReteooWorkingMemory)this.workingMemory).getKnowledgeRuntime();
    }

    @Override
    public org.drools.spi.Activation getActivation() {
        return this.activation;
    }

    @Override
    public void setFocus(String focus) {
        this.workingMemory.setFocus(focus);
    }

    @Override
    public Object get(Declaration declaration) {
        InternalWorkingMemoryEntryPoint wmTmp = (InternalWorkingMemoryEntryPoint)this.tuple.get(declaration).getEntryPoint();
        if (wmTmp != null) {
            Object object = declaration.getValue(wmTmp.getInternalWorkingMemory(), this.tuple.get(declaration).getObject());
            if (this.identityMap != null) {
                this.getIdentityMap().put(object, wmTmp.getFactHandleByIdentity(object));
            }
            return object;
        }
        return null;
    }

    @Override
    public Declaration getDeclaration(String identifier) {
        return ((AgendaItem)this.activation).getRuleTerminalNode().getSubRule().getOuterDeclarations().get(identifier);
    }

    @Override
    public void halt() {
        this.workingMemory.halt();
    }

    @Override
    public WorkingMemoryEntryPoint getEntryPoint(String id) {
        return this.workingMemory.getEntryPoints().get(id);
    }

    @Override
    @Deprecated
    public ExitPoint getExitPoint(String id) {
        return this.workingMemory.getExitPoints().get(id);
    }

    @Override
    public Channel getChannel(String id) {
        return this.workingMemory.getChannels().get(id);
    }

    @Override
    public Map<String, WorkingMemoryEntryPoint> getEntryPoints() {
        return Collections.unmodifiableMap(this.workingMemory.getEntryPoints());
    }

    @Override
    @Deprecated
    public Map<String, ExitPoint> getExitPoints() {
        return Collections.unmodifiableMap(this.workingMemory.getExitPoints());
    }

    @Override
    public Map<String, Channel> getChannels() {
        return Collections.unmodifiableMap(this.workingMemory.getChannels());
    }

    @Override
    public IdentityHashMap<Object, FactHandle> getIdentityMap() {
        return this.identityMap;
    }

    @Override
    public void setIdentityMap(IdentityHashMap<Object, FactHandle> identityMap) {
        this.identityMap = identityMap;
    }

    private FactHandle getFactHandleFromWM(Object object) {
        FactHandle handle = null;
        for (WorkingMemoryEntryPoint workingMemoryEntryPoint : this.workingMemory.getEntryPoints().values()) {
            handle = (FactHandle)workingMemoryEntryPoint.getFactHandle(object);
            if (this.identityMap != null) {
                this.identityMap.put(object, handle);
            }
            if (handle == null) continue;
            break;
        }
        return handle;
    }

    @Override
    public <T> T getContext(Class<T> contextClass) {
        Map<Long, String> nodeInstances;
        String ruleflowGroupName;
        if (org.drools.runtime.process.ProcessContext.class.equals(contextClass) && (ruleflowGroupName = this.getActivation().getRule().getRuleFlowGroup()) != null && !(nodeInstances = ((InternalRuleFlowGroup)this.workingMemory.getAgenda().getRuleFlowGroup(ruleflowGroupName)).getNodeInstances()).isEmpty()) {
            if (nodeInstances.size() > 1) {
                throw new UnsupportedOperationException("Not supporting multiple node instances for the same ruleflow group");
            }
            Map.Entry<Long, String> entry = nodeInstances.entrySet().iterator().next();
            ProcessInstance processInstance = this.workingMemory.getProcessInstance(entry.getKey());
            ProcessContext context = new ProcessContext(this.workingMemory.getKnowledgeRuntime());
            context.setProcessInstance(processInstance);
            String nodeInstance = entry.getValue();
            String[] nodeInstanceIds = nodeInstance.split(":");
            NodeInstanceContainer container = (WorkflowProcessInstance)processInstance;
            block0: for (int i = 0; i < nodeInstanceIds.length; ++i) {
                for (NodeInstance subNodeInstance : container.getNodeInstances()) {
                    if (subNodeInstance.getId() != new Long(nodeInstanceIds[i]).longValue()) continue;
                    if (i == nodeInstanceIds.length - 1) {
                        context.setNodeInstance(subNodeInstance);
                        continue block0;
                    }
                    container = (NodeInstanceContainer)((Object)subNodeInstance);
                }
            }
            return (T)context;
        }
        return null;
    }

    @Override
    public <T, K> T don(K core, Class<T> trait, boolean logical) {
        try {
            T thing = this.applyTrait(core, trait, logical);
            if (thing == core) {
                return thing;
            }
            return this.doInsertTrait(thing, logical);
        }
        catch (LogicalTypeInconsistencyException ltie) {
            ltie.printStackTrace();
            return null;
        }
    }

    protected <T> T doInsertTrait(T thing, boolean logical) {
        if (logical) {
            this.insertLogical(thing);
        } else {
            this.insert(thing);
        }
        return thing;
    }

    protected <T, K> T applyTrait(K core, Class<T> trait, boolean logical) throws LogicalTypeInconsistencyException {
        TraitableBean<K, CoreWrapper<K>> inner;
        AbstractRuleBase arb = (AbstractRuleBase)((KnowledgeBaseImpl)this.getKnowledgeRuntime().getKnowledgeBase()).getRuleBase();
        TraitFactory builder = arb.getConfiguration().getComponentFactory().getTraitFactory();
        boolean needsWrapping = !(core instanceof TraitableBean);
        TraitableBean<K, CoreWrapper<K>> traitableBean = inner = needsWrapping ? this.asTraitable(core, builder) : (TraitableBean<K, CoreWrapper<K>>)core;
        if (needsWrapping) {
            InternalFactHandle h = (InternalFactHandle)this.getFactHandle(core);
            InternalWorkingMemoryEntryPoint ep = (InternalWorkingMemoryEntryPoint)h.getEntryPoint();
            ObjectTypeConfigurationRegistry reg = ep.getObjectTypeConfigurationRegistry();
            ObjectTypeConf coreConf = reg.getObjectTypeConf(ep.getEntryPoint(), core);
            ObjectTypeConf innerConf = reg.getObjectTypeConf(ep.getEntryPoint(), inner);
            if (coreConf.isTMSEnabled()) {
                innerConf.enableTMS();
            }
        }
        return this.processTraits(core, trait, builder, needsWrapping, inner, logical);
    }

    protected <K> TraitableBean<K, CoreWrapper<K>> asTraitable(K core, TraitFactory builder) {
        CoreWrapper<?> wrapper = builder.getCoreWrapper(core.getClass());
        if (wrapper == null) {
            throw new UnsupportedOperationException("Error: cannot apply a trait to non-traitable class " + core.getClass());
        }
        wrapper.init(core);
        return wrapper;
    }

    protected <T, K> T processTraits(K core, Class<T> trait, TraitFactory builder, boolean needsUpdate, TraitableBean<K, ? extends TraitableBean> inner, boolean logical) throws LogicalTypeInconsistencyException {
        TraitableBean thing;
        if (trait.isAssignableFrom(inner.getClass())) {
            thing = inner;
            inner.addTrait(trait.getName(), (Thing)core);
            needsUpdate = true;
        } else {
            if (inner.hasTrait(trait.getName())) {
                return (T)inner.getTrait(trait.getName());
            }
            thing = builder.getProxy(inner, trait);
        }
        if (needsUpdate) {
            this.update(this.getFactHandle(core), inner);
        }
        if (!inner.hasTrait(Thing.class.getName())) {
            this.don(inner, Thing.class, logical);
        }
        return (T)thing;
    }

    @Override
    public <T, K> T don(Thing<K> core, Class<T> trait, boolean logical) {
        return this.don(core.getCore(), trait, logical);
    }

    @Override
    public <T, K> T don(K core, Class<T> trait) {
        return this.don(core, trait, false);
    }

    @Override
    public <T, K> T don(Thing<K> core, Class<T> trait) {
        return this.don(core.getCore(), trait);
    }

    @Override
    public <T, K> Thing<K> shed(Thing<K> thing, Class<T> trait) {
        return this.shed((TraitableBean)thing.getCore(), trait);
    }

    @Override
    public <T, K, X extends TraitableBean> Thing<K> shed(TraitableBean<K, X> core, Class<T> trait) {
        Collection<Thing<K>> removedTypes;
        if (trait.isAssignableFrom(core.getClass())) {
            core.removeTrait(trait.getName());
            this.update(core);
            return (Thing)((Object)core);
        }
        if (core.hasTrait(trait.getName())) {
            removedTypes = core.removeTrait(trait.getName());
        } else {
            HierarchyEncoder hier = ((ReteooRuleBase)this.workingMemory.getRuleBase()).getConfiguration().getComponentFactory().getTraitRegistry().getHierarchy();
            BitSet code = hier.getCode(trait.getName());
            removedTypes = core.removeTrait(code);
        }
        for (Thing<K> t : removedTypes) {
            if (((TraitType)((Object)t)).isVirtual()) continue;
            this.retract(t);
        }
        Thing<K> thing = core.getTrait(Thing.class.getName());
        this.update(thing);
        return thing;
    }

    @Override
    public void modify(Object newObject) {
    }
}

