/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.evaluators;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.drools.RuntimeDroolsException;
import org.drools.base.BaseEvaluator;
import org.drools.base.ValueType;
import org.drools.base.evaluators.EvaluatorDefinition;
import org.drools.base.evaluators.Operator;
import org.drools.base.evaluators.TimeIntervalParser;
import org.drools.common.EventFactHandle;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.rule.VariableRestriction;
import org.drools.spi.Evaluator;
import org.drools.spi.FieldValue;
import org.drools.spi.InternalReadAccessor;
import org.drools.time.Interval;

public class OverlappedByEvaluatorDefinition
implements EvaluatorDefinition {
    public static final Operator OVERLAPPED_BY = Operator.addOperatorToRegistry("overlappedby", false);
    public static final Operator NOT_OVERLAPPED_BY = Operator.addOperatorToRegistry("overlappedby", true);
    private static final String[] SUPPORTED_IDS = new String[]{OVERLAPPED_BY.getOperatorString()};
    private Map<String, OverlappedByEvaluator> cache = Collections.emptyMap();
    private volatile TimeIntervalParser parser = new TimeIntervalParser();

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.cache = (Map)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.cache);
    }

    public Evaluator getEvaluator(ValueType type, Operator operator) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), null);
    }

    public Evaluator getEvaluator(ValueType type, Operator operator, String parameterText) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), parameterText);
    }

    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText) {
        return this.getEvaluator(type, operatorId, isNegated, parameterText, EvaluatorDefinition.Target.HANDLE, EvaluatorDefinition.Target.HANDLE);
    }

    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText, EvaluatorDefinition.Target left, EvaluatorDefinition.Target right) {
        String key;
        OverlappedByEvaluator eval;
        if (this.cache == Collections.EMPTY_MAP) {
            this.cache = new HashMap<String, OverlappedByEvaluator>();
        }
        if ((eval = this.cache.get(key = isNegated + ":" + parameterText)) == null) {
            Long[] params = this.parser.parse(parameterText);
            eval = new OverlappedByEvaluator(type, isNegated, params, parameterText);
            this.cache.put(key, eval);
        }
        return eval;
    }

    public String[] getEvaluatorIds() {
        return SUPPORTED_IDS;
    }

    public boolean isNegatable() {
        return true;
    }

    public EvaluatorDefinition.Target getTarget() {
        return EvaluatorDefinition.Target.HANDLE;
    }

    public boolean supportsType(ValueType type) {
        return true;
    }

    public static class OverlappedByEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 510L;
        private long minDev;
        private long maxDev;
        private String paramText;

        public OverlappedByEvaluator() {
        }

        public OverlappedByEvaluator(ValueType type, boolean isNegated, Long[] parameters, String paramText) {
            super(type, isNegated ? NOT_OVERLAPPED_BY : OVERLAPPED_BY);
            this.paramText = paramText;
            this.setParameters(parameters);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.minDev = in.readLong();
            this.maxDev = in.readLong();
            this.paramText = (String)in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeLong(this.minDev);
            out.writeLong(this.maxDev);
            out.writeObject(this.paramText);
        }

        public boolean isTemporal() {
            return true;
        }

        public Interval getInterval() {
            if (this.getOperator().isNegated()) {
                return new Interval(Long.MIN_VALUE, Long.MAX_VALUE);
            }
            return new Interval(0L, Long.MAX_VALUE);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, InternalFactHandle object1, FieldValue object2) {
            throw new RuntimeDroolsException("The 'overlappedby' operator can only be used to compare one event to another, and never to compare to literal constraints.");
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, InternalFactHandle left) {
            if (context.rightNull || context.declaration.getExtractor().isNullValue(workingMemory, left.getObject())) {
                return false;
            }
            long rightStartTS = ((VariableRestriction.TemporalVariableContextEntry)context).startTS;
            long leftEndTS = ((EventFactHandle)left).getEndTimestamp();
            long dist = leftEndTS - rightStartTS;
            return this.getOperator().isNegated() ^ (((EventFactHandle)left).getStartTimestamp() < rightStartTS && leftEndTS < ((VariableRestriction.TemporalVariableContextEntry)context).endTS && dist >= this.minDev && dist <= this.maxDev);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, InternalFactHandle right) {
            if (context.leftNull || context.extractor.isNullValue(workingMemory, right.getObject())) {
                return false;
            }
            long leftEndTS = ((VariableRestriction.TemporalVariableContextEntry)context).endTS;
            long rightStartTS = ((EventFactHandle)right).getStartTimestamp();
            long dist = leftEndTS - rightStartTS;
            return this.getOperator().isNegated() ^ (((VariableRestriction.TemporalVariableContextEntry)context).startTS < rightStartTS && leftEndTS < ((EventFactHandle)right).getEndTimestamp() && dist >= this.minDev && dist <= this.maxDev);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, InternalFactHandle handle1, InternalReadAccessor extractor2, InternalFactHandle handle2) {
            if (extractor1.isNullValue(workingMemory, handle1.getObject()) || extractor2.isNullValue(workingMemory, handle2.getObject())) {
                return false;
            }
            long startTS = ((EventFactHandle)handle1).getStartTimestamp();
            long endTS = ((EventFactHandle)handle2).getEndTimestamp();
            long dist = endTS - startTS;
            return this.getOperator().isNegated() ^ (((EventFactHandle)handle2).getStartTimestamp() < startTS && endTS < ((EventFactHandle)handle1).getEndTimestamp() && dist >= this.minDev && dist <= this.maxDev);
        }

        public String toString() {
            return "overlappedby[" + (this.paramText != null ? this.paramText : "") + "]";
        }

        public int hashCode() {
            int PRIME = 31;
            int result = super.hashCode();
            result = 31 * result + (int)(this.maxDev ^ this.maxDev >>> 32);
            result = 31 * result + (int)(this.minDev ^ this.minDev >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OverlappedByEvaluator other = (OverlappedByEvaluator)obj;
            return this.maxDev == other.maxDev && this.minDev == other.minDev;
        }

        private void setParameters(Long[] parameters) {
            if (parameters == null || parameters.length == 0) {
                this.minDev = 1L;
                this.maxDev = Long.MAX_VALUE;
            } else if (parameters.length == 1) {
                this.minDev = 1L;
                this.maxDev = parameters[0];
            } else if (parameters.length == 2) {
                this.minDev = parameters[0];
                this.maxDev = parameters[1];
            } else {
                throw new RuntimeDroolsException("[Overlaps Evaluator]: Not possible to use " + parameters.length + " parameters: '" + this.paramText + "'");
            }
        }
    }
}

