/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.drools.FactHandle;
import org.drools.base.ClassObjectType;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.WorkingMemoryAction;
import org.drools.core.util.BitMaskUtil;
import org.drools.core.util.ObjectHashSet;
import org.drools.definition.rule.Rule;
import org.drools.marshalling.impl.MarshallerReaderContext;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.WindowTupleList;
import org.drools.rule.EntryPoint;
import org.drools.spi.ObjectType;
import org.drools.spi.PropagationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropagationContextImpl
implements PropagationContext {
    private static final long serialVersionUID = 510L;
    private int type;
    private org.drools.rule.Rule rule;
    private LeftTuple leftTuple;
    private InternalFactHandle factHandle;
    private long propagationNumber;
    public int activeActivations;
    public int dormantActivations;
    private EntryPoint entryPoint;
    private int originOffset;
    private ObjectHashSet propagationAttempts;
    private ObjectTypeNode currentPropagatingOTN;
    private boolean shouldPropagateAll;
    private final LinkedList<WorkingMemoryAction> queue1 = new LinkedList();
    private LinkedList<WorkingMemoryAction> queue2;
    private long modificationMask = Long.MAX_VALUE;
    private long originalMask = Long.MAX_VALUE;
    private Class<?> modifiedClass;
    private WindowTupleList windowTupleList;
    private ObjectType objectType;
    private transient MarshallerReaderContext readerContext;

    public PropagationContextImpl() {
    }

    public PropagationContextImpl(long number, int type, org.drools.rule.Rule rule, LeftTuple leftTuple, InternalFactHandle factHandle) {
        this(number, type, rule, leftTuple, factHandle, 0, 0, EntryPoint.DEFAULT, Long.MAX_VALUE, Object.class, null);
        this.originOffset = -1;
        this.shouldPropagateAll = true;
    }

    public PropagationContextImpl(long number, int type, org.drools.rule.Rule rule, LeftTuple leftTuple, InternalFactHandle factHandle, int activeActivations, int dormantActivations, EntryPoint entryPoint) {
        this(number, type, rule, leftTuple, factHandle, activeActivations, dormantActivations, entryPoint, Long.MAX_VALUE, Object.class, null);
    }

    public PropagationContextImpl(long number, int type, org.drools.rule.Rule rule, LeftTuple leftTuple, InternalFactHandle factHandle, int activeActivations, int dormantActivations, EntryPoint entryPoint, long modificationMask) {
        this(number, type, rule, leftTuple, factHandle, activeActivations, dormantActivations, entryPoint, modificationMask, Object.class, null);
    }

    public PropagationContextImpl(long number, int type, org.drools.rule.Rule rule, LeftTuple leftTuple, InternalFactHandle factHandle, int activeActivations, int dormantActivations, EntryPoint entryPoint, MarshallerReaderContext readerContext) {
        this(number, type, rule, leftTuple, factHandle, activeActivations, dormantActivations, entryPoint, Long.MAX_VALUE, Object.class, readerContext);
    }

    public PropagationContextImpl(long number, int type, org.drools.rule.Rule rule, LeftTuple leftTuple, InternalFactHandle factHandle, int activeActivations, int dormantActivations, EntryPoint entryPoint, long modificationMask, Class<?> modifiedClass, MarshallerReaderContext readerContext) {
        this.type = type;
        this.rule = rule;
        this.leftTuple = leftTuple;
        this.factHandle = factHandle;
        this.propagationNumber = number;
        this.activeActivations = activeActivations;
        this.dormantActivations = dormantActivations;
        this.entryPoint = entryPoint;
        this.originOffset = -1;
        this.modificationMask = modificationMask;
        this.originalMask = modificationMask;
        this.modifiedClass = modifiedClass;
        this.readerContext = readerContext;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.type = in.readInt();
        this.activeActivations = in.readInt();
        this.dormantActivations = in.readInt();
        this.propagationNumber = in.readLong();
        this.rule = (org.drools.rule.Rule)in.readObject();
        this.leftTuple = (LeftTuple)in.readObject();
        this.entryPoint = (EntryPoint)in.readObject();
        this.originOffset = in.readInt();
        this.propagationAttempts = (ObjectHashSet)in.readObject();
        this.currentPropagatingOTN = (ObjectTypeNode)in.readObject();
        this.shouldPropagateAll = in.readBoolean();
        this.modificationMask = in.readLong();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.type);
        out.writeInt(this.activeActivations);
        out.writeInt(this.dormantActivations);
        out.writeLong(this.propagationNumber);
        out.writeObject(this.rule);
        out.writeObject(this.leftTuple);
        out.writeObject(this.entryPoint);
        out.writeInt(this.originOffset);
        out.writeObject(this.propagationAttempts);
        out.writeObject(this.currentPropagatingOTN);
        out.writeObject(this.shouldPropagateAll);
        out.writeLong(this.modificationMask);
    }

    @Override
    public long getPropagationNumber() {
        return this.propagationNumber;
    }

    public void cleanReaderContext() {
        this.readerContext = null;
    }

    @Override
    public org.drools.rule.Rule getRuleOrigin() {
        return this.rule;
    }

    @Override
    public Rule getRule() {
        return this.rule;
    }

    @Override
    public LeftTuple getLeftTupleOrigin() {
        return this.leftTuple;
    }

    @Override
    public InternalFactHandle getFactHandleOrigin() {
        return this.factHandle;
    }

    @Override
    public FactHandle getFactHandle() {
        return this.factHandle;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public int getActiveActivations() {
        return this.activeActivations;
    }

    @Override
    public int getDormantActivations() {
        return this.dormantActivations;
    }

    @Override
    public void releaseResources() {
        this.leftTuple = null;
        this.rule = null;
    }

    @Override
    public EntryPoint getEntryPoint() {
        return this.entryPoint;
    }

    public void setEntryPoint(EntryPoint entryPoint) {
        this.entryPoint = entryPoint;
    }

    public void setFactHandle(InternalFactHandle factHandle) {
        this.factHandle = factHandle;
    }

    @Override
    public int getOriginOffset() {
        return this.originOffset;
    }

    @Override
    public void setOriginOffset(int originOffset) {
        this.originOffset = originOffset;
    }

    @Override
    public ObjectHashSet getPropagationAttemptsMemory() {
        if (this.propagationAttempts == null) {
            this.propagationAttempts = new ObjectHashSet();
        }
        return this.propagationAttempts;
    }

    @Override
    public boolean isPropagating(ObjectTypeNode otn) {
        return this.currentPropagatingOTN != null && this.currentPropagatingOTN.equals(otn);
    }

    @Override
    public void setCurrentPropagatingOTN(ObjectTypeNode otn) {
        this.currentPropagatingOTN = otn;
    }

    @Override
    public void setShouldPropagateAll(Object node) {
        this.shouldPropagateAll = this.getPropagationAttemptsMemory().contains(node);
    }

    @Override
    public boolean shouldPropagateAll() {
        return this.shouldPropagateAll;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addInsertAction(WorkingMemoryAction action) {
        LinkedList<WorkingMemoryAction> linkedList = this.queue1;
        synchronized (linkedList) {
            this.queue1.addFirst(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeInsertAction(WorkingMemoryAction action) {
        LinkedList<WorkingMemoryAction> linkedList = this.queue1;
        synchronized (linkedList) {
            this.queue1.remove(action);
        }
    }

    @Override
    public LinkedList<WorkingMemoryAction> getQueue2() {
        if (this.queue2 == null) {
            this.queue2 = new LinkedList();
        }
        return this.queue2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evaluateActionQueue(InternalWorkingMemory workingMemory) {
        boolean repeat = true;
        block3: while (repeat) {
            WorkingMemoryAction action;
            LinkedList<WorkingMemoryAction> linkedList = this.queue1;
            synchronized (linkedList) {
                WorkingMemoryAction action2;
                while ((action2 = !this.queue1.isEmpty() ? this.queue1.removeFirst() : null) != null) {
                    action2.execute(workingMemory);
                }
            }
            repeat = false;
            if (this.queue2 == null) continue;
            while ((action = !this.queue2.isEmpty() ? this.queue2.removeFirst() : null) != null) {
                action.execute(workingMemory);
                if (this.queue1.isEmpty()) continue;
                repeat = true;
                continue block3;
            }
        }
    }

    @Override
    public long getModificationMask() {
        return this.modificationMask;
    }

    @Override
    public PropagationContext adaptModificationMaskForObjectType(ObjectType type, InternalWorkingMemory workingMemory) {
        this.modificationMask = this.originalMask;
        if (this.modificationMask == Long.MAX_VALUE || !(type instanceof ClassObjectType)) {
            return this;
        }
        ClassObjectType classObjectType = (ClassObjectType)type;
        Class<?> classType = classObjectType.getClassType();
        if (classType == this.modifiedClass || !classType.isInterface() && !this.modifiedClass.isInterface()) {
            return this;
        }
        Long cachedMask = classObjectType.getTransformedMask(this.modifiedClass, this.originalMask);
        if (cachedMask != null) {
            this.modificationMask = cachedMask;
            return this;
        }
        this.modificationMask = 0L;
        List<String> typeClassProps = this.getSettableProperties(workingMemory, classType);
        List<String> modifiedClassProps = this.getSettableProperties(workingMemory, this.modifiedClass);
        for (int i = 0; i < modifiedClassProps.size(); ++i) {
            int posInType;
            if (!BitMaskUtil.isPositionSet(this.originalMask, i) || (posInType = typeClassProps.indexOf(modifiedClassProps.get(i))) < 0) continue;
            this.modificationMask = BitMaskUtil.set(this.modificationMask, posInType);
        }
        classObjectType.storeTransformedMask(this.modifiedClass, this.originalMask, this.modificationMask);
        return this;
    }

    private List<String> getSettableProperties(InternalWorkingMemory workingMemory, Class<?> classType) {
        String pkgName = classType.getPackage().getName();
        return "java.lang".equals(pkgName) ? Collections.EMPTY_LIST : workingMemory.getRuleBase().getPackage(pkgName).getTypeDeclaration(classType).getSettableProperties();
    }

    @Override
    public WindowTupleList getActiveWindowTupleList() {
        return this.windowTupleList;
    }

    @Override
    public void setActiveWindowTupleList(WindowTupleList list) {
        this.windowTupleList = list;
    }

    @Override
    public ObjectType getObjectType() {
        return this.objectType;
    }

    @Override
    public void setObjectType(ObjectType objectType) {
        this.objectType = objectType;
    }

    @Override
    public MarshallerReaderContext getReaderContext() {
        return this.readerContext;
    }

    public String toString() {
        return "PropagationContextImpl [activeActivations=" + this.activeActivations + ", dormantActivations=" + this.dormantActivations + ", entryPoint=" + this.entryPoint + ", factHandle=" + this.factHandle + ", leftTuple=" + this.leftTuple + ", originOffset=" + this.originOffset + ", propagationNumber=" + this.propagationNumber + ", rule=" + this.rule + ", type=" + this.type + "]";
    }
}

