/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import org.drools.RuleBaseConfiguration;
import org.drools.common.BetaConstraints;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.core.util.index.IndexUtil;
import org.drools.reteoo.BetaMemory;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.ContextEntry;
import org.drools.rule.constraint.MvelConstraint;
import org.drools.spi.BetaNodeFieldConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleBetaConstraints
implements BetaConstraints {
    private static final long serialVersionUID = 510L;
    protected BetaNodeFieldConstraint constraint;
    private boolean indexed;
    private transient boolean disableIndex;

    public SingleBetaConstraints() {
    }

    public SingleBetaConstraints(BetaNodeFieldConstraint[] constraint, RuleBaseConfiguration conf) {
        this(constraint[0], conf, false);
    }

    public SingleBetaConstraints(BetaNodeFieldConstraint constraint, RuleBaseConfiguration conf) {
        this(constraint, conf, false);
    }

    public SingleBetaConstraints(BetaNodeFieldConstraint constraint, RuleBaseConfiguration conf, boolean disableIndex) {
        this.constraint = constraint;
        this.disableIndex = disableIndex;
    }

    @Override
    public void init(BuildContext context, short betaNodeType) {
        RuleBaseConfiguration config = context.getRuleBase().getConfiguration();
        if (this.disableIndex || !config.isIndexLeftBetaMemory() && !config.isIndexRightBetaMemory()) {
            this.indexed = false;
        } else {
            this.initIndexes(config.getCompositeKeyDepth(), betaNodeType);
        }
    }

    @Override
    public void initIndexes(int depth, short betaNodeType) {
        this.indexed = depth >= 1 && IndexUtil.isIndexableForNode(betaNodeType, this.constraint);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.constraint = (BetaNodeFieldConstraint)in.readObject();
        this.indexed = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.constraint);
        out.writeBoolean(this.indexed);
    }

    @Override
    public ContextEntry[] createContext() {
        return new ContextEntry[]{this.constraint.createContextEntry()};
    }

    @Override
    public void updateFromTuple(ContextEntry[] context, InternalWorkingMemory workingMemory, LeftTuple tuple) {
        context[0].updateFromTuple(workingMemory, tuple);
    }

    @Override
    public void updateFromFactHandle(ContextEntry[] context, InternalWorkingMemory workingMemory, InternalFactHandle handle) {
        context[0].updateFromFactHandle(workingMemory, handle);
    }

    @Override
    public boolean isAllowedCachedLeft(ContextEntry[] context, InternalFactHandle handle) {
        return this.indexed || this.constraint.isAllowedCachedLeft(context[0], handle);
    }

    @Override
    public boolean isAllowedCachedRight(ContextEntry[] context, LeftTuple tuple) {
        return this.constraint.isAllowedCachedRight(tuple, context[0]);
    }

    @Override
    public boolean isIndexed() {
        return this.indexed;
    }

    @Override
    public int getIndexCount() {
        return this.indexed ? 1 : 0;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public BetaMemory createBetaMemory(RuleBaseConfiguration config, short nodeType) {
        return IndexUtil.Factory.createBetaMemory(config, nodeType, this.constraint);
    }

    public int hashCode() {
        return this.constraint.hashCode();
    }

    public BetaNodeFieldConstraint getConstraint() {
        return this.constraint;
    }

    @Override
    public BetaNodeFieldConstraint[] getConstraints() {
        return new BetaNodeFieldConstraint[]{this.constraint};
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SingleBetaConstraints other = (SingleBetaConstraints)object;
        return this.constraint == other.constraint || this.constraint.equals(other.constraint);
    }

    @Override
    public void resetFactHandle(ContextEntry[] context) {
        context[0].resetFactHandle();
    }

    @Override
    public void resetTuple(ContextEntry[] context) {
        context[0].resetTuple();
    }

    @Override
    public BetaConstraints getOriginalConstraint() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getListenedPropertyMask(List<String> settableProperties) {
        return this.constraint instanceof MvelConstraint ? ((MvelConstraint)this.constraint).getListenedPropertyMask(settableProperties) : Long.MAX_VALUE;
    }
}

