/*
 * Decompiled with CFR 0.152.
 */
package org.drools.factmodel;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.beans.IntrospectionException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import org.drools.factmodel.ClassBuilder;
import org.drools.factmodel.ClassBuilderFactory;
import org.drools.factmodel.ClassDefinition;
import org.drools.factmodel.Fact;
import org.drools.factmodel.Field;
import org.drools.factmodel.FieldDefinition;

public class Jenerator {
    public byte[] createJar(Fact[] facts, String packageName) throws SecurityException, IllegalArgumentException, IOException, IntrospectionException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchFieldException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        JarOutputStream jout = new JarOutputStream(result);
        JarEntry metaModel = new JarEntry("factmodel.xml");
        jout.putNextEntry(metaModel);
        jout.write(this.toXML(facts));
        jout.closeEntry();
        String packagePath = packageName.replace('.', '/');
        for (int i = 0; i < facts.length; ++i) {
            ClassBuilder cb = new ClassBuilderFactory().getBeanClassBuilder();
            ClassDefinition classDef = new ClassDefinition(packageName, null, new String[]{"java.io.Serializable"});
            for (int j = 0; j < facts[i].fields.size(); ++j) {
                Field fd = (Field)facts[i].fields.get(j);
                classDef.addField(new FieldDefinition(fd.name, fd.type));
            }
            JarEntry je = new JarEntry(packagePath + "/" + facts[i].name + ".class");
            jout.putNextEntry(je);
            jout.write(cb.buildClass(classDef));
            jout.closeEntry();
        }
        jout.flush();
        jout.close();
        return result.toByteArray();
    }

    private byte[] toXML(Fact[] facts) {
        XStream x = new XStream((HierarchicalStreamDriver)new DomDriver());
        return x.toXML((Object)facts).getBytes();
    }

    public Fact[] loadMetaModel(JarInputStream jis) throws Exception {
        JarEntry entry = null;
        while ((entry = jis.getNextJarEntry()) != null) {
            if (!entry.getName().equals("factmodel.xml")) continue;
            return this.fromXML(jis);
        }
        throw new IllegalArgumentException("This is not a valid drools model jar - no factmodel.xml found.");
    }

    private Fact[] fromXML(JarInputStream jis) {
        XStream x = new XStream((HierarchicalStreamDriver)new DomDriver());
        return (Fact[])x.fromXML((InputStream)jis);
    }
}

