/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.constraint;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.drools.base.ClassFieldReader;
import org.drools.base.DroolsQuery;
import org.drools.base.extractors.ArrayElementReader;
import org.drools.base.mvel.MVELCompilationUnit;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.concurrent.ExecutorProviderFactory;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.BitMaskUtil;
import org.drools.core.util.ClassUtils;
import org.drools.core.util.MemoryUtil;
import org.drools.core.util.StringUtils;
import org.drools.core.util.index.IndexUtil;
import org.drools.reteoo.LeftTuple;
import org.drools.rule.ContextEntry;
import org.drools.rule.Declaration;
import org.drools.rule.IndexEvaluator;
import org.drools.rule.IndexableConstraint;
import org.drools.rule.MVELDialectRuntimeData;
import org.drools.rule.MutableTypeConstraint;
import org.drools.rule.constraint.ASMConditionEvaluatorJitter;
import org.drools.rule.constraint.ConditionAnalyzer;
import org.drools.rule.constraint.ConditionEvaluator;
import org.drools.rule.constraint.MvelConditionEvaluator;
import org.drools.runtime.rule.Variable;
import org.drools.spi.AcceptsReadAccessor;
import org.drools.spi.Constraint;
import org.drools.spi.FieldValue;
import org.drools.spi.InternalReadAccessor;
import org.drools.util.CompositeClassLoader;
import org.mvel2.ParserConfiguration;
import org.mvel2.compiler.CompiledExpression;
import org.mvel2.compiler.ExecutableStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MvelConstraint
extends MutableTypeConstraint
implements IndexableConstraint,
AcceptsReadAccessor {
    protected static final boolean TEST_JITTING = false;
    protected static final int JIT_THRESOLD = 20;
    private static final Logger logger = LoggerFactory.getLogger(MvelConstraint.class);
    protected final transient AtomicInteger invocationCounter = new AtomicInteger(1);
    protected transient boolean jitted = false;
    private String packageName;
    protected String expression;
    private IndexUtil.ConstraintType constraintType = IndexUtil.ConstraintType.UNKNOWN;
    private Declaration[] declarations;
    private Declaration indexingDeclaration;
    private InternalReadAccessor extractor;
    private boolean isUnification;
    protected boolean isDynamic;
    private FieldValue fieldValue;
    protected MVELCompilationUnit compilationUnit;
    protected volatile transient ConditionEvaluator conditionEvaluator;
    private volatile transient ConditionAnalyzer.Condition analyzedCondition;
    public static final IndexEvaluator INDEX_EVALUATOR = new PlainIndexEvaluator();

    public MvelConstraint() {
    }

    public MvelConstraint(String packageName, String expression, MVELCompilationUnit compilationUnit, IndexUtil.ConstraintType constraintType, FieldValue fieldValue, InternalReadAccessor extractor) {
        this.packageName = packageName;
        this.expression = expression;
        this.compilationUnit = compilationUnit;
        this.constraintType = constraintType;
        this.declarations = new Declaration[0];
        this.fieldValue = fieldValue;
        this.extractor = extractor;
    }

    public MvelConstraint(String packageName, String expression, Declaration[] declarations, MVELCompilationUnit compilationUnit, boolean isDynamic) {
        this.packageName = packageName;
        this.expression = expression;
        this.declarations = declarations;
        this.compilationUnit = compilationUnit;
        this.isDynamic = isDynamic;
    }

    public MvelConstraint(String packageName, String expression, Declaration[] declarations, MVELCompilationUnit compilationUnit, IndexUtil.ConstraintType constraintType, Declaration indexingDeclaration, InternalReadAccessor extractor, boolean isUnification) {
        this.packageName = packageName;
        this.expression = expression;
        this.compilationUnit = compilationUnit;
        this.constraintType = indexingDeclaration != null ? constraintType : IndexUtil.ConstraintType.UNKNOWN;
        this.declarations = declarations == null ? new Declaration[]{} : declarations;
        this.indexingDeclaration = indexingDeclaration;
        this.extractor = extractor;
        this.isUnification = isUnification;
    }

    protected String getAccessedClass() {
        return this.extractor instanceof ClassFieldReader ? ((ClassFieldReader)this.extractor).getClassName() : null;
    }

    @Override
    public void setReadAccessor(InternalReadAccessor readAccessor) {
        this.extractor = readAccessor;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getExpression() {
        return this.expression;
    }

    public boolean isDynamic() {
        return this.isDynamic;
    }

    @Override
    public boolean isUnification() {
        return this.isUnification;
    }

    public void unsetUnification() {
        this.isUnification = false;
    }

    @Override
    public boolean isIndexable(short nodeType) {
        return this.getConstraintType().isIndexableForNode(nodeType);
    }

    @Override
    public IndexUtil.ConstraintType getConstraintType() {
        return this.constraintType;
    }

    @Override
    public FieldValue getField() {
        return this.fieldValue;
    }

    @Override
    public boolean isAllowed(InternalFactHandle handle, InternalWorkingMemory workingMemory, ContextEntry context) {
        if (this.isUnification) {
            throw new UnsupportedOperationException("Should not be called");
        }
        return this.evaluate(handle.getObject(), workingMemory, null);
    }

    @Override
    public boolean isAllowedCachedLeft(ContextEntry context, InternalFactHandle handle) {
        if (this.isUnification) {
            if (((UnificationContextEntry)context).getVariable() != null) {
                return true;
            }
            context = ((UnificationContextEntry)context).getContextEntry();
        }
        MvelContextEntry mvelContextEntry = (MvelContextEntry)context;
        return this.evaluate(handle.getObject(), mvelContextEntry.workingMemory, mvelContextEntry.leftTuple);
    }

    @Override
    public boolean isAllowedCachedRight(LeftTuple tuple, ContextEntry context) {
        if (this.isUnification) {
            DroolsQuery query = (DroolsQuery)tuple.get(0).getObject();
            Variable v = query.getVariables()[((UnificationContextEntry)context).getReader().getIndex()];
            if (v != null) {
                return true;
            }
            context = ((UnificationContextEntry)context).getContextEntry();
        }
        MvelContextEntry mvelContextEntry = (MvelContextEntry)context;
        return this.evaluate(mvelContextEntry.right, mvelContextEntry.workingMemory, tuple);
    }

    protected boolean evaluate(Object object, InternalWorkingMemory workingMemory, LeftTuple leftTuple) {
        if (!this.jitted) {
            if (this.conditionEvaluator == null) {
                this.createMvelConditionEvaluator(workingMemory);
            }
            if (!this.isDynamic && this.invocationCounter.getAndIncrement() == 20) {
                this.jitEvaluator(object, workingMemory, leftTuple);
            }
        }
        return this.conditionEvaluator.evaluate(object, workingMemory, leftTuple);
    }

    protected void createMvelConditionEvaluator(InternalWorkingMemory workingMemory) {
        if (this.compilationUnit != null) {
            MVELDialectRuntimeData data = this.getMVELDialectRuntimeData(workingMemory);
            ExecutableStatement statement = (ExecutableStatement)this.compilationUnit.getCompiledExpression(data);
            ParserConfiguration configuration = statement instanceof CompiledExpression ? ((CompiledExpression)statement).getParserConfiguration() : data.getParserConfiguration();
            this.conditionEvaluator = new MvelConditionEvaluator(this.compilationUnit, configuration, statement, this.declarations, this.getAccessedClass());
        } else {
            this.conditionEvaluator = new MvelConditionEvaluator(this.getParserConfiguration(workingMemory), this.expression, this.declarations, this.getAccessedClass());
        }
    }

    protected boolean forceJitEvaluator(Object object, InternalWorkingMemory workingMemory, LeftTuple leftTuple) {
        boolean mvelValue;
        try {
            mvelValue = this.conditionEvaluator.evaluate(object, workingMemory, leftTuple);
        }
        catch (ClassCastException cce) {
            mvelValue = false;
        }
        this.jitEvaluator(object, workingMemory, leftTuple);
        return mvelValue;
    }

    protected void jitEvaluator(Object object, InternalWorkingMemory workingMemory, LeftTuple leftTuple) {
        this.jitted = true;
        ExecutorHolder.executor.execute(new ConditionJitter(this, object, workingMemory, leftTuple));
    }

    private void executeJitting(Object object, InternalWorkingMemory workingMemory, LeftTuple leftTuple) {
        InternalRuleBase ruleBase = (InternalRuleBase)workingMemory.getRuleBase();
        if (MemoryUtil.permGenStats.isUsageThresholdExceeded(ruleBase.getConfiguration().getPermGenThreshold())) {
            return;
        }
        try {
            CompositeClassLoader classLoader = ruleBase.getRootClassLoader();
            if (this.analyzedCondition == null) {
                this.analyzedCondition = ((MvelConditionEvaluator)this.conditionEvaluator).getAnalyzedCondition(object, workingMemory, leftTuple);
            }
            this.conditionEvaluator = ASMConditionEvaluatorJitter.jitEvaluator(this.expression, this.analyzedCondition, this.declarations, classLoader, leftTuple);
        }
        catch (Throwable t) {
            logger.warn("Exception jitting: " + this.expression, t);
        }
    }

    @Override
    public ContextEntry createContextEntry() {
        if (this.declarations.length == 0) {
            return null;
        }
        ContextEntry contextEntry = new MvelContextEntry(this.declarations);
        if (this.isUnification) {
            contextEntry = new UnificationContextEntry(contextEntry, this.declarations[0]);
        }
        return contextEntry;
    }

    @Override
    public AbstractHashTable.FieldIndex getFieldIndex() {
        this.indexingDeclaration.getPattern().setOffset(this.declarations[0].getPattern().getOffset());
        return new AbstractHashTable.FieldIndex(this.extractor, this.indexingDeclaration, INDEX_EVALUATOR);
    }

    @Override
    public InternalReadAccessor getFieldExtractor() {
        return this.extractor;
    }

    @Override
    public Declaration[] getRequiredDeclarations() {
        return this.declarations;
    }

    public Declaration getIndexingDeclaration() {
        return this.indexingDeclaration;
    }

    @Override
    public void replaceDeclaration(Declaration oldDecl, Declaration newDecl) {
        for (int i = 0; i < this.declarations.length; ++i) {
            if (!this.declarations[i].equals(oldDecl)) continue;
            if (this.compilationUnit != null) {
                this.compilationUnit.replaceDeclaration(this.declarations[i], newDecl);
            }
            this.declarations[i] = newDecl;
            break;
        }
        if (this.indexingDeclaration != null && this.indexingDeclaration.equals(oldDecl)) {
            this.indexingDeclaration = newDecl;
        }
    }

    public long getListenedPropertyMask(List<String> settableProperties) {
        return this.analyzedCondition != null ? this.calculateMask(this.analyzedCondition, settableProperties) : this.calculateMaskFromExpression(settableProperties);
    }

    private long calculateMaskFromExpression(List<String> settableProperties) {
        String[] simpleExpressions;
        long mask = 0L;
        for (String simpleExpression : simpleExpressions = this.expression.split("\\Q&&\\E|\\Q||\\E")) {
            String propertyName = this.getPropertyNameFromSimpleExpression(simpleExpression);
            if (propertyName.length() == 0) continue;
            if (propertyName.equals("this")) {
                return Long.MAX_VALUE;
            }
            int pos = settableProperties.indexOf(propertyName);
            if (pos < 0 && Character.isUpperCase(propertyName.charAt(0))) {
                propertyName = propertyName.substring(0, 1).toLowerCase() + propertyName.substring(1);
                pos = settableProperties.indexOf(propertyName);
            }
            if (pos < 0) continue;
            mask = BitMaskUtil.set(mask, pos);
        }
        return mask;
    }

    private String getPropertyNameFromSimpleExpression(String simpleExpression) {
        StringBuilder propertyNameBuilder = new StringBuilder();
        int cursor = StringUtils.extractFirstIdentifier(simpleExpression, propertyNameBuilder, 0);
        String propertyName = propertyNameBuilder.toString();
        if (propertyName.equals("this")) {
            if (simpleExpression.charAt(cursor = StringUtils.skipBlanks(simpleExpression, cursor)) != '.') {
                return "this";
            }
            propertyNameBuilder = new StringBuilder();
            StringUtils.extractFirstIdentifier(simpleExpression, propertyNameBuilder, cursor);
            propertyName = propertyNameBuilder.toString();
        }
        return propertyName;
    }

    private long calculateMask(ConditionAnalyzer.Condition condition, List<String> settableProperties) {
        if (condition instanceof ConditionAnalyzer.SingleCondition) {
            return this.calculateMask((ConditionAnalyzer.SingleCondition)condition, settableProperties);
        }
        long mask = 0L;
        for (ConditionAnalyzer.Condition c : ((ConditionAnalyzer.CombinedCondition)condition).getConditions()) {
            mask |= this.calculateMask(c, settableProperties);
        }
        return mask;
    }

    private long calculateMask(ConditionAnalyzer.SingleCondition condition, List<String> settableProperties) {
        String propertyName = this.getFirstInvokedPropertyName(condition.getLeft());
        if (propertyName == null) {
            return Long.MAX_VALUE;
        }
        int pos = settableProperties.indexOf(propertyName);
        if (pos < 0) {
            throw new RuntimeException("Unknown property: " + propertyName);
        }
        return 1L << pos;
    }

    private String getFirstInvokedPropertyName(ConditionAnalyzer.Expression expression) {
        if (!(expression instanceof ConditionAnalyzer.EvaluatedExpression)) {
            return null;
        }
        List<ConditionAnalyzer.Invocation> invocations = ((ConditionAnalyzer.EvaluatedExpression)expression).invocations;
        ConditionAnalyzer.Invocation invocation = invocations.get(0);
        if (invocation instanceof ConditionAnalyzer.MethodInvocation) {
            Method method = ((ConditionAnalyzer.MethodInvocation)invocation).getMethod();
            if (method == null) {
                if (invocations.size() > 1) {
                    invocation = invocations.get(1);
                    if (invocation instanceof ConditionAnalyzer.MethodInvocation) {
                        method = ((ConditionAnalyzer.MethodInvocation)invocation).getMethod();
                    } else if (invocation instanceof ConditionAnalyzer.FieldAccessInvocation) {
                        return ((ConditionAnalyzer.FieldAccessInvocation)invocation).getField().getName();
                    }
                } else {
                    return null;
                }
            }
            return ClassUtils.getter2property(method.getName());
        }
        if (invocation instanceof ConditionAnalyzer.FieldAccessInvocation) {
            return ((ConditionAnalyzer.FieldAccessInvocation)invocation).getField().getName();
        }
        return null;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.packageName);
        out.writeObject(this.expression);
        out.writeObject(this.declarations);
        out.writeObject(this.indexingDeclaration);
        out.writeObject(this.extractor);
        out.writeObject((Object)this.constraintType);
        out.writeBoolean(this.isUnification);
        out.writeBoolean(this.isDynamic);
        out.writeObject(this.fieldValue);
        out.writeObject(this.compilationUnit);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.packageName = (String)in.readObject();
        this.expression = (String)in.readObject();
        this.declarations = (Declaration[])in.readObject();
        this.indexingDeclaration = (Declaration)in.readObject();
        this.extractor = (InternalReadAccessor)in.readObject();
        this.constraintType = (IndexUtil.ConstraintType)((Object)in.readObject());
        this.isUnification = in.readBoolean();
        this.isDynamic = in.readBoolean();
        this.fieldValue = (FieldValue)in.readObject();
        this.compilationUnit = (MVELCompilationUnit)in.readObject();
    }

    @Override
    public boolean isTemporal() {
        return false;
    }

    @Override
    public MvelConstraint clone() {
        Declaration[] clonedDeclarations = new Declaration[this.declarations.length];
        System.arraycopy(this.declarations, 0, clonedDeclarations, 0, this.declarations.length);
        MvelConstraint clone = new MvelConstraint();
        clone.setType(this.getType());
        clone.packageName = this.packageName;
        clone.expression = this.expression;
        clone.constraintType = this.constraintType;
        clone.declarations = clonedDeclarations;
        clone.indexingDeclaration = this.indexingDeclaration;
        clone.extractor = this.extractor;
        clone.isUnification = this.isUnification;
        clone.isDynamic = this.isDynamic;
        clone.conditionEvaluator = this.conditionEvaluator;
        clone.compilationUnit = this.compilationUnit != null ? this.compilationUnit.clone() : null;
        return clone;
    }

    public int hashCode() {
        if (this.isAlphaHashable()) {
            return 29 * this.getLeftForEqualExpression().hashCode() + 31 * this.fieldValue.hashCode();
        }
        return this.expression.hashCode();
    }

    private String getLeftForEqualExpression() {
        return this.expression.substring(0, this.expression.indexOf("==")).trim();
    }

    private boolean isAlphaHashable() {
        return this.fieldValue != null && this.constraintType == IndexUtil.ConstraintType.EQUAL && this.getType() == Constraint.ConstraintType.ALPHA;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != MvelConstraint.class) {
            return false;
        }
        MvelConstraint other = (MvelConstraint)object;
        if (this.isAlphaHashable() ? !other.isAlphaHashable() || !this.getLeftForEqualExpression().equals(other.getLeftForEqualExpression()) || !this.fieldValue.equals(other.fieldValue) : !this.expression.equals(other.expression)) {
            return false;
        }
        if (this.declarations.length != other.declarations.length) {
            return false;
        }
        for (int i = 0; i < this.declarations.length; ++i) {
            if (this.declarations[i].getExtractor().equals(other.declarations[i].getExtractor())) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.expression;
    }

    protected ParserConfiguration getParserConfiguration(InternalWorkingMemory workingMemory) {
        return this.getMVELDialectRuntimeData(workingMemory).getParserConfiguration();
    }

    protected MVELDialectRuntimeData getMVELDialectRuntimeData(InternalWorkingMemory workingMemory) {
        return (MVELDialectRuntimeData)workingMemory.getRuleBase().getPackage(this.packageName).getDialectRuntimeRegistry().getDialectData("mvel");
    }

    public static class PlainIndexEvaluator
    implements IndexEvaluator {
        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            Object value1 = extractor1.getValue(workingMemory, object1);
            Object value2 = extractor2.getValue(workingMemory, object2);
            if (value1 == null) {
                return value2 == null;
            }
            if (value1 instanceof String) {
                return value1.equals(value2.toString());
            }
            return value1.equals(value2);
        }
    }

    public static class UnificationContextEntry
    implements ContextEntry {
        private ContextEntry contextEntry;
        private Declaration declaration;
        private Variable variable;
        private ArrayElementReader reader;

        public UnificationContextEntry() {
        }

        public UnificationContextEntry(ContextEntry contextEntry, Declaration declaration) {
            this.contextEntry = contextEntry;
            this.declaration = declaration;
            this.reader = (ArrayElementReader)this.declaration.getExtractor();
        }

        public ContextEntry getContextEntry() {
            return this.contextEntry;
        }

        public ArrayElementReader getReader() {
            return this.reader;
        }

        public ContextEntry getNext() {
            return this.contextEntry.getNext();
        }

        public void resetFactHandle() {
            this.contextEntry.resetFactHandle();
        }

        public void resetTuple() {
            this.contextEntry.resetTuple();
            this.variable = null;
        }

        public void setNext(ContextEntry entry) {
            this.contextEntry.setNext(entry);
        }

        public void updateFromFactHandle(InternalWorkingMemory workingMemory, InternalFactHandle handle) {
            this.contextEntry.updateFromFactHandle(workingMemory, handle);
        }

        public void updateFromTuple(InternalWorkingMemory workingMemory, LeftTuple tuple) {
            DroolsQuery query = (DroolsQuery)tuple.get(0).getObject();
            Variable v = query.getVariables()[this.reader.getIndex()];
            if (v == null) {
                this.variable = null;
                this.contextEntry.updateFromTuple(workingMemory, tuple);
            } else {
                this.variable = v;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.contextEntry = (ContextEntry)in.readObject();
            this.declaration = (Declaration)in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.contextEntry);
            out.writeObject(this.declaration);
        }

        public Variable getVariable() {
            return this.variable;
        }
    }

    public static class MvelContextEntry
    implements ContextEntry {
        protected ContextEntry next;
        protected LeftTuple leftTuple;
        protected Object right;
        protected Declaration[] declarations;
        protected transient InternalWorkingMemory workingMemory;

        public MvelContextEntry() {
        }

        public MvelContextEntry(Declaration[] declarations) {
            this.declarations = declarations;
        }

        public ContextEntry getNext() {
            return this.next;
        }

        public void setNext(ContextEntry entry) {
            this.next = entry;
        }

        public void updateFromTuple(InternalWorkingMemory workingMemory, LeftTuple leftTuple) {
            this.leftTuple = leftTuple;
            this.workingMemory = workingMemory;
        }

        public void updateFromFactHandle(InternalWorkingMemory workingMemory, InternalFactHandle handle) {
            this.workingMemory = workingMemory;
            this.right = handle.getObject();
        }

        public void resetTuple() {
            this.leftTuple = null;
        }

        public void resetFactHandle() {
            this.workingMemory = null;
            this.right = null;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.leftTuple);
            out.writeObject(this.right);
            out.writeObject(this.declarations);
            out.writeObject(this.next);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.leftTuple = (LeftTuple)in.readObject();
            this.right = in.readObject();
            this.declarations = (Declaration[])in.readObject();
            this.next = (ContextEntry)in.readObject();
        }

        public LeftTuple getLeftTuple() {
            return this.leftTuple;
        }

        public Object getRight() {
            return this.right;
        }

        public Declaration[] getDeclarations() {
            return this.declarations;
        }

        public InternalWorkingMemory getWorkingMemory() {
            return this.workingMemory;
        }
    }

    private static class ExecutorHolder {
        private static final Executor executor = ExecutorProviderFactory.getExecutorProvider().getExecutor();

        private ExecutorHolder() {
        }
    }

    private static class ConditionJitter
    implements Runnable {
        private MvelConstraint mvelConstraint;
        private Object object;
        private InternalWorkingMemory workingMemory;
        private LeftTuple leftTuple;

        private ConditionJitter(MvelConstraint mvelConstraint, Object object, InternalWorkingMemory workingMemory, LeftTuple leftTuple) {
            this.mvelConstraint = mvelConstraint;
            this.object = object;
            this.workingMemory = workingMemory;
            this.leftTuple = leftTuple;
        }

        public void run() {
            this.mvelConstraint.executeJitting(this.object, this.workingMemory, this.leftTuple);
            this.mvelConstraint = null;
            this.object = null;
            this.workingMemory = null;
            this.leftTuple = null;
        }
    }
}

